<!DOCTYPE html>
<html lang="en">
	<head>
		<meta charset="UTF-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<title>{{ __('Order success') }}</title>
		<meta charset="UTF-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<link rel="stylesheet" href="{{ src("assets/axies.css") }}">
		<style>
			@php $font = "Spartan" @endphp

			html * {
				font-size: 1rem;
			}

			@foreach(array_map('basename', glob(public_path("assets/fonts/*", GLOB_ONLYDIR))) as $font_dir)
				@if($font === $font_dir)
					@foreach(array_map('basename', glob(public_path("assets/fonts/{$font_dir}/*"))) as $font_file)
					@if(stripos($font_file, 'italic'))
						@continue
					@endif

					@if(stripos($font_file, 'extralight'))
					@font-face {
					  font-family: Valexa;
					  src: url('/assets/fonts/{{ $font_dir }}/{{ $font_file }}');
					  font-weight: 200;
					  font-style: normal;
					}
					@elseif(stripos($font_file, 'light'))
					@font-face {
					  font-family: Valexa;
					  src: url('/assets/fonts/{{ $font_dir }}/{{ $font_file }}');
					  font-weight: 300;
					  font-style: normal;
					}
					@elseif(stripos($font_file, 'extrabold'))
					@font-face {
					  font-family: Valexa;
					  src: url('/assets/fonts/{{ $font_dir }}/{{ $font_file }}');
					  font-weight: 800;
					  font-style: normal;
					}
					@elseif(stripos($font_file, 'semibold'))
					@font-face {
					  font-family: Valexa;
					  src: url('/assets/fonts/{{ $font_dir }}/{{ $font_file }}');
					  font-weight: 600;
					  font-style: normal;
					}
					@elseif(stripos($font_file, 'bold'))
					@font-face {
					  font-family: Valexa;
					  src: url('/assets/fonts/{{ $font_dir }}/{{ $font_file }}');
					  font-weight: 700;
					  font-style: normal;
					}
					@elseif(stripos($font_file, 'medium'))
					@font-face {
					  font-family: Valexa;
					  src: url('/assets/fonts/{{ $font_dir }}/{{ $font_file }}');
					  font-weight: 500;
					  font-style: normal;
					}
					@elseif(stripos($font_file, 'regular'))
					@font-face {
					  font-family: Valexa;
					  src: url('/assets/fonts/{{ $font_dir }}/{{ $font_file }}');
					  font-weight: 400;
					  font-style: normal;
					}
					@elseif(stripos($font_file, 'black'))
					@font-face {
					  font-family: Valexa;
					  src: url('/assets/fonts/{{ $font_dir }}/{{ $font_file }}');
					  font-weight: 900;
					  font-style: normal;
					}
					@endif
					@endforeach
				@endif
			@endforeach
		</style>
	</head>



	<body>
		<div class="m-0 text-[1.1rem] max-w-[1600px] w-full mx-auto bg-[radial-gradient(whitesmoke,#fff)] flex items-center justify-center min-h-[100vh] p-[2rem_1.5rem]">
			<div class="max-w-[360px] w-full rounded-[.25rem] overflow-hidden m-auto bg-[#fff]">
				<div class="p-[1.5rem] pt-[2rem] flex items-end gap-[1rem]">
					<div class="">
						<svg xmlns="http://www.w3.org/2000/svg" width="55" height="55" viewBox="0 0 256 256"><path fill="tomato" d="M224.4 104.2c-3.9-4.1-7.9-8.3-9.5-12.2s-1.6-9-1.7-14.7c-.1-9.3-.3-20-7.4-27.1s-17.8-7.3-27.1-7.4c-5.7-.1-11.1-.2-14.7-1.7s-8.1-5.6-12.2-9.5C145.2 25.2 137.6 18 128 18s-17.2 7.2-23.8 13.6c-4.1 3.9-8.3 7.9-12.2 9.5s-9 1.6-14.7 1.7c-9.3.1-20 .3-27.1 7.4S42.9 68 42.8 77.3c-.1 5.7-.2 11.1-1.7 14.7s-5.6 8.1-9.5 12.2C25.2 110.8 18 118.4 18 128s7.2 17.2 13.6 23.8c3.9 4.1 7.9 8.3 9.5 12.2s1.6 9 1.7 14.7c.1 9.3.3 20 7.4 27.1s17.8 7.3 27.1 7.4c5.7.1 11.1.2 14.7 1.7s8.1 5.6 12.2 9.5c6.6 6.4 14.2 13.6 23.8 13.6s17.2-7.2 23.8-13.6c4.1-3.9 8.3-7.9 12.2-9.5s9-1.6 14.7-1.7c9.3-.1 20-.3 27.1-7.4s7.3-17.8 7.4-27.1c.1-5.7.2-11.1 1.7-14.7s5.6-8.1 9.5-12.2c6.4-6.6 13.6-14.2 13.6-23.8s-7.2-17.2-13.6-23.8Zm-8.6 39.3c-4.7 4.9-9.5 9.9-12 15.9s-2.5 12.5-2.6 19.1s-.2 15.1-3.9 18.8s-11.4 3.8-18.8 3.9s-13.4.2-19.1 2.6s-11 7.3-15.9 12S132.8 226 128 226s-10.2-5.2-15.5-10.2s-9.9-9.5-15.9-12s-12.5-2.5-19.1-2.6s-15.1-.2-18.8-3.9s-3.8-11.4-3.9-18.8s-.2-13.4-2.6-19.1s-7.3-11-12-15.9S30 132.8 30 128s5.2-10.2 10.2-15.5s9.5-9.9 12-15.9s2.5-12.5 2.6-19.1s.2-15.1 3.9-18.8s11.4-3.8 18.8-3.9s13.4-.2 19.1-2.6s11-7.3 15.9-12S123.2 30 128 30s10.2 5.2 15.5 10.2s9.9 9.5 15.9 12s12.5 2.5 19.1 2.6s15.1.2 18.8 3.9s3.8 11.4 3.9 18.8s.2 13.4 2.6 19.1s7.3 11 12 15.9S226 123.2 226 128s-5.2 10.2-10.2 15.5ZM122 136V80a6 6 0 0 1 12 0v56a6 6 0 0 1-12 0Zm16 36a10 10 0 1 1-10-10a10 10 0 0 1 10 10Z"/></svg>
					</div>
					<div class="flex-1">
						<div class="mb-[1rem] flex items-end">
							<span class="font-[600] uppercase text-[1.3rem] leading-[1]">{{ __('Payment failed') }}</span>
						</div>
						<div class="text-[1.2rem] mt-[.5rem] opacity-75">{{ __("We couldn't proceed your payment") }}</div>
					</div>
				</div>

				<div class="px-[1.5rem]"><hr class=""></div>
				<div class="p-[1.5rem] [&>div:not(:last-child)]:mb-[.75rem]">
					<div class="flex items-center">
						<div class="mr-[1rem] font-[600]">{{ __('Reference number') }}</div>
						<div class="ml-auto">{{ \Str::random(12) }}</div>
					</div>
					<div class="flex items-center">
						<div class="mr-[1rem] font-[600]">{{ __('Date') }}</div>
						<div class="ml-auto">{{ date('Y-m-d') }}</div>
					</div>
					<div class="flex items-center">
						<div class="mr-[1rem] font-[600]">{{ __('Payment method') }}</div>
						<div class="ml-auto">{{ __("Bank card") }}</div>
					</div>
					<div class="flex items-center">
						<div class="mr-[1rem] font-[600]">{{ __('Buyer email') }}</div>
						<div class="ml-auto">{{ \Str::limit(fake()->email(), 15) }}</div>
					</div>
				</div>
				<div class="px-[1.5rem]"><hr class=""></div>
				<div class="p-[1.5rem] [&>div:not(:last-child)]:mb-[.75rem]">
					<div class="flex items-center">
						<div class="mr-[1rem] font-[600]">{{ __('Amount') }}</div>
						<div class="ml-auto">USD {{ fake()->randomFloat(2, 10, 100) }}</div>
					</div>
					<div class="flex items-center">
						<div class="mr-[1rem] font-[600]">{{ __('Payment status') }}</div>
						<div class="ml-auto"><div class="min-w-[80px] text-center p-[.25rem_.75rem] rounded-[.25rem] bg-[#ffe2dc] text-[#e96d56] font-[600]">{{ __('Failed') }}</div></div>
					</div>
				</div>
				<div class="px-[1.5rem]"><hr class=""></div>
				<div class="p-[1.5rem]">
					<a href="" class="capitalize p-[.75rem_1rem] bg-[#3d140d] hover:bg-[#000] transition-all text-[#fff] font-[600] block text-center rounded-[.25rem]">Homepage</a>
				</div>
			</div>
		</div>
	</body>
</html>