@extends('front.axies.master')

@section('body')
<div class="p-[1.5rem]">
	<div class="uppercase bg-[#fff] text-[.8rem] overflow-hidden whitespace-nowrap flex select-none flex-nowrap items-center mb-[1rem] categories-top-menu">
		@foreach(config('categories.category_parents', []) as $category)
		<div data-url="{{ category_url($category['slug']) }}" class="whitespace-nowrap cursor-pointer select-none py-[.5rem] leading-[1]">{{ $category['name'] }}</div>
		@if(!$loop->last)
		<span class="min-w-[2rem] text-center block relative bottom-[2px]"><span class="block w-[1px] mx-auto bg-[#cccccc]">&nbsp;</span></span>
		@endif
		@endforeach
	</div>

	<div class="flex relative justify-center items-center gap-[1rem bg-[#5c46a7] text-[#fff] px-[1.5rem] rounded-[.25rem] bg-cover bg-bottom" id="hero-bg-color" @if(config('app.top_cover')) style="background-image:url('{{ src('storage/images/'.config('app.top_cover')) }}')" @endif>
		<div class="w-[50%] py-[1.5rem] max-[768px]:w-auto">
			<div class="text-[2.2rem] font-[800] mb-[1rem]">{{ __('Your Digital Products Storefront') }}</div>
			<div class="text-[1.2rem] opacity-75 mb-[1.5rem]">{{ __('Discover a wide range of digital products, from software to eBooks, designed to enhance your digital experience and creativity') }}.</div>
			<div class="">
				<a href="{{ route('home.products.filter', ['filter' => 'trending']) }}" class="p-[.5rem_.75rem] rounded-[.25rem] bg-[#ee5337] text-[#fff] inline-flex h-[45px] items-center justify-center">{{ __('Trending items') }}</a>
			</div>
		</div>

		@if(fileExists(public_path("storage/images/side-image.png")))
		<div class="w-[350px] h-[350px] relative overflow-hidden max-[768px]:hidden">
			<div class="absolute top-0 left-0 w-full h-full bg-cover bg-[top_center]" style="background-image:url(/storage/images/side-image.png)"></div>
		</div>
		@endif
	</div>

	<div class="mt-[1.5rem]">
		<div class="featured-items grid grid-cols-4 gap-[1.5rem] mb-[6rem]">
			@if($free_products->count() >= 4)
				@foreach($free_products as $free_product)
				<div title="{{ $free_product->name }}" class="h-[100px] rounded-[.25rem] relative overflow-hidden">
					<a href="{{ item_url($free_product) }}" class="bg-cover bg-center block w-full h-full" style="background-image: url('{{ src("storage/covers/{$free_product->cover}") }}');"></a>
					<span class="absolute z-[1] top-[.75rem] right-[.75rem] group cursor-default opacity-50 add-to-collection" data-id="{{ $free_product->id }}">
						<svg xmlns="http://www.w3.org/2000/svg" :class="{hidden: itemInCollection('{{ $free_product->id }}')}" width="20" height="20" viewBox="0 0 20 20"><path fill="currentColor" d="M13.682 1.682c2.007-.48 3.667.026 4.849 1.094c1.032.934 1.628 2.559 1.432 4.39c-.147 1.374-.893 2.769-2.242 4.22l-7.274 6.923a.7.7 0 0 1-.963-.002L2.266 11.36C1.198 10.227.516 9.15.233 8.118C-.18 6.62-.04 5.107.61 3.875c.77-1.461 2.306-2.329 4.532-2.329c1.522 0 3.12.753 4.805 2.221c1.148-1.066 2.394-1.765 3.735-2.085M9.97 16.883l6.76-6.433c1.138-1.226 1.75-2.37 1.863-3.425c.151-1.415-.29-2.619-.997-3.258c-.859-.777-2.056-1.142-3.588-.776c-1.257.3-2.434 1.02-3.538 2.174a.7.7 0 0 1-.981.025C7.852 3.644 6.397 2.895 5.142 2.895c-1.722 0-2.78.597-3.307 1.598c-.489.926-.597 2.094-.272 3.275c.218.795.786 1.692 1.692 2.655z"/></svg>
						<svg xmlns="http://www.w3.org/2000/svg" :class="{hidden: !itemInCollection('{{ $free_product->id }}')}" width="20" height="20" viewBox="0 0 20 20"><path fill="#ff3b3b" d="M13.67 1.658c2.103-.494 4.165.222 5.135 1.434c.896 1.119 1.303 2.282 1.17 3.998c-.095 1.237-.5 2.154-1.298 3.163c-.147.186-.308.377-.511.609l-.548.618c-.8.903-3.155 3.163-7.103 6.82a.764.764 0 0 1-1.036-.004C6.09 15.12 3.896 13.028 2.89 12.014C1.033 10.14.326 9.05.07 7.293c-.27-1.84.245-3.349 1.398-4.521c1.082-1.1 3.017-1.508 4.928-1.12c1.119.228 2.31.96 3.6 2.181c1.101-1.129 2.327-1.86 3.675-2.175"/></svg>
					</span>
				</div>
				@endforeach
			@else
				@foreach($random_products as $random_product)
				<div title="{{ $random_product->name }}" class="h-[100px] rounded-[.25rem] relative overflow-hidden">
					<a href="{{ item_url($random_product) }}" class="bg-cover bg-center block w-full h-full" style="background-image: url({{ src("storage/covers/{$random_product->cover}") }});"></a>
					<span class="absolute z-[1] top-[.75rem] right-[.75rem] group cursor-default opacity-50 add-to-collection" data-id="{{ $random_product->id }}">
						<svg xmlns="http://www.w3.org/2000/svg" :class="{hidden: itemInCollection('{{ $random_product->id }}')}" width="20" height="20" viewBox="0 0 20 20"><path fill="currentColor" d="M13.682 1.682c2.007-.48 3.667.026 4.849 1.094c1.032.934 1.628 2.559 1.432 4.39c-.147 1.374-.893 2.769-2.242 4.22l-7.274 6.923a.7.7 0 0 1-.963-.002L2.266 11.36C1.198 10.227.516 9.15.233 8.118C-.18 6.62-.04 5.107.61 3.875c.77-1.461 2.306-2.329 4.532-2.329c1.522 0 3.12.753 4.805 2.221c1.148-1.066 2.394-1.765 3.735-2.085M9.97 16.883l6.76-6.433c1.138-1.226 1.75-2.37 1.863-3.425c.151-1.415-.29-2.619-.997-3.258c-.859-.777-2.056-1.142-3.588-.776c-1.257.3-2.434 1.02-3.538 2.174a.7.7 0 0 1-.981.025C7.852 3.644 6.397 2.895 5.142 2.895c-1.722 0-2.78.597-3.307 1.598c-.489.926-.597 2.094-.272 3.275c.218.795.786 1.692 1.692 2.655z"/></svg>
						<svg xmlns="http://www.w3.org/2000/svg" :class="{hidden: !itemInCollection('{{ $random_product->id }}')}" width="20" height="20" viewBox="0 0 20 20"><path fill="#ff3b3b" d="M13.67 1.658c2.103-.494 4.165.222 5.135 1.434c.896 1.119 1.303 2.282 1.17 3.998c-.095 1.237-.5 2.154-1.298 3.163c-.147.186-.308.377-.511.609l-.548.618c-.8.903-3.155 3.163-7.103 6.82a.764.764 0 0 1-1.036-.004C6.09 15.12 3.896 13.028 2.89 12.014C1.033 10.14.326 9.05.07 7.293c-.27-1.84.245-3.349 1.398-4.521c1.082-1.1 3.017-1.508 4.928-1.12c1.119.228 2.31.96 3.6 2.181c1.101-1.129 2.327-1.86 3.675-2.175"/></svg>
					</span>
				</div>
				@endforeach
			@endif
		</div>

		<div class="mb-[4rem]">
			<div class="mb-[1rem]" id="latest-items">
				<div class="text-[1.5rem] uppercase font-[600] mb-[.5rem]">{{ __('Latest items') }}</div>
				<div class="text-[1.1rem] leading-[1.5] max-w-[1000px] leading-[1.8]">{{ __('Explore our top-rated digital products, handpicked for their quality and innovation. From cutting-edge software to captivating eBooks, find everything you need to elevate your digital journey') }}</div>
			</div>

			@if($newest_products->count())
			<div class="grid grid-cols-6 max-[1024px]:grid-cols-5 max-[768px]:grid-cols-4 max-[600px]:grid-cols-3 max-[600px]:[&>div:nth-child(5)]:block max-[600px]:[&>div:nth-child(6)]:block max-[768px]:[&>div:nth-child(5)]:hidden max-[1024px]:[&>div:nth-child(6)]:hidden max-[400px]:grid-cols-2 max-[400px]:[&>div:nth-child(6)]:block gap-[1.5rem] mb-[1.5rem]">
				@foreach(array_slice($newest_products->all(), 0, 6) as $newest_product)
				<div class="relative">
					<span class="absolute z-[1] top-[.75rem] right-[.75rem] group cursor-default opacity-50 add-to-collection" data-id="{{ $newest_product->id }}">
						<svg xmlns="http://www.w3.org/2000/svg" :class="{hidden: itemInCollection('{{ $newest_product->id }}')}" width="20" height="20" viewBox="0 0 20 20"><path fill="currentColor" d="M13.682 1.682c2.007-.48 3.667.026 4.849 1.094c1.032.934 1.628 2.559 1.432 4.39c-.147 1.374-.893 2.769-2.242 4.22l-7.274 6.923a.7.7 0 0 1-.963-.002L2.266 11.36C1.198 10.227.516 9.15.233 8.118C-.18 6.62-.04 5.107.61 3.875c.77-1.461 2.306-2.329 4.532-2.329c1.522 0 3.12.753 4.805 2.221c1.148-1.066 2.394-1.765 3.735-2.085M9.97 16.883l6.76-6.433c1.138-1.226 1.75-2.37 1.863-3.425c.151-1.415-.29-2.619-.997-3.258c-.859-.777-2.056-1.142-3.588-.776c-1.257.3-2.434 1.02-3.538 2.174a.7.7 0 0 1-.981.025C7.852 3.644 6.397 2.895 5.142 2.895c-1.722 0-2.78.597-3.307 1.598c-.489.926-.597 2.094-.272 3.275c.218.795.786 1.692 1.692 2.655z"/></svg>
						<svg xmlns="http://www.w3.org/2000/svg" :class="{hidden: !itemInCollection('{{ $newest_product->id }}')}" width="20" height="20" viewBox="0 0 20 20"><path fill="#ff3b3b" d="M13.67 1.658c2.103-.494 4.165.222 5.135 1.434c.896 1.119 1.303 2.282 1.17 3.998c-.095 1.237-.5 2.154-1.298 3.163c-.147.186-.308.377-.511.609l-.548.618c-.8.903-3.155 3.163-7.103 6.82a.764.764 0 0 1-1.036-.004C6.09 15.12 3.896 13.028 2.89 12.014C1.033 10.14.326 9.05.07 7.293c-.27-1.84.245-3.349 1.398-4.521c1.082-1.1 3.017-1.508 4.928-1.12c1.119.228 2.31.96 3.6 2.181c1.101-1.129 2.327-1.86 3.675-2.175"/></svg>
					</span>

					<a href="{{ item_url($newest_product) }}" class="relative block mb-[.5rem]">
						<img src="{{ src("storage/covers/{$newest_product->cover}") }}" class="rounded-[.25rem]">
					</a>
					<div class="">
						<a href="{{ item_url($newest_product) }}" class="block">{{ limit($newest_product->name, 50) }}</a>
					</div>
				</div>
				@endforeach
			</div>

			<div class="grid grid-cols-8 max-[864px]:grid-cols-6 max-[864px]:[&>div:nth-child(n+7)]:hidden max-[650px]:grid-cols-5 max-[650px]:[&>div:nth-child(n+6)]:hidden max-[560px]:grid-cols-4 max-[560px]:[&>div:nth-child(n+5)]:hidden gap-[1.5rem] mb-[1.5rem] bg-[#f8f8f8] p-[1.5rem] rounded-[.25rem]">
				@foreach(array_slice($newest_products->all(), 6) as $newest_product)
				<div class="">
					<a href="{{ item_url($newest_product) }}" class="relative block">
						<img src="{{ src("storage/covers/{$newest_product->cover}") }}" class="rounded-[.25rem]">
					</a>
				</div>
				@endforeach
			</div>
			@endif
		</div>

		@if($trending_products->count())
		<div class="mb-[4rem]" id="trending-items">
			<div class="mb-[1rem]">
				<div class="text-[1.5rem] uppercase font-[600] mb-[.5rem]">{{ __('Trending items') }}</div>
				<div class="text-[1.1rem] leading-[1.5] max-w-[1000px] leading-[1.8]">{{ __('Check out our trending digital products, featuring the latest software, eBooks, and tools that everyone is talking about') }}</div>
			</div>

			<div class="flex gap-[1.5rem] max-[550px]:grid max-[550px]:grid-col-1">
				@php
					$first_trending_product = $trending_products->first();
				@endphp
				<div class="w-[350px] max-[650px]:w-[50%] max-[560px]:flex max-[560px]:gap-[1.5rem] max-[400px]:block bg-[#fafafa] max-[560px]:w-full p-[1.5rem] rounded-[.25rem]">
					<a href="{{ item_url($first_trending_product) }}" class="block mb-[1rem] w-[300px] h-[300px] max-[650px]:w-full max-[650px]:h-[250px] max-[560px]:h-auto max-[560px]:mb-0 max-[400px]:mb-[1rem] max-[400px]:h-[250px] bg-cover bg-center h-[100px] rounded-[.25rem]" style="background-image: url('{{ src("storage/covers/{$first_trending_product->cover}") }}');"></a>
					<div class="">
						<a href="{{ item_url($first_trending_product) }}" class="capitalize font-[600] block mb-[.75rem]">{{ $first_trending_product->name }}</a>
						<div class="flex items-center gap-[.25rem] mb-[1.5rem]">
							@foreach(rating($first_trending_product->fake_rating ?? $first_trending_product->rating ?? '0') as $rating_img)
							<img src="/assets/images/{{ $rating_img }}" class="w-[25px] h-[25px]">
							@endforeach
						</div>
						<div class="flex items-end gap-[1rem] justify-between leading-[1]">
							<div data-id="{{ $first_trending_product->id }}" class="buy-now p-[.75rem] border-[1px] rounded-[.25rem] bg-[#ee5337] text-[#fff] border-[#ee5337] table cursor-pointer">{{ __('Buy now') }}</div>
							<div class="font-[600] text-[1.2rem]">{{ price($first_trending_product->price) }}</div>
						</div>
					</div>
				</div>

				<div class="flex-1 grid grid-cols-3 max-[1024px]:grid-cols-2 max-[1024px]:[&>a:nth-child(n+5)]:hidden max-[768px]:grid-cols-2 max-[768px]:[&>a:nth-child(n+5)]:block max-[650px]:grid-cols-2 max-[650px]:[&>a:nth-child(n+5)]:hidden gap-[1.5rem] h-auto max-[560px]:h-[300px] max-[560px]:w-full">
					@foreach(array_slice($trending_products->all(), 1) as $trending_product)
						<div class="overflow-hidden bg-cover block bg-center relative rounded-[.25rem] group" style="background-image: url('{{ src("storage/covers/{$trending_product->cover}") }}');" title="{{ $trending_product->name }}">
							<a href="{{ item_url($trending_product) }}" class="absolute w-full h-full left-0 top-0 block"></a>
							<span class="absolute z-[1] top-[.75rem] right-[.75rem] group cursor-default opacity-50 add-to-collection" data-id="{{ $trending_product->id }}">
								<svg xmlns="http://www.w3.org/2000/svg" :class="{hidden: itemInCollection('{{ $trending_product->id }}')}" width="20" height="20" viewBox="0 0 20 20"><path fill="currentColor" d="M13.682 1.682c2.007-.48 3.667.026 4.849 1.094c1.032.934 1.628 2.559 1.432 4.39c-.147 1.374-.893 2.769-2.242 4.22l-7.274 6.923a.7.7 0 0 1-.963-.002L2.266 11.36C1.198 10.227.516 9.15.233 8.118C-.18 6.62-.04 5.107.61 3.875c.77-1.461 2.306-2.329 4.532-2.329c1.522 0 3.12.753 4.805 2.221c1.148-1.066 2.394-1.765 3.735-2.085M9.97 16.883l6.76-6.433c1.138-1.226 1.75-2.37 1.863-3.425c.151-1.415-.29-2.619-.997-3.258c-.859-.777-2.056-1.142-3.588-.776c-1.257.3-2.434 1.02-3.538 2.174a.7.7 0 0 1-.981.025C7.852 3.644 6.397 2.895 5.142 2.895c-1.722 0-2.78.597-3.307 1.598c-.489.926-.597 2.094-.272 3.275c.218.795.786 1.692 1.692 2.655z"/></svg>
								<svg xmlns="http://www.w3.org/2000/svg" :class="{hidden: !itemInCollection('{{ $trending_product->id }}')}" width="20" height="20" viewBox="0 0 20 20"><path fill="#ff3b3b" d="M13.67 1.658c2.103-.494 4.165.222 5.135 1.434c.896 1.119 1.303 2.282 1.17 3.998c-.095 1.237-.5 2.154-1.298 3.163c-.147.186-.308.377-.511.609l-.548.618c-.8.903-3.155 3.163-7.103 6.82a.764.764 0 0 1-1.036-.004C6.09 15.12 3.896 13.028 2.89 12.014C1.033 10.14.326 9.05.07 7.293c-.27-1.84.245-3.349 1.398-4.521c1.082-1.1 3.017-1.508 4.928-1.12c1.119.228 2.31.96 3.6 2.181c1.101-1.129 2.327-1.86 3.675-2.175"/></svg>
							</span>
						</div>
					@endforeach
				</div>
			</div>
		</div>
		@endif

		<div class="mb-[4rem]" id="free-items">
			<div class="mb-[1rem]">
				<div class="text-[1.5rem] uppercase font-[600] mb-[.5rem]">{{ __('Featured items') }}</div>
				<div class="text-[1.1rem] leading-[1.5] max-w-[1000px] leading-[1.8]">{{ __("Explore a handpicked assortment of our top products from this week's lineup") }}</div>
			</div>

			@if($featured_products->count())
			<div class="grid grid-cols-6 max-[1024px]:grid-cols-5 max-[768px]:grid-cols-4 max-[600px]:grid-cols-3 max-[600px]:[&>div:nth-child(5)]:block max-[600px]:[&>div:nth-child(6)]:block max-[768px]:[&>div:nth-child(5)]:hidden max-[1024px]:[&>div:nth-child(6)]:hidden gap-[1.5rem] mb-[1.5rem]">
				@foreach($featured_products as $featured_product)
				<div class="" title="{{ $featured_product->name }}">
					<div class="relative block mb-[.5rem]">
						<a href="{{ item_url($featured_product) }}" class="block">
							<img src="{{ src("storage/covers/{$featured_product->cover}") }}" class="rounded-[.25rem]">
						</a>
						<span class="absolute z-[1] top-[.75rem] right-[.75rem] group cursor-default opacity-50 add-to-collection" data-id="{{ $featured_product->id }}">
							<svg xmlns="http://www.w3.org/2000/svg" :class="{hidden: itemInCollection('{{ $featured_product->id }}')}" width="20" height="20" viewBox="0 0 20 20"><path fill="currentColor" d="M13.682 1.682c2.007-.48 3.667.026 4.849 1.094c1.032.934 1.628 2.559 1.432 4.39c-.147 1.374-.893 2.769-2.242 4.22l-7.274 6.923a.7.7 0 0 1-.963-.002L2.266 11.36C1.198 10.227.516 9.15.233 8.118C-.18 6.62-.04 5.107.61 3.875c.77-1.461 2.306-2.329 4.532-2.329c1.522 0 3.12.753 4.805 2.221c1.148-1.066 2.394-1.765 3.735-2.085M9.97 16.883l6.76-6.433c1.138-1.226 1.75-2.37 1.863-3.425c.151-1.415-.29-2.619-.997-3.258c-.859-.777-2.056-1.142-3.588-.776c-1.257.3-2.434 1.02-3.538 2.174a.7.7 0 0 1-.981.025C7.852 3.644 6.397 2.895 5.142 2.895c-1.722 0-2.78.597-3.307 1.598c-.489.926-.597 2.094-.272 3.275c.218.795.786 1.692 1.692 2.655z"/></svg>
							<svg xmlns="http://www.w3.org/2000/svg" :class="{hidden: !itemInCollection('{{ $featured_product->id }}')}" width="20" height="20" viewBox="0 0 20 20"><path fill="#ff3b3b" d="M13.67 1.658c2.103-.494 4.165.222 5.135 1.434c.896 1.119 1.303 2.282 1.17 3.998c-.095 1.237-.5 2.154-1.298 3.163c-.147.186-.308.377-.511.609l-.548.618c-.8.903-3.155 3.163-7.103 6.82a.764.764 0 0 1-1.036-.004C6.09 15.12 3.896 13.028 2.89 12.014C1.033 10.14.326 9.05.07 7.293c-.27-1.84.245-3.349 1.398-4.521c1.082-1.1 3.017-1.508 4.928-1.12c1.119.228 2.31.96 3.6 2.181c1.101-1.129 2.327-1.86 3.675-2.175"/></svg>
						</span>
					</div>
					<div class="">
						<a href="{{ item_url($featured_product) }}" class="block">{{ limit($featured_product->name, 50) }}</a>
					</div>
				</div>
				@endforeach
			</div>
			@endif
		</div>

		<div class="" id="from-our-blog">
			<div class="mb-[1rem]">
				<div class="text-[1.5rem] uppercase font-[600] mb-[.5rem]">{{ __('From our blog') }}</div>
				<div class="text-[1.1rem] leading-[1.5] max-w-[1000px] leading-[1.8]">{{ __('Explore our diverse blog posts, offering insights, tips, and updates on the latest trends in the digital world') }}</div>
			</div>

			@if($posts->count())
			<div class="grid grid-cols-4 max-[768px]:grid-cols-3 max-[768px]:[&>div:nth-child(n+4)]:hidden max-[560px]:grid-cols-2 max-[560px]:[&>div:nth-child(n+3)]:hidden gap-[1.5rem]">
				@foreach($posts as $post)
				<div class="">
					<div class="relative flex mb-[1rem]">
						<img src="{{ src("storage/posts/{$post->cover}") }}" class="rounded-[.25rem]">
						@isset($post->category['slug'])
						<a href="{{ route('home.blog.category', ['category' => $post->category['slug']]) }}" class="absolute bottom-[.5rem] right-[.5rem] table text-[.9rem] p-[.35rem_.75rem] font-[500] rounded-[.25rem] [&.red]:bg-[#ff31311f] [&.yellow]:bg-[#ffe40026] [&.green]:bg-[#0cff0026] backdrop-blur-[3px] text-[#fff] {{ ['yellow', 'red', 'green'][rand(0,2)] }}">{{ $post->category['name'] }}</a>
						@endisset
					</div>
					<div class="">
						<a href="{{ post_url($post->slug) }}" class="block mb-[1rem] h-[45px] overflow-hidden">{{ $post->name }}</a>
						<a href="{{ post_url($post->slug) }}" class="table p-[.5rem_.75rem] border-[1px] border-[#684f8c] text-[#684f8c] rounded-[.25rem] font-[600]">{{ __('Read more') }}</a>
					</div>
				</div>
				@endforeach
			</div>
			@endif
		</div>
	</div>
</div>
@endsection