@extends('front.axies.master')

@section('body')
<div class="">
	<div class="uppercase p-[1rem_1.5rem] mt-0 border-y-[1px] border-[#fafafa] bg-[#fcfcfc] text-[.8rem] overflow-hidden whitespace-nowrap flex flex-nowrap items-center gap-x-[1rem]">
		<a href="/" class="">{{ __('Home') }}</a>
		<span class="w-[1px] bg-[#cccccc] block relative bottom-[2px]">&nbsp;</span>
		<div class="">{{ __($page->name) }}</div>
	</div>

	<div class="flex">
		{{-- PAGE DESCRIPTION --}}
		<div class="p-[1.5rem]">
			<div class="mb-[1.5rem] py-[1rem] text-[.9rem] uppercase font-[600] table relative after:absolute after:rounded-full after:content-[''] after:h-[5px] after:bottom-0 after:left-0 after:w-[30%] after:bg-[#e6513d]">
				{{ __($page->name) }}
			</div>

			{!! $page->content !!}
		</div>

		{{-- OTHER PAGES --}}
		<div class="max-w-[320px] min-w-[320px] w-full p-[1.5rem]">
			<div class="p-[1rem] rounded-[.25rem] bg-[#a6f4f4] text-[.9rem] uppercase mb-[1.5rem] font-[600]">{{ __('Other resources') }}</div>
			@foreach(config('pages', []) as $_page)
			@if($_page['slug'] !== $page->slug)
			<div class="mb-[1.5rem]">
				<a href="{{ route('home.page', ['slug' => $_page['slug']]) }}" class="block mb-[.5rem] font-[600]">{{ $_page['name'] }}</a>
				<div class="opacity-60">{{ $_page['short_description'] }}</div>
			</div>
			@endif
			@endforeach
		</div>
	</div>
</div>
@endsection