@extends('front.axies.master')

@section('body')
<div class="uppercase mb-[1.5rem] p-[1rem_1.5rem] mt-0 border-y-[1px] border-[#fafafa] bg-[#fcfcfc] text-[.8rem] overflow-hidden whitespace-nowrap flex flex-nowrap items-center gap-x-[1rem]">
	<a href="" class="">{{ __('Home') }}</a>
	<span class="w-[1px] bg-[#cccccc] block relative bottom-[2px]">&nbsp;</span>
	<a href="" class="">{{ __('Blog') }}</a>
	<span class="w-[1px] bg-[#cccccc] block relative bottom-[2px]">&nbsp;</span>
	<div class="">{{ \Str::limit($post->name, 60) }}</div>
</div>

<div class="p-[1.5rem] max-[960px]:px-0 flex gap-[2rem] bg-[#f7644a05] m-[1.5rem] mt-0 border-b-[.25rem] border-[#f7644a] rounded-t-[.75rem] max-[850px]:block">
	<div class="bg-cover bg-[bottom_center] rounded-[.75rem] h-[300px] w-[400px] max-[850px]:mb-[1.5rem] max-[850px]:w-full" style="background-image: url('{{ src("storage/posts/{$post->cover}")  }}');"></div>
	<div class="flex-1 flex flex-col">
		<div class="text-[1.6rem] mb-[.75rem] capitalize">{{ $post->name }}</div>
		<div class="mb-[1rem]">{{ $post->short_description }}</div>
		<div class="flex w-fit mt-auto">
			<div class="flex items-end gap-[.5rem]">
				<svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 24 24"><g fill="none"><path stroke="currentColor" stroke-linecap="round" stroke-width="1.5" d="M14 22h-4c-3.771 0-5.657 0-6.828-1.172S2 17.771 2 14v-2c0-3.771 0-5.657 1.172-6.828S6.229 4 10 4h4c3.771 0 5.657 0 6.828 1.172S22 8.229 22 12v2c0 3.771 0 5.657-1.172 6.828c-.653.654-1.528.943-2.828 1.07M7 4V2.5M17 4V2.5M21.5 9H10.75M2 9h3.875"/><path fill="currentColor" d="M18 17a1 1 0 1 1-2 0a1 1 0 0 1 2 0m0-4a1 1 0 1 1-2 0a1 1 0 0 1 2 0m-5 4a1 1 0 1 1-2 0a1 1 0 0 1 2 0m0-4a1 1 0 1 1-2 0a1 1 0 0 1 2 0m-5 4a1 1 0 1 1-2 0a1 1 0 0 1 2 0m0-4a1 1 0 1 1-2 0a1 1 0 0 1 2 0"/></g></svg>
				<div class="leading-[1]">{{ $post->created_at->format('j M, Y') }}</div>
			</div>
		</div>
	</div>
</div>

<div class="p-[1.5rem]" id="post">
	<div class="flex gap-[1.5rem] max-[1024px]:block">
		<div class="flex-1 max-[1024px]:mb-[2.5rem]">
			<div class="flex gap-[1.5rem]">
				<div class="w-[100px] border-r-[1px] pl-[1.5rem] [&>a:not(:last-child)]:mb-[1rem] opacity-80 max-[960px]:hidden">
					<a href="{{ share_link('vk', $post_link, $post->name) }}" class="bg-cover bg-center rounded-[.75rem] w-[50px] table h-[50px] ml-ato" style="background-image: url(/assets/images/social/vkontakte.png);"></a>
					<a href="{{ share_link('twitter', $post_link, $post->name) }}" class="bg-cover bg-center rounded-[.75rem] w-[50px] table h-[50px] ml-ato" style="background-image: url(/assets/images/social/twitter.png);"></a>
					<a href="{{ share_link('facebook', $post_link, $post->name) }}" class="bg-cover bg-center rounded-[.75rem] w-[50px] table h-[50px] ml-ato" style="background-image: url(/assets/images/social/facebook.png);"></a>
					<a href="{{ share_link('linkedin', $post_link, $post->name) }}" class="bg-cover bg-center rounded-[.75rem] w-[50px] table h-[50px] ml-ato" style="background-image: url(/assets/images/social/linkedin.png);"></a>
					<a href="{{ share_link('reddit', $post_link, $post->name) }}" class="bg-cover bg-center rounded-[.75rem] w-[50px] table h-[50px] ml-ato" style="background-image: url(/assets/images/social/reddit.png);"></a>
					<a href="{{ share_link('whatsapp', $post_link, $post->name) }}" class="bg-cover bg-center rounded-[.75rem] w-[50px] table h-[50px] ml-ato" style="background-image: url(/assets/images/social/whatsapp.png);"></a>
					<a href="{{ share_link('telegram', $post_link, $post->name) }}" class="bg-cover bg-center rounded-[.75rem] w-[50px] table h-[50px] ml-ato" style="background-image: url(/assets/images/social/telegram.png);"></a>
					<a href="{{ share_link('tumblr', $post_link, $post->name) }}" class="bg-cover bg-center rounded-[.75rem] w-[50px] table h-[50px] ml-ato" style="background-image: url(/assets/images/social/tumblr.png);"></a>
				</div>

				<div class="flex-1">
					{!! $post->content !!}
				</div>
			</div>
		</div>

		<div class="max-w-[250px] w-full min-w-[250px] border-l-[1px] pl-[1.5rem] max-[1024px]:max-w-full max-[1024px]:w-full max-[1024px]:pl-0 max-[1024px]:border-0 max-[1024px]:grid max-[1024px]:grid-cols-3 max-[1024px]:gap-[1.5rem] max-[768px]:grid-cols-2 max-[560px]:grid-cols-1">
			@foreach($related_posts as $related_post)
			<div class="mb-[1rem] max-[1024px]:mb-0 rounded-[.5rem] overflow-hidden bg-[#f6f6f6]">
				<a href="{{ route('home.post', ['slug' => $related_post->slug]) }}" class="flex bg-cover bg-[bottom_center] h-[150px] w-full" style="background-image: url('{{ src("storage/posts/{$related_post->cover}") }}');">
				</a>
				<a href="{{ route('home.post', ['slug' => $related_post->slug]) }}" class="px-[1rem] pb-[.5rem] text-center block mt-[.5rem] first-letter:font-[600] first-letter:text-[tomato]">{{ $related_post->name }}</a>
			</div>
			@endforeach
		</div>
	</div>
</div>
@endsection

