@extends('front.axies.master')

@php
$categories = ['Development', 'Business', 'Finance & Accounting', 'IT & Software', 'Office Productivity', 'Personal Development', 'Design', 'Marketing', 'Lifestyle', 'Photography & Video', 'Digital Photography', 'Photography', 'Portrait Photography', 'Photography Tools', 'Commercial Photography', 'Video Design', 'Other Photography & Video', 'Health & Fitness', 'Fitness', 'General Health', 'Sports', 'Nutrition & Diet', 'Yoga', 'Mental Health', 'Martial Arts & Self Defense', 'Safety & First Aid', 'Dance', 'Meditation', 'Other Health & Fitness', 'Music', 'Instruments', 'Music Production', 'Music Fundamentals', 'Vocal', 'Music Techniques', 'Music Software', 'Other Music', 'Teaching & Academics', 'Engineering', 'Humanities', 'Math', 'Science', 'Online Education', 'Social Science', 'Language Learning', 'Teacher Training', 'Test Prep', 'Other Teaching & Academics'];

$post_covers = glob(public_path("storage/posts/*"));
$post_covers = array_map('basename', $post_covers);
@endphp

@section('body')
<div class="uppercase p-[1rem_1.5rem] mt-0 border-y-[1px] border-[#fafafa] bg-[#fcfcfc] text-[.8rem] overflow-hidden whitespace-nowrap flex flex-nowrap items-center gap-x-[1rem]">
	<a href="" class="">{{ __('Home') }}</a>
	<span class="w-[1px] bg-[#cccccc] block relative bottom-[2px]">&nbsp;</span>
	<a href="" class="">{{ __('Blog') }}</a>
	<span class="w-[1px] bg-[#cccccc] block relative bottom-[2px]">&nbsp;</span>
	<div class="">{{ \Str::limit("Lorem ipsum, dolor sit amet consectetur adipisicing elit Voluptatibus", 60) }}</div>
</div>

<div class="p-[1.5rem] flex flex-col py-[1rem] gap-[1rem] text-center py-[2rem] m-[1.5rem] bg-[#917fff] text-[#fff] rounded-[.5rem] mb-0">
	<div class="mb-[1rem] text-[1.5rem]">Lorem ipsum, dolor sit amet consectetur</div>
	<form class="flex items-center justify-center mx-auto rounded-[.5rem] overflow-hidden max-w-[500px] w-full">
		<input type="search" class="w-full h-[50px] px-[1rem] border-0 focus:outline-none placeholder-[#cbd5e0]" placeholder="Enter a title or some keywords...">
		<button class="p-[.5rem_1.5rem] h-[50px] bg-[#ffd586] text-[#fff] flex items-center font-semibold" type="submit">
			{{ __('Search') }}
		</button>
	</form>
</div>

<div class="p-[1.5rem]" id="">
	<div class="">
		<div class="grid grid-cols-4 gap-[1.5rem]">
			@foreach(array_slice(shuffle_array($post_covers), 0, 8) as $post_cover)
			<div class="">
				<a class="flex mb-[1rem]">
					<img src="/storage/posts/{{ $post_cover }}" class="rounded-[1rem]">
				</a>
				<a href="" class="uppercase text-[.8rem] table mb-[1rem] bg-[#fff7bf] font-[600] text-[#4e4715] p-[.35rem_.75rem] pb-[.25rem] rounded-full">{{ fake()->text(15) }}</a>
				<a href="" class="font-[600] mb-[.75rem] block h-[44px] overflow-hidden">{{ fake()->text(50) }}</a>
				<div class="opacity-75 text-[.9rem] mb-[.75rem] h-[44px] overflow-hidden">{{ fake()->text(80) }}</div>
				<div class="flex items-end justify-between gap-[1rem]">
					<div class="">
						{{ fake()->dateTime()->format('j M, Y') }}
					</div>
					<a href="" class="block uppercase p-[.5rem_.5rem] pb-[.35rem] ml-auto border-[1px] rounded-[.5rem] bg-[#6f5dff] text-[#fff] text-[.8rem]">
						<svg xmlns="http://www.w3.org/2000/svg" transform="rotate(90)" width="20" height="20" viewBox="0 0 24 24"><path fill="currentColor" d="M17 7H9q-.425 0-.712-.288T8 6t.288-.712T9 5h9q.425 0 .713.288T19 6v9q0 .425-.288.713T18 16t-.712-.288T17 15zm-5 5H4q-.425 0-.712-.288T3 11t.288-.712T4 10h9q.425 0 .713.288T14 11v9q0 .425-.288.713T13 21t-.712-.288T12 20z"/></svg>
					</a>
				</div>
			</div>
			@endforeach
		</div>
	</div>
</div>
@endsection