@extends('front.axies.master')

@section('body')
<div class="p-[1.5rem]" id="pricing">
	<div class="uppercase bg-[#fff] text-[.8rem] overflow-hidden whitespace-nowrap flex flex-nowrap items-center gap-x-[1rem] mb-[1rem]">
		@foreach(config('categories.category_parents') as $category)
		<a href="{{ category_url($category['slug']) }}" class="whitespace-nowrap py-[.5rem] leading-[1]">{{ $category['name'] }}</a>
		@if(!$loop->last)
		<span class="w-[1px] bg-[#cccccc] block relative bottom-[2px]">&nbsp;</span>
		@endif
		@endforeach
	</div>

	<div class="text-center mb-[2rem] min-h-[300px] flex flex-col justify-center items-center p-[2rem_1.5rem] bg-[#5c46a7] text-[#fff] mb-[3rem] rounded-[.25rem]">
		<div class="">
			<div class="text-[2.5rem] font-[700] capitalize mb-[1.5rem]">{{ __('Discover our prepaid credit plans') }}</div>
			<div class="text-[1.2rem] leading-[1.8] max-w-[700px] mx-auto">{{ __('Save big with our prepaid credit plans! Enjoy reduced prices, instant access, no monthly fees, and full control over your spending. Top up anytime!') }}</div>
		</div>
	</div>

	<div class="">
		<div class="grid grid-cols-4 gap-[1.5rem]">
			@foreach($packs as $pack)
			<div class="rounded-[.25rem] rounded-t-0 bg-[#fffcec] [&.popular]:bg-[#fff] [&.popular]:shadow-[0_0_0_2px_#404a86] {{ $pack->popular ? 'popular' : '' }}">
				<div class="p-[1rem_1.5rem] pb-0">
					<div class="font-[600] mb-[.75rem] uppercase">{{ $pack->name }}</div>
					<div class="border-b-[1px] pb-[1rem] opacity-60">{{ $pack->subheading }}</div>
				</div>
				<div class="p-[1rem_1.5rem]">
					<div class="text-[2rem] font-[700]">{{ price($pack->amount) }}</div>
				</div>
				<div class="p-[1rem_1.5rem] pt-0">
					<a href="{{ route('home.checkout', ['type' => 'prepaid-credits', 'id' => $pack->id]) }}" class="p-[.5rem_1rem] h-[45px] flex items-center justify-center w-full rounded-[.25rem] text-[#fff] bg-[#404a86] uppercase">{{ __('Top up') }}</a>
				</div>
				<div class="p-[1rem_1.5rem] [&>div:not(:last-child)]:mb-[.75rem]">
					@foreach($pack->specs as $spec)
					<div class="flex items-start gap-[.5rem]">
						<div class="w-[25px] h-[25px] p-[.35rem] rounded-[.25rem] border-[1px] border-[#ffe064] bg-[#fff]">
							<img src="/assets/images/checkbox-2.webp" class="w-full">
						</div>
						<div class="flex-1">
							{{ $spec }}
						</div>
					</div>
					@endforeach
				</div>
			</div>
			@endforeach
		</div>
	</div>
</div>
@endsection