@extends('front.axies.master')

@section('body')
<div class="p-[1.5rem]" id="pricing">
	<div class="uppercase bg-[#fff] text-[.8rem] overflow-hidden whitespace-nowrap flex flex-nowrap items-center gap-x-[1rem] mb-[1rem]">
		@foreach(config('categories.category_parents') as $category)
		<a href="{{ category_url($category['slug']) }}" class="whitespace-nowrap py-[.5rem] leading-[1]">{{ $category['name'] }}</a>
		@if(!$loop->last)
		<span class="w-[1px] bg-[#cccccc] block relative bottom-[2px]">&nbsp;</span>
		@endif
		@endforeach
	</div>

	<div class="text-center mb-[2rem] min-h-[300px] flex flex-col justify-center items-center p-[2rem_1.5rem] bg-[#5c46a7] text-[#fff] mb-[3rem] rounded-[.25rem]">
		<div class="">
			<div class="text-[2.5rem] font-[700] capitalize mb-[1.5rem]">{{ __('Discover our membership plans') }}</div>
			<div class="text-[1.2rem] leading-[1.8] max-w-[700px] mx-auto">{{ __("Upgrade your journey with our tailored membership plans! Whether Basic, Plus, or Premium, there's something for everyone. Subscribe now and enjoy exclusive perks!") }}</div>
		</div>
	</div>

	<div class="">
		<div class="grid grid-cols-4 gap-[1.5rem]">
			@foreach($subscriptions as $subscription)
			<div class="rounded-[.25rem] rounded-t-0 bg-[#fffcec] [&.popular]:bg-[#fff] [&.popular]:shadow-[0_0_0_2px_#404a86] {{ $subscription->popular === 1 ? 'popular' : '' }}">
				<div class="p-[1rem_1.5rem] pb-0">
					<div class="font-[600] mb-[.75rem] uppercase">{{ $subscription->name }}</div>
					<div class="border-b-[1px] pb-[1rem] opacity-60">{{ $subscription->subheading }}</div>
				</div>
				<div class="p-[1rem_1.5rem]">
					<div class="text-[2rem] font-[700]">{{ price($subscription->price) }}</div>
					<div class="">{{ $subscription->title }}</div>
				</div>
				<div class="p-[1rem_1.5rem] pt-0">
					<a href="{{ route('home.checkout', ['type' => 'subscription', 'id' => $subscription->id]) }}" class="p-[.5rem_1rem] h-[45px] flex items-center justify-center w-full rounded-[.25rem] text-[#fff] bg-[#404a86] uppercase">{{ __('Sign up') }}</a>
				</div>
				<div class="p-[1rem_1.5rem] [&>div:not(:last-child)]:mb-[.75rem]">
					@if(strip_tags($subscription->description))
						{!! $subscription->description !!}
					@elseif($subscription->specifications)
					@foreach($subscription->specifications ?? [] as $specification)
					<div class="flex items-start gap-[.5rem]">
						@if($specification->included)
						<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"><path fill="#ff9e62" d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10s10-4.48 10-10S17.52 2 12 2m0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8s8 3.58 8 8s-3.58 8-8 8"/><circle cx="12" cy="12" r="5" fill="#ff9e62"/></svg>
						@else
						<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"><path fill="currentColor" d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10s10-4.48 10-10S17.52 2 12 2m0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8s8 3.58 8 8s-3.58 8-8 8"/></svg>
						@endif
						<div class="flex-1">
							{{ $specification->text }}
						</div>
					</div>
					@endforeach
					@endif
				</div>
			</div>
			@endforeach
		</div>
	</div>
</div>
@endsection