@extends('front.axies.master')

@section('body')
<div class="" id="product">
	<div class="uppercase p-[1rem_1.5rem] mt-0 border-y-[1px] border-[#fafafa] bg-[#fcfcfc] text-[.8rem] overflow-hidden whitespace-nowrap flex flex-nowrap items-center gap-x-[1rem]">
		<a href="/" class="">{{ __('Home') }}</a>
		<span class="w-[1px] bg-[#cccccc] block relative bottom-[2px]">&nbsp;</span>
		<div class="">{{ limit($product->name, 60) }}</div>
	</div>

	<div class="flex max-[768px]:grid max-[768px]:grid-cols-1 p-[1.5rem] gap-[1.5rem]">
		<div class="flex gap-[.5rem] mx-auto max-[480px]:w-full">
			@if($product->screenshots)
			<div id="screenshots" class="w-[80px] h-[345px] overflow-auto scrollbar-width-[none] [&>div:not(:last-child)]:mb-[.5rem] min-[900px]:block max-[768px]:block hidden">
				@foreach($product->screenshots as $screenshot)
				<div class="w-[80px] h-[80px] rounded-[.25rem] bg-cover bg-center" data-img="{{ $screenshot }}" style="background-image: url('{{ $screenshot }}');"></div>
				@endforeach
			</div>
			@endif

			<div class="w-[345px] h-[345px] group relative flex max-[850px]:w-[250px] max-[850px]:h-[345px] max-[768px]:h-[345px] max-[768px]:w-[345px] max-[480px]:w-full">
				<div class="absolute top-0 left-0 w-full h-full bg-cover bg-center rounded-[.25rem]" style="background-image:url('{{ src("storage/covers/{$product->cover}") }}')"></div>

				@if($product->preview && $product->preview_type === 'video')
				<div class="absolute hidden group-hover:flex top-0 left-0 w-full h-full items-center justify-center group video" data-url="{{ $product->preview }}">
					<div class="cursor-pointer h-[calc(100%-1.5rem)] w-[calc(100%-1.5rem)] flex items-center justify-center group-hover:bg-[#0000000f] group-hover:backdrop-blur-[1px]">
						<svg xmlns="http://www.w3.org/2000/svg" width="80" height="80" viewBox="0 0 24 24"><path fill="#fff" d="m9.5 16.5l7-4.5l-7-4.5zM12 22q-2.075 0-3.9-.788t-3.175-2.137T2.788 15.9T2 12t.788-3.9t2.137-3.175T8.1 2.788T12 2t3.9.788t3.175 2.137T21.213 8.1T22 12t-.788 3.9t-2.137 3.175t-3.175 2.138T12 22m0-2q3.35 0 5.675-2.325T20 12t-2.325-5.675T12 4T6.325 6.325T4 12t2.325 5.675T12 20m0-8"/></svg>
					</div>
				</div>
				@endif

				@if($product->preview_type === 'audio')
				<div class="player rounded-b-[.5rem] bottom-0 left-0 overflow-hidden w-full absolute" data-type="audio" data-ready="false">
					<audio controls="" src="{{ isUrl($product->preview) ? $product->preview : src("storage/previews/{$product->preview}") }}" class="hidden"></audio>
					<div class="controls flex items-center justify-center h-[55px] backdrop-blur-[15px] gap-[.5rem] bg-[rgba(35,35,35,.09)] p-[.5rem_1rem] z-[2]">
						<div class="play flex items-center justify-center cursor-pointer w-[30px] h-[30px] min-w-[30px] min-h-[30px]"><img class="rounded-[.75rem] w-full invert" src="/assets/images/pause.png"></div>
						<div class="wave bg-[#fff] relative w-full h-[40px] " style="-webkit-mask-image: url(/assets/images/waves.svg);-webkit-mask-position: center;-webkit-mask-repeat: no-repeat;-webkit-mask-size: contain;"><span class="time bg-[#ff9e22] h-full left-0 absolute top-0 w-0"></span></div>
						<div class="stop flex items-center justify-center cursor-pointer w-[30px] h-[30px] min-w-[30px] min-h-[30px]"><img class="rounded-[.75rem] w-full invert" src="/assets/images/stop.png"></div>
					</div>
				</div>
				@endif

				@if(!$product->preview && $product->preview_url)
				<a href="{{ $product->preview_url }}" target="_blank" class="p-[.5rem_.5rem] pb-[.2rem] text-[.7rem] uppercase rounded-[.25rem] absolute bottom-[1rem] right-[1rem] bg-[#00000069] backdrop-blur-[5px] text-[#fff]">{{ __('Preview') }}</a>
				@endif
			</div>
		</div>

		<div class="flex-1 flex flex-col">
			<div class="flex justify-between gap-[1] mb-[1.5rem] leading-[1] items-end">
				<a href="{{ category_url($product->category['slug']) }}" class="table text-[.9rem] uppercase">{{ $product->category['name'] }}</a>
				<div class="flex items-center gap-x-[.25rem]">
					@foreach(rating($product->fake_rating ?? $product->rating) as $rating)
					<img src="/assets/images/{{ $rating }}" class="w-[25px] h-[25px]">
					@endforeach
				</div>
			</div>

			<div class="text-[1.5rem] mb-[1rem]">
				{{ $product->name }}
			</div>

			<div class="mb-auto opacity-75">
				{{ limit($product->short_description, 180) }}
			</div>

			@if(is_numeric($product->stock) || $product->has_keys)
			<div class="font-[600]">{{ $product->stock ?? $product->remaining_keys }} {{ __('Items left') }}</div>
			@endif
			
			@if(out_of_stock($product))
				<div class="p-[.75rem_1rem] bg-[#bfbfbf] text-[#fff] w-fit rounded-[.25rem]">{{ __('This product is out of stock') }}</div>
			@elseif($product->affiliate_link)
				<a href="{{ $product->affiliate_link }}" class="uppercase p-[.5rem_1rem] flex w-fit items-end gap-[.75rem] rounded-[.25rem] shadow-[0_0_0_1px_#4b376d_inset] text-[#4b376d] h-[40px] transition-all hover:bg-[#4b376d] hover:text-[#fff]" data-id="{{ $product->id }}">
					<div class="leading-[1] font-[600]">{{ __('Buy now') }}</div>
				</a>
			@elseif(!$product->for_subscriptions)
					@if($product->valid_subscription)
					<a href="{{ downloadUrl('file', $product->transaction_id, \Auth::id(), $product->id) }}" class="uppercase p-[.5rem_1rem] flex w-fit items-end gap-[.75rem] rounded-[.25rem] shadow-[0_0_0_1px_#4b376d_inset] text-[#4b376d] h-[40px] transition-all hover:bg-[#4b376d] hover:text-[#fff]">
						<div class="leading-[1] font-[600]">{{ __('Download') }}</div>
					</a>
					@else
							@if($product->extended_price && !$product->has_promo())
							<div class="flex w-fit text-[1rem] gap-[.5rem] p-[.5rem_.75rem] rounded-[.25rem] border-[1px] mt-[1rem]">
								<input type="checkbox" id="extended-license" data-price="{{ $product->price }}" data-extended-price="{{ $product->extended_price }}" class="w-[18px] h-[18px] appearance-none border-[1px] border-[#000] rounded-[.25rem] checked:bg-[#37495D] checked:border-0 relative before:content-['✓'] before:text-[#fff] before:text-transparent checked:before:text-[#fff] before:h-full before:w-full before:top-0 before:left-0 before:leading-1 before:flex before:items-center before:justify-center before:text-[.9rem] before:font-semibold" role="button" name="extended_license">
								<label for="extended-license">{{ __('Extended license') }}</label>
							</div>
							@endif

							@if(!$product->is_free || $product->extended_price)
							<div class="inline-flex items-end gap-[1rem] pt-[1rem] mt-[1rem] border-t-[1px] w-fit">
								<button class="buy-now buy-now-action uppercase {{ ($product->price <= 0 && !config('payments.enable_add_to_cart')) ? 'download' : '' }} [&.download:not(.extended)>div]:hidden [&.download:not(.extended)>a]:block [&>a:not(.extended)]:hidden p-[.5rem_1rem] flex items-center gap-[.75rem] rounded-[.25rem] shadow-[0_0_0_1px_#4b376d_inset] text-[#4b376d] h-[40px] transition-all hover:bg-[#4b376d] hover:text-[#fff]" data-id="{{ $product->id }}">
									<div class="leading-[1] font-[600]">{{ __('Buy now') }}</div>
									<a href="{{ route('home.download', ['type' => 'file', 'order_id' => rand(100,9999), 'user_id' => Auth::id() ?? rand(100,9999), 'item_id' => $product->id]) }}" class="leading-[1] font-[600]">{{ __('Download') }}</a>
								</button>

								@if(config('payments.enable_add_to_cart'))
								<button title="{{ __('Add to cart') }}" data-id="{{ $product->id }}" class="add-to-cart [&:hover>svg]:rotate-[360deg] [&[disabled]]:opacity-50 bg-[#ffe33e] capitalize p-[.75rem] flex items-center justify-center rounded-[.35rem] shadow-[0_0_0_1px_#ffe33e_inset] hover:shadow-[0_0_0_1.5px_#ffe33e_inset] text-[#000] h-[40px] transition-all">
									<svg class="transition-all duration-[1s]" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m21.052 11.5l.279-1.66c.182-1.086.273-1.628-.019-1.984c-.291-.356-.827-.356-1.898-.356H4.586c-1.071 0-1.607 0-1.898.356c-.292.356-.2.898-.019 1.984l1.204 7.18c.399 2.38.598 3.569 1.413 4.275C6.1 22 7.274 22 9.622 22H12m2-4h8m-4 4v-8m-.5-6.5a5.5 5.5 0 1 0-11 0" color="currentColor"/></svg>
								</button>
								@endif

								<div class="leading-[1] flex gap-[.5rem]" id="product-price">
									@if(!$product->extended_price && $product->has_promo())
									<div class="opacity-50">
										<sup class="text-[.9rem] relative font-[500]">
											{{ price($product->price) }}
											<div class="absolute h-full w-full flex items-center top-0 left-0"><span class="h-[2px] w-[50%] rotate-[45deg] mx-auto bg-[#000]"></span></div>
										</sup>
									</div>
									<div class="text-[1.3rem]">{{ price($product->promo_price) }}</div>
									@else
									<div class="text-[1.3rem] price">{{ price($product->price) }}</div>
									@endif
								</div>
							</div>

							@if($product->minimum_price && customPriceEnabled('products'))
							<div class="font-[500] flex items-center rounded-r-[.5rem] overflow-hidden rounded-[.35rem] bg-[#f2f2f2] max-w-[350px] mt-[1rem]">
								<div class="bg-[#212121] w-[45px] h-[45px] flex items-center text-[#fff] justify-center">
									<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 256 256"><path fill="currentColor" d="M204 168a52.06 52.06 0 0 1-52 52h-12v12a12 12 0 0 1-24 0v-12h-12a52.06 52.06 0 0 1-52-52a12 12 0 0 1 24 0a28 28 0 0 0 28 28h48a28 28 0 0 0 0-56h-40a52 52 0 0 1 0-104h4V24a12 12 0 0 1 24 0v12h4a52.06 52.06 0 0 1 52 52a12 12 0 0 1-24 0a28 28 0 0 0-28-28h-32a28 28 0 0 0 0 56h40a52.06 52.06 0 0 1 52 52"/></svg>
								</div>
								<input type="number" name="custom_price" class="[appearance:textfield] [&::-webkit-outer-spin-button]:appearance-none [&::-webkit-inner-spin-button]:appearance-none w-full h-[45px] px-[1rem] border-0 focus:outline-none bg-transparent placeholder:font-[400]" placeholder="{{ __('Enter a custom price') }}">
							</div>
							@endif
					@endif
				@endif
			@else
				@if($product->valid_subscription)
				<a href="{{ downloadUrl('file', $product->transaction_id, \Auth::id(), $product->id) }}" class="uppercase p-[.5rem_1rem] flex w-fit items-end gap-[.75rem] rounded-[.25rem] shadow-[0_0_0_1px_#4b376d_inset] text-[#4b376d] h-[40px] transition-all hover:bg-[#4b376d] hover:text-[#fff]">
					<div class="leading-[1] font-[600]">{{ __('Download') }}</div>
				</a>
				@else
				<div class="mt-[1rem] table p-[.65rem_1rem] rounded-[.25rem] uppercase text-[.9rem] font-[600] text-[#b78000] bg-[#fff9eb]">
					{{ __('Available via subscriptions only') }}
				</div>
				<div class="flex flex-wrap gap-[1rem] mt-[1rem] text-[1rem]">
					@foreach($subscriptions as $subscription)
					<a href="{{ route('home.checkout', ['type' => 'subscription', 'id' => $subscription->id]) }}" class="hover:font-[600] h-[45px] flex items-center text-center rounded-[.35rem] bg-[#fff] border-[1px]">
						<span class="h-[45px] text-[.9rem] flex items-center px-[1rem] mr-[1rem] border-r-[1px] font-[600]">{{ price($subscription->price) }}</span>
						<span class="pr-[1rem]">{{ $subscription->name }}</span>
					</a>
					@endforeach
				</div>
				@endif
			@endif
		</div>
	</div>

	<div class="">
		<div class="flex">
			<div class="overflow-hidden p-[1.5rem] flex-1">
				<div class="px-[1.5rem] bg-[radial-gradient(#ffffff,#ffffff,#f7f7f7)] mb-[1.5rem] rounded-[.25rem] whitespace-nowrap">
					<div class="flex items-center font-[600] text-[.9rem] overflow-auto h-[50px] scrollbar-width-[none]" id="product-menu">
						<button class="uppercase [&.active]:text-[#fd720e] active" data-tab="overview">{{ __('Overview') }}</button>
						
						@if(config('app.show_streaming_player') && itemHasVideo($product))
						<span class="w-[1px] bg-[grey] rounded-full mx-[1rem]">&nbsp;</span>
						<button class="uppercase [&.active]:text-[#fd720e]" data-tab="stream">{{ __('Stream') }}</button>
						@endif

						@if(config('app.enable_comments'))
						<span class="w-[1px] bg-[grey] rounded-full mx-[1rem]">&nbsp;</span>
						<button class="uppercase [&.active]:text-[#fd720e]" data-tab="comments">{{ __('Comments') }}</button>
						@endif

						@if(config('app.enable_reviews'))
						<span class="w-[1px] bg-[grey] rounded-full mx-[1rem]">&nbsp;</span>
						<button class="uppercase [&.active]:text-[#fd720e]" data-tab="reviews">{{ __('Reviews') }}</button>
						@endif

						@if(count($product->table_of_contents))
						<span class="w-[1px] bg-[grey] rounded-full mx-[1rem]">&nbsp;</span>
						<button class="uppercase [&.active]:text-[#fd720e]" data-tab="table-of-contents">{{ __('Table of contents') }}</button>
						@endif

						@if($product->hidden_content)
						<span class="w-[1px] bg-[grey] rounded-full mx-[1rem]">&nbsp;</span>
						<button class="uppercase [&.active]:text-[#fd720e]" data-tab="hidden-content">{{ __('Hidden content') }}</button>
						@endif
						
						@isset($faq)
						<span class="w-[1px] bg-[grey] rounded-full mx-[1rem]">&nbsp;</span>
						<button class="uppercase [&.active]:text-[#fd720e]" data-tab="faq">{{ __('FAQ') }}</button>
						@endisset
					</div>
				</div>

				{{-- OVERVIEW --}}
				<div class="[&:not(.active)]:hidden active" data-tab="overview">
					{!! $product->overview !!}
				</div>

				@if(config('app.show_streaming_player') && (auth_is_admin() || $product->purchased || $product->valid_subscription) && itemHasVideo($product))
				<div class="[&:not(.active)]:hidden" data-tab="stream">
					<div class="stream-player player bg-[#252525] pb-[55px] relative" data-type="video" data-ready="false" data-full="false">
						<div class="video absolute top-0 left-0 w-full h-[calc(100%-55px)] z-[1]"></div>
						<video 
							class="flex h-auto object-fit w-full"
							@if(preg_match("/^local|yandex$/i", $product->file_host))
							src="{{ route('stream_vid', ['id' => $product->id, 'temp_url' => base64_encode($product->temp_direct_url)]) }}#t=1"
							@else 
							src="{{ $product->temp_direct_url }}#t=1"
							@endif
							type="{{ itemHasVideo($product) }}"></video>
						<div class="controls flex gap-[1rem] h-[55px] flex items-center bg-[#232323] backdrop-blur-[15px] p-[.5rem_1rem] w-full absolute bottom-0 left-0 z-[2]">
							<div class="play select-none flex items-center justify-center w-[30px] h-[30px] invert cursor-pointer invert" title="{{ __('Play/Pause') }}"><img src="/assets/images/play-3.png"></div>
							<div class="wave select-none flex-1 relative overflow-hidden m-[auto_1.5rem] h-[30px] bg-[#ffffff1f] rounded-full" style="-webkit-mask-image: url(/assets/images/wave-3.png);-webkit-mask-position: center;-webkit-mask-repeat: repeat;-webkit-mask-size: contain;"
								><span class="time bg-[linear-gradient(45deg,#002941,rgba(24,255,238,.84))] rounded-[100px_0_0_100px] h-full left-0 absolute top-0 w-0 z-[9]"></span>
							</div>
							<div class="current-time select-none ml-auto flex flex-none bottom-[-2px] items-center text-[1rem] h-[30px] relative mr-[1rem] text-[#fff]" title="{{ __('Current time') }}">00:00:00</div>
							<div class="volume items-center flex-1 cursor-pointer flex h-[30px] justify-center max-w-[30px] relative group" title="{{ __('Volume') }}">
								<img class="w-[30px] select-none invert" src="/assets/images/volume.png">
								<div class="absolute bottom-[100%] w-[30px] left-0 h-[125px] hidden cursor-default group-hover:block">
									<span class="bg-[#ffffff80] rounded-full bottom-0 h-[120px] overflow-hidden absolute w-[10px] left-[10px] mb-[5px]">
										<span class="bg-[#fff] bottom-0 h-[100%] left absolute w-full"></span>
									</span>
								</div>
							</div>
							<div class="stop select-none items-center justify-center w-[30px] h-[30px] invert cursor-pointer invert" title="{{ __('Stop') }}"><img src="/assets/images/stop-2.png"></div>
							<div class="maximize select-none items-center justify-center w-[30px] h-[30px] invert cursor-pointer invert" title="{{ __('Fullscreen') }}"><img src="/assets/images/maximize.png"></div>
						</div>
					</div>
				</div>
				@endif

				{{-- COMMENTS --}}
				@if(config('app.enable_comments'))
				<div class="[&:not(.active)]:hidden text-[1.1rem]" data-tab="comments">
					@auth
					<form action="{{ url()->full() }}?tab=comments" method="POST" class="relative overflow-hidden bg-[#F6F8FA] w-full rounded-t-0 rounded-b-[.25rem] comment-form">
						<input type="hidden" name="type" value="comments">
						<input type="hidden" name="edit_comment_id" :value="commentToEdit.id">
						@if(config('app.enable_subcomments'))
						<input type="hidden" name="comment_id" :value="replyTo.commentId">
						@endif
						<div v-if="replyTo.userName !== null && commentToEdit.id === null" class="bg-[#fff] pb-[.5rem]">
							<div class="flex text-[.9rem] font-[600] w-fit gap-[.5rem] p-[.25rem_.5rem] bg-[#ffcc6e63] text-[#5e3f06] rounded-[.25rem]">
								<span class="cursor-pointer" @click="resetReplyTo">✕</span>
								<span class="">@{{ replyTo.userName }}</span>
							</div>
						</div>
						<div v-if="commentToEdit.id !== null && replyTo.userName === null" class="bg-[#fff] pb-[.5rem]">
							<div class="flex text-[.9rem] font-[600] w-fit gap-[.5rem] p-[.25rem_.5rem] bg-[#ffcc6e63] text-[#5e3f06] rounded-[.25rem]">
								<span class="cursor-pointer" @click="resetEditComment">✕</span>
								<span class="">{{ __('Edit comment') }}</span>
							</div>
						</div>
						<textarea name="comment" :value="commentToEdit.content" spellcheck="false" placeholder="{{ __('Enter your comment') }}" class="p-[1rem] bg-transparent outline-none w-full h-[120px] resize-none"></textarea>
						<div class="p-[1rem] flex gap-[1rem] ">
							<button type="submit" class="ml-auto bg-[#fff] hover:bg-[#df664a] hover:text-[#fff] hover:shadow-none p-[.5rem_1rem_.35rem] rounded-[.35rem] text-[#ff6845] shadow-[0_0_0_1px_#ff6845] font-[500] text-[1rem]">
								{{ __('Submit') }}
							</button>
						</div>
					</form>

					<div class="mt-[3rem]"></div>
					@endauth

					<div class="">
						@foreach($comments as $comment)
						<div class="pb-[1.5rem]" id="C{{ $comment->id }}">
							<div class="json hidden" data-content="{{ base64_encode(json_encode(['id' => $comment->id, 'content' => $comment->body])) }}"></div>
							<div class="rounded-[.25rem] bg-[#ff7b0008] border-[1px] border-[#f9f9f9]">
								<div class="flex items-center gap-x-[1rem] p-[1rem] border-b-[1px] border-[#f2ebe1] rounded-t-[.25rem]">
									<img src="{{ src("storage/avatars/{$comment->avatar}") }}" class="w-[50px] h-[50px] rounded-[.35rem]">
									<div class="text-[1rem]">
										<div class="font-[500] mb-[.25rem]">{{ $comment->name ?? $comment->alias_name ?? $comment->fullname }}</div>
										<div class="text-[.9rem]">{{ format_date($comment->created_at, 'H:i | Y-m-d') }}</div>
									</div>
									@if((\Auth::check() && \Auth::id() === $comment->user_id) || auth_is_admin())
									<div class="ml-auto cursor-pointer group relative">
										<svg xmlns="http://www.w3.org/2000/svg" opacity=".4" width="32" height="32" viewBox="0 0 20 20"><g fill="currentColor"><circle cx="5" cy="10" r="2"/><circle cx="10" cy="10" r="2"/><circle cx="15" cy="10" r="2"/></g></svg>
										<div class="group-hover:block hidden shadow-[0_10px_20px_-10px_#0000004f] z-[1] bg-[#fff] absolute top-[100%] font-[500] text-[.9rem] uppercase right-0 rounded-[.25rem]">
											@if(\Auth::id() === $comment->user_id)
											<div data-edit-comment="{{ $comment->id }}" class="edit-comment p-[.5rem_.75rem] block hover:font-[600] border-b-[1px]">{{ __('Edit') }}</div>
											@endif
											<a onclick="confirm('{{ __('Are you sure you want to delete this comment ?') }}') ? (location.href = '{{ route('home.product', ['id' => $product->id, 'slug' => $product->slug, 'type' => 'comments', 'delete_comment_id' => $comment->id]) }}') : null" class="p-[.5rem_.75rem] block hover:font-[600]">{{ __('Delete') }}</a>
										</div>
									</div>
									@endif
								</div>
								<div class="text-[1rem] opacity-75 p-[1.5rem] min-h-[150px]">
									{!! nl2br($comment->body) !!}
								</div>
								<div class="saved-reactions-container px-[1rem]">
									@if(count($comment->reactions ?? []))
									<div class="saved-reactions flex items-center saved-reactions [&>div:not(:first-child)]:ml-[-8px] flex-nowrap py-[.2rem] ml-[-2px] mt-[.75rem]" data-item_id="{{ $comment->id }}" data-item_type="comment">
										@php
											$z_indexes = array_combine(array_reverse([6,5,4,3,2,1]), [6,5,4,3,2,1]);
										@endphp
										@foreach($comment->reactions as $name => $count)
										<div class="reaction relative block border-[2px] border-[#fff] rounded-full bg-cover bg-center w-[25px] h-[25px]" data-reaction="{{ $name }}" title="{{ $count }}" style="background-image: url('{{ asset_("assets/images/reactions/{$name}.webp") }}'); z-index:{{ $z_indexes[$loop->iteration]  }}"></div>
										@endforeach
									</div>
									@endif
								</div>
								<div class="flex items-end gap-[1rem] text-[.9rem] p-[1rem] border-t-[1px] border-[#f2ebe1] relative">
									@if(config('app.enable_subcomments'))
									<div class="uppercase font-[600] bg-[#ff7e00] text-[#fff] rounded-[.25rem] text-[.8rem] p-[.5em_.75rem] pb-[.25rem] cursor-pointer" @click="setReplyTo('{{ $comment->name ?? $comment->alias_name ?? $comment->fullname }}', {{ $comment->id }})">{{ __('Reply') }}</div>
									@endif
									
									@if(config('app.enable_reactions_on_comments'))
									<div class="group relative">
										<svg xmlns="http://www.w3.org/2000/svg" class="" width="28" height="28" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-linejoin="round"><circle cx="12" cy="12" r="9" stroke-linecap="round"/><path stroke-width="1.5" d="M9.01 9.5v.01H9V9.5zm6 0v.01H15V9.5z"/><path stroke-linecap="round" d="M15.465 14A3.999 3.999 0 0 1 12 16a3.998 3.998 0 0 1-3.465-2"/></g></svg>
										<div class="group-hover:block hidden z-[1] absolute top-[100%] pt-[.5rem] font-[500] text-[.9rem] uppercase left-0 rounded-[.25rem] w-fit">
											<div class="flex gap-[.25rem] shadow-[0_10px_20px_-10px_#0000004f] bg-[#fff] h-[40px] items-center justify-between w-[200px] px-[.5rem] rounded-[.25rem] reactions border-[1px] border-[#f6f6f6]" data-item_id="{{ $comment->id }}" data-item_type="comment">
												<a title="{{ __('Like') }}" data-reaction="like" class="action cursor-pointer bg-cover bg-center w-[25px] h-[25px]" style="background-image: url('/assets/images/reactions/like.webp');"></a>
												<a title="{{ __('Love') }}" data-reaction="love" class="action cursor-pointer bg-cover bg-center w-[25px] h-[25px]" style="background-image: url('/assets/images/reactions/love.webp');"></a>
												<a title="{{ __('Haha') }}" data-reaction="funny" class="action cursor-pointer bg-cover bg-center w-[25px] h-[25px]" style="background-image: url('/assets/images/reactions/funny.webp');"></a>
												<a title="{{ __('Wow') }}" data-reaction="wow" class="action cursor-pointer bg-cover bg-center w-[25px] h-[25px]" style="background-image: url('/assets/images/reactions/wow.webp');"></a>
												<a title="{{ __('Sad') }}" data-reaction="sad" class="action cursor-pointer bg-cover bg-center w-[25px] h-[25px]" style="background-image: url('/assets/images/reactions/sad.webp');"></a>
												<a title="{{ __('Angry') }}" data-reaction="angry" class="action cursor-pointer bg-cover bg-center w-[25px] h-[25px]" style="background-image: url('/assets/images/reactions/angry.webp');"></a>
											</div>
										</div>
									</div>
									@endif

									<div class="ml-auto cursor-pointer font-[500] copy-text" data-text="{{ url()->current() }}?tab=comments#C{{ $comment->id }}">#{{ $comment->id }}</div>
								</div>
							</div>
							@if(config('app.enable_subcomments'))
							@if(count($comment->children))
							<div class="py-[2rem] mb-[-1.5rem] pl-[72px] [&>div:not(:last-child)]:mb-[2rem] relative">
								<div class="absolute w-[1px] h-full top-0 left-[36px] bg-[#f1f1f1]"></div>

								@foreach($comment->children as $child_comment)
								<div class="rounded-[.25rem] bg-[#ff7b0008] border-[1px] border-[#f9f9f9]" id="C{{ $child_comment->id }}">
									<div class="json hidden" data-content="{{ base64_encode(json_encode(['id' => $child_comment->id, 'content' => $child_comment->body])) }}"></div>
									<div class="flex items-center gap-x-[1rem] p-[1rem] border-b-[1px] border-[#f2ebe1] rounded-t-[.25rem]">
										<img src="{{ src("storage/avatars/{$child_comment->avatar}") }}" class="w-[50px] h-[50px] rounded-[.35rem]">
										<div class="text-[1rem]">
											<div class="font-[500] mb-[.25rem]">{{ $child_comment->name ?? $child_comment->alias_name ?? $child_comment->fullname }}</div>
											<div class="text-[.9rem]">{{ format_date($child_comment->created_at, 'H:i | Y-m-d') }}</div>
										</div>
										@if((\Auth::check() && \Auth::id() === $child_comment->user_id) || auth_is_admin())
										<div class="ml-auto cursor-pointer group relative">
											<svg xmlns="http://www.w3.org/2000/svg" opacity=".4" width="32" height="32" viewBox="0 0 20 20"><g fill="currentColor"><circle cx="5" cy="10" r="2"/><circle cx="10" cy="10" r="2"/><circle cx="15" cy="10" r="2"/></g></svg>
											<div class="group-hover:block hidden shadow-[0_10px_20px_-10px_#0000004f] z-[1] bg-[#fff] absolute top-[100%] font-[500] text-[.9rem] uppercase right-0 rounded-[.25rem]">
												@if(\Auth::id() === $child_comment->user_id)
												<div data-edit-comment="{{ $child_comment->id }}" class="edit-comment p-[.5rem_.75rem] block hover:font-[600] border-b-[1px]">{{ __('Edit') }}</div>
												@endif
												<a onclick="confirm('{{ __('Are you sure you want to delete this comment ?') }}') ? (location.href = '{{ route('home.product', ['id' => $product->id, 'slug' => $product->slug, 'type' => 'comments', 'delete_comment_id' => $child_comment->id]) }}') : null" class="p-[.5rem_.75rem] block hover:font-[600]">{{ __('Delete') }}</a>
											</div>
										</div>
										@endif
									</div>
									<div class="text-[1rem] opacity-75 p-[1.5rem] min-h-[150px]">
										{!! nl2br($child_comment->body) !!}
									</div>
									<div class="saved-reactions-container px-[1rem]">
										@if(count($child_comment->reactions ?? []))
										<div class="saved-reactions flex items-center saved-reactions [&>div:not(:first-child)]:ml-[-8px] flex-nowrap py-[.2rem] ml-[-2px] mt-[.75rem]" data-item_id="{{ $comment->id }}" data-item_type="comment">
											@php
												$z_indexes = array_combine(array_reverse([6,5,4,3,2,1]), [6,5,4,3,2,1]);
											@endphp
											@foreach($child_comment->reactions as $name => $count)
											<div class="reaction relative block border-[2px] border-[#fff] rounded-full bg-cover bg-center w-[25px] h-[25px]" data-reaction="{{ $name }}" title="{{ $count }}" style="background-image: url('{{ asset_("assets/images/reactions/{$name}.webp") }}'); z-index:{{ $z_indexes[$loop->iteration]  }}"></div>
											@endforeach
										</div>
										@endif
									</div>
									<div class="flex items-end gap-[1rem] text-[.9rem] p-[1rem] border-t-[1px] border-[#f2ebe1]">
										<div class="uppercase font-[600] bg-[#ff7e00] text-[#fff] rounded-[.25rem] text-[.8rem] p-[.5em_.75rem] pb-[.25rem] cursor-pointer" @click="setReplyTo('{{ $child_comment->name ?? $child_comment->alias_name ?? $child_comment->fullname }}', {{ $comment->id }})">{{ __('Reply') }}</div>

										@if(config('app.enable_reactions_on_comments'))
										<div class="group relative">
											<svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-linejoin="round"><circle cx="12" cy="12" r="10" stroke-linecap="round"/><path stroke-width="1.5" d="M9.01 9.5v.01H9V9.5zm6 0v.01H15V9.5z"/><path stroke-linecap="round" d="M15.465 14A3.999 3.999 0 0 1 12 16a3.998 3.998 0 0 1-3.465-2"/></g></svg>
											<div class="group-hover:block hidden z-[1] absolute top-[100%] pt-[.5rem] font-[500] text-[.9rem] uppercase left-0 rounded-[.25rem] w-fit">
												<div class="flex gap-[.25rem] shadow-[0_10px_20px_-10px_#0000004f] bg-[#fff] h-[40px] items-center justify-between w-[200px] px-[.5rem] rounded-[.25rem] reactions border-[1px] border-[#f6f6f6]" data-item_id="{{ $child_comment->id }}" data-item_type="comment">
													<a title="{{ __('Like') }}" data-reaction="like" class="action cursor-pointer bg-cover bg-center w-[25px] h-[25px]" style="background-image: url('/assets/images/reactions/like.webp');"></a>
													<a title="{{ __('Love') }}" data-reaction="love" class="action cursor-pointer bg-cover bg-center w-[25px] h-[25px]" style="background-image: url('/assets/images/reactions/love.webp');"></a>
													<a title="{{ __('Haha') }}" data-reaction="funny" class="action cursor-pointer bg-cover bg-center w-[25px] h-[25px]" style="background-image: url('/assets/images/reactions/funny.webp');"></a>
													<a title="{{ __('Wow') }}" data-reaction="wow" class="action cursor-pointer bg-cover bg-center w-[25px] h-[25px]" style="background-image: url('/assets/images/reactions/wow.webp');"></a>
													<a title="{{ __('Sad') }}" data-reaction="sad" class="action cursor-pointer bg-cover bg-center w-[25px] h-[25px]" style="background-image: url('/assets/images/reactions/sad.webp');"></a>
													<a title="{{ __('Angry') }}" data-reaction="angry" class="action cursor-pointer bg-cover bg-center w-[25px] h-[25px]" style="background-image: url('/assets/images/reactions/angry.webp');"></a>
												</div>
											</div>
										</div>
										@endif

										<div class="ml-auto cursor-pointer font-[500] copy-text" data-text="{{ url()->current() }}?tab=comments#{{ $child_comment->id }}">#{{ $child_comment->id }}</div>
									</div>
								</div>
								@endforeach
							</div>
							@endif
							@endif
						</div>
						@endforeach
					</div>
				</div>
				@endif

				{{-- REVIEWS --}}
				@if(config('app.enable_reviews'))
				<div class="[&:not(.active)]:hidden min-h-[400px]" data-tab="reviews">
					@if(\Auth::check() && $product->purchased)
					<form action="{{ url()->full() }}" method="POST" class="relative overflow-hidden bg-[#F6F8FA] w-full rounded-t-0 rounded-b-[.25rem]">
						<input type="hidden" name="type" value="reviews">
						<input type="hidden" name="rating">
						<input type="hidden" name="edit_review_id">
						<textarea name="review" spellcheck="false" placeholder="{{ __('Write a review') }}" class="p-[1rem] bg-transparent outline-none w-full h-[120px] resize-none"></textarea>
						
						<div class="p-[1rem] flex items-center gap-[1rem] border-t-[1px]">
							<div class="flex items-end gap-x-[.5rem]">
								<div class="font-[500] leading-[1]">{{ __('Rating') }}</div>
								<div class="flex items-center gap-x-[.25rem] select-none" id="user-rating">
									@foreach(rating(0) as $star)
									<div style="-webkit-mask-image: url('/assets/images/{{ $star }}'); -webkit-mask-size: cover; -webkit-mask-position: center; -webkit-mask-repeat:no-repeat" class="w-[25px] h-[25px] bg-[#cfcfcf]"></div>
									@endforeach
								</div>
							</div>

							<button class="ml-auto bg-[#fff] hover:bg-[#df664a] hover:text-[#fff] hover:shadow-none p-[.5rem_1rem_.35rem] rounded-[.35rem] text-[#ff6845] shadow-[0_0_0_1px_#ff6845] font-[500] text-[1rem]">
								{{ __('Submit') }}
							</button>
						</div>
					</form>
					<div class="mt-[3rem]"></div>
					@endif

					<div class="">
						@foreach($reviews ?? [] as $review)
						<div class="p-[1rem] bg-[#ff7b0008] border-[1px] border-[#f9f9f9] rounded-[.25rem]" id="rev-{{ $review->id }}">
							<div class="json hidden" data-content="{{ base64_encode(json_encode(['id' => $review->id, 'content' => $review->content, 'rating' => $review->rating])) }}"></div>
							<div class="">
								<div class="flex items-center gap-x-[1rem]">
									<img src="{{ src("storage/avatars/{$review->avatar}") }}" class="w-[50px] h-[50px] rounded-[.35rem]">
									<div class="text-[1rem]">
										<div class="font-[500] mb-[.25rem]">{{ $review->username }}</div>
										<div class="text-[.9rem]">{{ format_date($review->created_at, 'H:i | Y-m-d') }}</div>
									</div>
									@if((\Auth::check() && \Auth::id() === $review->user_id) || auth_is_admin())
									<div class="ml-auto cursor-pointer group relative">
										<svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-width="1.5"><circle cx="5" cy="12" r="2"/><circle cx="12" cy="12" r="2" opacity=".5"/><circle cx="19" cy="12" r="2"/></g></svg>
										<div class="group-hover:block hidden shadow-[0_10px_20px_-10px_#0000004f] z-[1] bg-[#fff] absolute top-[100%] font-[500] text-[.9rem] uppercase right-0 rounded-[.25rem]">
											@if(\Auth::id() === $review->user_id)
											<div data-edit-review="{{ $review->id }}" class="p-[.5rem_.75rem] block hover:font-[600] border-b-[1px]">{{ __('Edit') }}</div>
											@endif
											<a onclick="confirm('{{ __('Are you sure you want to delete this review ?') }}') ? (location.href = '{{ route('home.product', ['id' => $product->id, 'slug' => $product->slug, 'type' => 'reviews', 'delete_review_id' => $review->id]) }}') : null" class="p-[.5rem_.75rem] block hover:font-[600]">{{ __('Delete') }}</a>
										</div>
									</div>
									@endif
								</div>
								<div class="text-[1rem] opacity-75 py-[1rem] my-[1.5rem] border-y-[1px] border-[#ffe1c2]">
									{{ $review->content }}
								</div>
								<div class="flex items-end gap-[.5rem] text-[.9rem]">
									<div class="flex items-center gap-x-[.25rem]">
										@foreach(rating($review->rating) as $star)
										<img src="/assets/images/{{ $star }}" class="w-[20px] h-[20px]">
										@endforeach
									</div>
									<div class="leading-[1] font-[500]">{{ $review->rating }}/5</div>
									<div class="cursor-pointer ml-auto" data-review-id="{{ url()->current() }}?tab=reviews#rev-{{ $review->id }}" id="rev-{{ $review->id }}">
										<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"><path fill="currentColor" d="M21 7.25h-3l.77-3.07a.75.75 0 0 0-1.46-.36l-.86 3.43H10l.77-3.07a.75.75 0 0 0-1.46-.36l-.9 3.43H5a.75.75 0 0 0 0 1.5h3l-1.63 6.5H3a.75.75 0 0 0 0 1.5h3l-.77 3.07a.75.75 0 0 0 1.46.36l.86-3.43H14l-.77 3.07a.75.75 0 0 0 1.46.36l.86-3.43H19a.75.75 0 0 0 0-1.5h-3l1.63-6.5H21a.75.75 0 0 0 0-1.5m-5 1.5l-1.63 6.5H8l1.63-6.5Z"/></svg>
									</div>
								</div>
							</div>
						</div>
						@if(!$loop->last)
						<div class="my-[2rem]"></div>
						@endif
						@endforeach
					</div>
				</div>
				@endif

				{{-- TABLE OF CONTENTS --}}
				@if(count($product->table_of_contents))
				<div class="[&:not(.active)]:hidden" data-tab="table-of-contents">
					<div class="[&>div]:p-[.75rem_1rem]">
						@foreach($product->table_of_contents as $line)
						<div class="{{ $line['text_type'] }} [&.header]:font-[600] [&.subheader]:font-[500] [&.subheader]:opacity-75 [&.subsubheader]:pl-[2rem] [&.subsubheader]:ml-[1rem]">
							{{ $line['text_type'] === 'subsubheader' ? '⭘' : '' }} {{ $line['text'] }}
						</div>
						@endforeach
					</div>
				</div>
				@endif

				{{-- HIDDEN CONTENT --}}
				@if($product->hidden_content)
				<div class="[&:not(.active)]:hidden" data-tab="hidden-content">
					{!! $product->hidden_content !!}
				</div>
				@endif

				{{-- FAQ --}}
				@isset($faq)
				<div class="[&:not(.active)]:hidden" data-tab="faq">
					<div class="text-[1rem]">
						@foreach($faq as $line)
						<div class="[&:not(:last-child)]:mb-[1rem] [&:not(:last-child)]:pb-[1rem] [&:not(:last-child)]:border-b-[1px] block">
							<div class="font-[500] mb-[.75rem]"><span class="mr-[.5rem] font-[700]">Q.</span> {{ $line['question'] }}</div>
							<div class="font-[400] table">{{ $line['answer'] }}</div>
						</div>
						@endforeach
					</div>
				</div>
				@endisset
			</div>

			<div class="max-w-[300px] w-full min-w-[320px] p-[1.5rem] pl-0 max-[900px]:hidden">
				<div class="relative">
					<table class="table w-full bg-[radial-gradient(#ffffff,#ffffff,#f7f7f7)] rounded-[.25rem] overflow-hidden">
						<tbody class="[&>tr:not(:last-child)]:border-b-[1px]">
							<tr class="">
								<td class="px-[1rem]" colspan="2">
									<div class="font-[600] text-[.9rem] uppercase flex items-center justify-center h-[50px]">{{ __('Details') }}</div>
								</td>
							</tr>
							@if($product->authors)
							<tr class="">
								<td class="p-[.75rem_1rem] w-[50%] ">{{ __('Authors') }}</td>
								<td class="p-[.75rem_1rem] opacity-75">{{ $product->authors }}</td>
							</tr>
							@endif
							@if($product->release_date)
							<tr class="">
								<td class="p-[.75rem_1rem] w-[50%] ">{{ __('Release date') }}</td>
								<td class="p-[.75rem_1rem] opacity-75">{{ $product->release_date }}</td>
							</tr>
							@endif
							@if($product->last_update)
							<tr class="">
								<td class="p-[.75rem_1rem] w-[50%] ">{{ __('Last update') }}</td>
								<td class="p-[.75rem_1rem] opacity-75">{{ $product->last_update }}</td>
							</tr>
							@endif
							@if($product->version)
							<tr class="">
								<td class="p-[.75rem_1rem] w-[50%] ">{{ __('Version') }}</td>
								<td class="p-[.75rem_1rem] opacity-75">{{ $product->version }}</td>
							</tr>
							@endif
							@isset($files)
							<tr class="">
								<td class="p-[.75rem_1rem] w-[50%] ">{{ __('Included files') }}</td>
								<td class="p-[.75rem_1rem] opacity-75">{{ $product->included_files }}</td>
							</tr>
							@endisset
							@if($product->label)
							<tr class="">
								<td class="p-[.75rem_1rem] w-[50%] ">{{ __('Label') }}</td>
								<td class="p-[.75rem_1rem] opacity-75">{{ $product->label }}</td>
							</tr>
							@endif
							@if($product->language)
							<tr class="">
								<td class="p-[.75rem_1rem] w-[50%] ">{{ __('Language') }}</td>
								<td class="p-[.75rem_1rem] opacity-75">{{ $product->language }}</td>
							</tr>
							@endif
							@if($product->formats)
							<tr class="">
								<td class="p-[.75rem_1rem] w-[50%] ">{{ __('Formats') }}</td>
								<td class="p-[.75rem_1rem] opacity-75">PDF, EPUB</td>
							</tr>
							@endif
							@if($product->tools_used)
							<tr class="">
								<td class="p-[.75rem_1rem] w-[50%] ">{{ __('Tools used') }}</td>
								<td class="p-[.75rem_1rem] opacity-75">{{ $product->tools_used }}</td>
							</tr>
							@endif
							@if($product->high_resolution)
							<tr class="">
								<td class="p-[.75rem_1rem] w-[50%] ">{{ __('High resolution') }}</td>
								<td class="p-[.75rem_1rem] opacity-75">{{ __($product->high_resolution ? 'Yes' : 'No') }}</td>
							</tr>
							@endif
							@if($product->db)
							<tr class="">
								<td class="p-[.75rem_1rem] w-[50%] ">{{ __('Database') }}</td>
								<td class="p-[.75rem_1rem] opacity-75">{{ $product->db }}</td>
							</tr>
							@endif
							@if($product->compatible_browsers)
							<tr class="">
								<td class="p-[.75rem_1rem] w-[50%] ">{{ __('Compatible browsers') }}</td>
								<td class="p-[.75rem_1rem] opacity-75">{{ $product->compatible_browsers }}</td>
							</tr>
							@endif
							@if($product->compatible_os)
							<tr class="">
								<td class="p-[.75rem_1rem] w-[50%] ">{{ __('Compatible OS') }}</td>
								<td class="p-[.75rem_1rem] opacity-75">{{ $product->compatible_os }}</td>
							</tr>
							@endif
							@if($product->bpm)
							<tr class="">
								<td class="p-[.75rem_1rem] w-[50%] ">{{ __('BPM') }}</td>
								<td class="p-[.75rem_1rem] opacity-75">{{ $product->bpm }}</td>
							</tr>
							@endif
							@foreach($product->additional_fields ?? [] as $additional_field)
							<tr class="">
								<td class="p-[.75rem_1rem] w-[50%] ">{{ __($additional_field->_name_) }}</td>
								<td class="p-[.75rem_1rem] opacity-75">{{ $additional_field->_value_ }}</td>
							</tr>
							@endforeach
						</tbody>
					</table>
				</div>
			</div>
		</div>

		@if($similar_products->count())
		<div class="mt-[1rem] p-[1.5rem]" id="similar-items">
			<div class="uppercase font-[700] mb-[1rem] text-[1.5rem]">{{ __('Similar items') }}</div>
			<div class="grid grid-cols-4 gap-[1.5rem] items-start max-[1400px]:grid-cols-3 max-[1400px]:[&>div:last-child]:hidden max-[1200px]:grid-cols-4 max-[1200px]:[&>div:last-child]:block max-[1200px]:grid-cols-3 max-[1200px]:[&>div:last-child]:hidden max-[800px]:grid-cols-2 max-[800px]:[&>div:last-child]:block max-[480px]:grid-cols-1">
				@foreach($similar_products->slice(0, 4) as $similar_product)
				<div class="p-[1rem] border-[#f9f9f9] border-[1px] rounded-[.25rem] bg-[#f9f9f9]">
					<a href="{{ item_url($similar_product) }}" class="flex rounded-[.25rem] w-full relative">
						<img src="{{ src("/storage/covers/{$similar_product->cover}") }}" class="rounded-[.25rem]">
						<div class="table font-[600] absolute right-[.5rem] bottom-[.5rem] text-[.7rem] p-[.35rem_.35rem] bg-[#473d83a1] backdrop-blur-[5px] text-[#fff] pb-[.15rem] rounded-[.25rem]">{{ price($similar_product->price) }}</div>
					</a>
					<div class="mt-[1rem] flex flex-col">
						<a href="{{ category_url($similar_product->category['slug']) }}" class="uppercase text-[.8rem] font-[600] mb-[.75rem] first-letter:font-[600] first-letter:text-[#ff664b] block">{{ $similar_product->category['name'] }}</a>
						<a href="{{ item_url($similar_product) }}" class="block mb-[1rem]">{{ limit($similar_product->name, 40) }}</a>
						
						<div class="flex items-center justify-between">
							<a data-id="{{ $product->id }}" class="capitalize buy-now cursor-pointer w-fit flex mt-auto rounded-[.25rem] overflow-hidden bg-[#ffd9b1] text-[#fff] mr-[1rem]">
								<span class="p-[.5rem_.75rem] bg-[#2f4b98] flex items-center max-[560px]:hidden max-[480px]:flex">
									<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M15.75 10.5V6a3.75 3.75 0 1 0-7.5 0v4.5m11.356-1.993l1.263 12c.07.665-.45 1.243-1.119 1.243H4.25a1.125 1.125 0 0 1-1.12-1.243l1.264-12A1.125 1.125 0 0 1 5.513 7.5h12.974c.576 0 1.059.435 1.119 1.007M8.625 10.5a.375.375 0 1 1-.75 0a.375.375 0 0 1 .75 0m7.5 0a.375.375 0 1 1-.75 0a.375.375 0 0 1 .75 0"/></svg>
								</span>
								<span class="p-[.5rem_1rem] text-[#7c4102] font-[600]">{{ __('Buy now') }}</span>
							</a>
							<div class="ml-auto">
								<div class="h-[30px] w-[30px] bg-[#392d22]" style="-webkit-mask-image:url('/assets/images/uiw_star-on.svg'); -webkit-mask-position:bottom center; -webkit-mask-size:cover; -webkit-mask-repeat:no-repeat;">
									<span class="bg-[#ff9900] h-[30px] block" style="width:{{ (($similar_product->fake_rating ?? $similar_product->rating ?? '0') / 5)*100 }}%"></span>
								</div>
							</div>
						</div>
					</div>
				</div>
				@endforeach
			</div>
		</div>
		@endif
	</div>
</div>

<div id="screenshots-slider" class="hidden fixed top-0 left-0 w-full h-[100vh] z-[10] bg-[#fffffffa] flex items-center justify-center text-[1rem]">
	<div class="absolute left-0 top-0 h-[100vh] w-[50px] flex items-center justify-center cursor-pointer prev">
		<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 20 20"><path fill="currentColor" fill-rule="evenodd" d="m13.42 2.296l-8.047 6.94A.92.92 0 0 0 5 10q0 .472.41.797l8.01 6.907q.48.402 1.032.267q.45-.131.548-.607v-14.7a.76.76 0 0 0-.526-.628q-.574-.137-1.054.26"/></svg>
	</div>
	<img src="" class="h-full max-h-[90vh] w-auto select-none">
	<div class="absolute right-0 top-0 h-[100vh] w-[50px] flex items-center justify-center cursor-pointer next">
		<svg xmlns="http://www.w3.org/2000/svg" transform="scale(-1,1)" width="25" height="25" viewBox="0 0 20 20"><path fill="currentColor" fill-rule="evenodd" d="m13.42 2.296l-8.047 6.94A.92.92 0 0 0 5 10q0 .472.41.797l8.01 6.907q.48.402 1.032.267q.45-.131.548-.607v-14.7a.76.76 0 0 0-.526-.628q-.574-.137-1.054.26"/></svg>
	</div>
</div>
@endsection