@extends('front.axies.master')


@section('body')
<div class="" id="products">
	<div class="uppercase p-[1rem_1.5rem] mt-0 border-y-[1px] border-[#fafafa] bg-[#fcfcfc] text-[.8rem] overflow-hidden whitespace-nowrap flex flex-nowrap items-center gap-x-[1rem]">
		<a href="" class="">{{ __('Home') }}</a>
		<span class="w-[1px] bg-[#cccccc] block relative bottom-[2px]">&nbsp;</span>
		@isset($category['name'])
		<div class="">{{ __('Category') }}</div>
		<span class="w-[1px] bg-[#cccccc] block relative bottom-[2px]">&nbsp;</span>
		<div class="">{{ $category['name'] }}</div>
		@elseif(strlen(trim(request()->query('q', ''))))
		<span class="w-[1px] bg-[#cccccc] block relative bottom-[2px]">&nbsp;</span>
		<div class="">{{ substr(trim(request()->query('q', '')), 0, 100) }}</div>
		@else
		<span class="w-[1px] bg-[#cccccc] block relative bottom-[2px]">&nbsp;</span>
		<div class="">{{ __('Products') }}</div>
		@endisset
	</div>

	<div class="flex min-h-[600px] relative">
		<div class="flex-1 px-[1.5rem] pb-[1.5rem] mt-[1.5rem]">
			<div class="flex mb-[1.5rem] items-end justify-between gap-[1rem] pb-[1.5rem] border-b-[1px] border-[#f8f8f8]">
				<div class="flex gap-[.5rem] items-baseline leading-[1]">
					<div class="text-[1.3rem] first-letter:text-[#e54a3b] first-letter:font-[700]">{{ __('Results') }}</div>
					<div class="text-[1.1rem] font-[600]">{{ $products->total() }}</div>
				</div>

				<div class="ml-auto flex items-center gap-[1rem]">
					<div class="group relative">
						<div class="p-[.5rem_1rem] pr-[.5rem] bg-[#fcfcfc] rounded-[.25rem] flex items-center gap-[.5rem] h-[46px] max-[560px]:hidden">
							<div class="">{{ __('Sort by') }} : </div>
							<div class="p-[.25rem_.5rem] text-[.9rem] bg-[#ff822b] text-[#fff] rounded-[.25rem]">{{ $sort ?? __('Best match') }}</div>
						</div>
						<div class="group-hover:block uppercase absolute text-[.8rem] top-[46px] w-[210px] right-0 hidden z-[3] bg-[#fff] p-[1rem] rounded-b-[.5rem] shadow-[0_50px_30px_-40px_#00000069]">
							<a href="{{ filter_url(filter_is_selected('relevance_asc') ? 'relevance_desc' : 'relevance_asc') }}" class="mb-[1rem] flex items-center gap-[.5rem] hover:font-[600]">
								<svg xmlns="http://www.w3.org/2000/svg" class="relative bottom-[2px]" width="19" height="19" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M20.01 2v3.132a.314.314 0 0 1-.556.201A9.98 9.98 0 0 0 12 2C6.477 2 2 6.477 2 12s4.477 10 10 10s10-4.477 10-10" color="currentColor"/></svg>
								<span class="">{{ __('Best match') }}</span>
							</a>
							<a href="{{ filter_url(filter_is_selected('rating_asc') ? 'rating_desc' : 'rating_asc') }}" class="mb-[1rem] flex items-center gap-[.5rem] hover:font-[600]">
								<svg xmlns="http://www.w3.org/2000/svg" class="relative bottom-[2px]" width="20" height="20" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-width="1.5" d="M9.153 5.408C10.42 3.136 11.053 2 12 2s1.58 1.136 2.847 3.408l.328.588c.36.646.54.969.82 1.182s.63.292 1.33.45l.636.144c2.46.557 3.689.835 3.982 1.776c.292.94-.546 1.921-2.223 3.882l-.434.507c-.476.557-.715.836-.822 1.18c-.107.345-.071.717.001 1.46l.066.677c.253 2.617.38 3.925-.386 4.506s-1.918.051-4.22-1.009l-.597-.274c-.654-.302-.981-.452-1.328-.452s-.674.15-1.328.452l-.596.274c-2.303 1.06-3.455 1.59-4.22 1.01c-.767-.582-.64-1.89-.387-4.507l.066-.676c.072-.744.108-1.116 0-1.46c-.106-.345-.345-.624-.821-1.18l-.434-.508c-1.677-1.96-2.515-2.941-2.223-3.882S3.58 8.328 6.04 7.772l.636-.144c.699-.158 1.048-.237 1.329-.45s.46-.536.82-1.182z"/></svg>
								<span class="">{{ __('Rating') }}</span>
							</a>
							<a href="{{ filter_url(filter_is_selected('price_asc') ? 'price_desc' : 'price_asc') }}" class="mb-[1rem] flex items-center gap-[.5rem] hover:font-[600]">
								<svg xmlns="http://www.w3.org/2000/svg" class="relative bottom-[2px]" width="20" height="20" viewBox="0 0 14 14"><g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"><path d="M7 4.5V3M5.5 8.5c0 .75.67 1 1.5 1s1.5 0 1.5-1c0-1.5-3-1.5-3-3c0-1 .67-1 1.5-1s1.5.38 1.5 1M7 9.5V11"/><circle cx="7" cy="7" r="6.5"/></g></svg>
								<span class="">{{ __('Price') }}</span>
							</a>
							<a href="{{ filter_url(filter_is_selected('newest_asc') ? 'newest_desc' : 'newest_asc') }}" class="mb-[1rem] flex items-center gap-[.5rem] hover:font-[600]">
								<svg xmlns="http://www.w3.org/2000/svg" class="relative bottom-[2px]" width="20" height="20" viewBox="0 0 24 24"><path fill="currentColor" d="M17 14a1 1 0 1 0 0-2a1 1 0 0 0 0 2m0 4a1 1 0 1 0 0-2a1 1 0 0 0 0 2m-4-5a1 1 0 1 1-2 0a1 1 0 0 1 2 0m0 4a1 1 0 1 1-2 0a1 1 0 0 1 2 0m-6-3a1 1 0 1 0 0-2a1 1 0 0 0 0 2m0 4a1 1 0 1 0 0-2a1 1 0 0 0 0 2"/><path fill="currentColor" fill-rule="evenodd" d="M7 1.75a.75.75 0 0 1 .75.75v.763c.662-.013 1.391-.013 2.193-.013h4.113c.803 0 1.532 0 2.194.013V2.5a.75.75 0 0 1 1.5 0v.827q.39.03.739.076c1.172.158 2.121.49 2.87 1.238c.748.749 1.08 1.698 1.238 2.87c.153 1.14.153 2.595.153 4.433v2.112c0 1.838 0 3.294-.153 4.433c-.158 1.172-.49 2.121-1.238 2.87c-.749.748-1.698 1.08-2.87 1.238c-1.14.153-2.595.153-4.433.153H9.945c-1.838 0-3.294 0-4.433-.153c-1.172-.158-2.121-.49-2.87-1.238c-.748-.749-1.08-1.698-1.238-2.87c-.153-1.14-.153-2.595-.153-4.433v-2.112c0-1.838 0-3.294.153-4.433c.158-1.172.49-2.121 1.238-2.87c.749-.748 1.698-1.08 2.87-1.238q.35-.046.739-.076V2.5A.75.75 0 0 1 7 1.75M5.71 4.89c-1.005.135-1.585.389-2.008.812S3.025 6.705 2.89 7.71q-.034.255-.058.539h18.336q-.024-.284-.058-.54c-.135-1.005-.389-1.585-.812-2.008s-1.003-.677-2.009-.812c-1.027-.138-2.382-.14-4.289-.14h-4c-1.907 0-3.261.002-4.29.14M2.75 12c0-.854 0-1.597.013-2.25h18.474c.013.653.013 1.396.013 2.25v2c0 1.907-.002 3.262-.14 4.29c-.135 1.005-.389 1.585-.812 2.008s-1.003.677-2.009.812c-1.027.138-2.382.14-4.289.14h-4c-1.907 0-3.261-.002-4.29-.14c-1.005-.135-1.585-.389-2.008-.812s-.677-1.003-.812-2.009c-.138-1.027-.14-2.382-.14-4.289z" clip-rule="evenodd"/></svg>
								<span class="">{{ __('Newest') }}</span>
							</a>
							<a href="{{ filter_url(filter_is_selected('trending_asc') ? 'trending_desc' : 'trending_asc') }}" class="mb-[1rem] flex items-center gap-[.5rem] hover:font-[600]">
								<svg xmlns="http://www.w3.org/2000/svg" class="relative bottom-[2px]" width="21" height="21" viewBox="0 0 14 14"><g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"><path d="M6.15.53a.39.39 0 0 0-.4 0a.26.26 0 0 0-.06.34C6.92 3 7.18 5.9 5.5 7.5a5.52 5.52 0 0 1-1.5-2A3.89 3.89 0 0 0 2 9a4.7 4.7 0 0 0 5 4.5c3.22 0 4.89-2 5-4.5c.13-3-2-6.69-5.85-8.47Z"/><path d="M9.5 9a2 2 0 0 1-2 2"/></g></svg>
								<span class="">{{ __('Trending') }}</span>
							</a>
							<a href="{{ filter_url(filter_is_selected('featured_asc') ? 'featured_desc' : 'featured_asc') }}" class="flex items-center gap-[.5rem] hover:font-[600]">
								<svg xmlns="http://www.w3.org/2000/svg" class="relative bottom-[2px]" width="23" height="23" viewBox="0 0 256 256"><path fill="currentColor" d="M160 56H64a16 16 0 0 0-16 16v152a8 8 0 0 0 12.65 6.51L112 193.83l51.36 36.68A8 8 0 0 0 176 224V72a16 16 0 0 0-16-16m0 152.46l-43.36-31a8 8 0 0 0-9.3 0L64 208.45V72h96ZM208 40v152a8 8 0 0 1-16 0V40H88a8 8 0 0 1 0-16h104a16 16 0 0 1 16 16"/></svg>
								<span class="">{{ __('Featured') }}</span>
							</a>
						</div>
					</div>

					<button class="p-[.5rem] bg-[#fcfcfc] rounded-[.25rem] h-[46px] w-[46px] flex items-center justify-center" id="filters-menu-toggler">
						<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 36 36"><path fill="currentColor" d="M33 4H3a1 1 0 0 0-1 1v1.67a1.8 1.8 0 0 0 .53 1.27L14 19.58v10.2l2 .76V19a1 1 0 0 0-.29-.71L4 6.59V6h28v.61L20.33 18.29A1 1 0 0 0 20 19v13.21l2 .79V19.5L33.47 8A1.8 1.8 0 0 0 34 6.7V5a1 1 0 0 0-1-1" class="clr-i-outline clr-i-outline-path-1"/><path fill="none" d="M0 0h36v36H0z"/></svg>
					</button>
				</div>
			</div>

			<div class="gap-x-[1.5rem] gap-y-[2.5rem] grid grid-cols-4 max-[1400px]:grid-cols-3 max-[1200px]:grid-cols-4 max-[900px]:grid-cols-3 max-[650px]:grid-cols-2 max-[400px]:grid-cols-1">
				@foreach($products as $product)
				<div class="overflow-hidden relative rounded-[.25rem] text-[1rem]">
					<span class="absolute z-[1] top-[.75rem] right-[.75rem] group cursor-default opacity-50 add-to-collection" data-id="{{ $product->id }}">
						<svg xmlns="http://www.w3.org/2000/svg" :class="{hidden: itemInCollection('{{ $product->id }}')}" width="20" height="20" viewBox="0 0 20 20"><path fill="currentColor" d="M13.682 1.682c2.007-.48 3.667.026 4.849 1.094c1.032.934 1.628 2.559 1.432 4.39c-.147 1.374-.893 2.769-2.242 4.22l-7.274 6.923a.7.7 0 0 1-.963-.002L2.266 11.36C1.198 10.227.516 9.15.233 8.118C-.18 6.62-.04 5.107.61 3.875c.77-1.461 2.306-2.329 4.532-2.329c1.522 0 3.12.753 4.805 2.221c1.148-1.066 2.394-1.765 3.735-2.085M9.97 16.883l6.76-6.433c1.138-1.226 1.75-2.37 1.863-3.425c.151-1.415-.29-2.619-.997-3.258c-.859-.777-2.056-1.142-3.588-.776c-1.257.3-2.434 1.02-3.538 2.174a.7.7 0 0 1-.981.025C7.852 3.644 6.397 2.895 5.142 2.895c-1.722 0-2.78.597-3.307 1.598c-.489.926-.597 2.094-.272 3.275c.218.795.786 1.692 1.692 2.655z"/></svg>
						<svg xmlns="http://www.w3.org/2000/svg" :class="{hidden: !itemInCollection('{{ $product->id }}')}" width="20" height="20" viewBox="0 0 20 20"><path fill="#ff3b3b" d="M13.67 1.658c2.103-.494 4.165.222 5.135 1.434c.896 1.119 1.303 2.282 1.17 3.998c-.095 1.237-.5 2.154-1.298 3.163c-.147.186-.308.377-.511.609l-.548.618c-.8.903-3.155 3.163-7.103 6.82a.764.764 0 0 1-1.036-.004C6.09 15.12 3.896 13.028 2.89 12.014C1.033 10.14.326 9.05.07 7.293c-.27-1.84.245-3.349 1.398-4.521c1.082-1.1 3.017-1.508 4.928-1.12c1.119.228 2.31.96 3.6 2.181c1.101-1.129 2.327-1.86 3.675-2.175"/></svg>
					</span>

					<div class="relative mb-[1rem]">
						<a href="{{ item_url($product) }}" class="flex bg-[#fff] relative rounded-[.25rem]">
							<img src="{{ src("storage/covers/{$product->cover}") }}" class="rounded-[.25rem]">
						</a>

						<div class="absolute bottom-[.5rem] left-[.5rem] p-[.25rem] bg-[#00000030] rounded-[.25rem] backdrop-blur-[5px]">
							<div class="h-[18px] w-[18px] bg-[#e5e5e5]" style="-webkit-mask-image:url('/assets/images/star.svg'); -webkit-mask-position:bottom center; -webkit-mask-size:cover" title="{{ $product->rating }}">
								<span class="bg-[#ff9100] h-[20px] block" style="width:{{ (($product->fake_rating ?? $product->rating) / 5) * 100 }}/5"></span>
							</div>
						</div>
					</div>
					<div class="">
						<a href="{{ item_url($product) }}" class="block mb-[1rem] h-[50px] overflow-hidden font-[600] opacity-75 first-letter:text-[#ff664b]">{{ limit($product->name, 60) }}</a>
						@if($product->price >= 0)
						<div class="flex items-end gap-[1rem]">
							<div class="font-[600]">{{ price($product->price) }}</div>
							<button data-id="{{ $product->id }}" class="buy-now ml-auto p-[.5rem] pb-[.35rem] rounded-[.25rem] bg-[#497aff] text-[#fff] font-[600] text-[.8rem] uppercase">{{ __('Buy now') }}</button>
						</div>
						@endif
					</div>
				</div>
				@endforeach
			</div>

			@if($products->hasPages())
			<div class="mt-[3rem]">
				@if(config('app.force_simple_pagination'))
				{{ $products->links('vendor.pagination.simple-tailwind') }}
				@else
				{{ $products->links('vendor.pagination.tailwind') }}
				@endif
			</div>
			@endif
		</div>

		<div class="w-[280px] px-[1.5rem] pb-[1.5rem] mt-[1.5rem] border-l-[1px] border-[#f8f8f8] max-[1199px]:hidden max-[1199px]:absolute max-[1199px]:w-[320px] max-[1199px]:min-h-[calc(100%-71px)] max-[1199px]:top-[71px] max-[1199px]:bg-[#fff] max-[1199px]:right-0 max-[1199px]:right-0" id="product-filters">
			<div class="h-[45px] flex items-end leading-[1] mb-[1.5rem] text-[1.3rem]">{{ __('Filters') }}</div>
			<div class="pt-[1.5rem]">
				@if(intval(config('app.filter_by_included_files')))
				<div class="mb-[2.5rem]">
					<div class="font-[600] mb-[1rem] flex items-start justify-between gap-[1rem]">
						<div class="mr-auto">{{ __('Included files') }}</div>
					</div>

					<div class="[&>div]:mb-[.75rem] max-h-[200px] overflow-hidden scrollbar-width-[none]" id="filter-included-files">
						@foreach($included_files as $included_file)
						<div class="flex items-center gap-x-[1rem] text-[1rem]">
							<input id="{{ md5($included_file) }}" data-file-type="{{ $included_file }}" {{ isset($selected_included_files[$included_file]) ? 'checked' : '' }} name="included-files[]" value="{{ $included_file }}" type="checkbox" class="included-file w-[20px] h-[20px] appearance-none border-[1px] border-[#000] rounded-[.25rem] checked:bg-[#37495D] checked:border-0 relative before:content-['✓'] before:text-[#fff] before:text-transparent checked:before:text-[#fff] before:h-full before:w-full before:top-0 before:left-0 before:leading-1 before:flex before:items-center before:justify-center before:text-[.8rem] before:font-semibold" role="button">
							<label for="{{ md5($included_file) }}" class="opacity-[.8]">{{ $included_file }}</label>
						</div>
						@endforeach
					</div>
					<div class="mt-[1rem] cursor-pointer flex items-center justify-between text-[#685905] p-[.5rem_1rem] bg-[#ffdb0814] rounded-[.5rem]" id="filter-included-files-show-more">
						<span class="">{{ __("More file types") }}</span>
						<img src="/assets/images/dropdown.png" class="w-[20px]">
					</div>
				</div>
				@endif
				
				<div class="mb-[2.5rem]">
					<div class="font-[600] mb-[1rem] flex items-start justify-between gap-[1rem]">
						<div class="mr-auto">{{ __('Categories') }}</div>
					</div>

					<div class="[&>div]:mb-[.75rem] max-h-[300px] overflow-hidden scrollbar-width-[none]" id="filter-categories">
						@foreach(config('categories.category_parents') as $_category)
						<div class="flex items-center gap-x-[1rem] text-[1rem]">
							<input id="{{ md5($_category['id']) }}" data-category="{{ $_category['slug'] }}" data-route="{{ route('home.products.category', ['category_slug' => $_category['slug'], 'q' => request()->query('q')]) }}" name="category[]" {{ request()->category_slug === $_category['slug'] ? 'checked' : null }} value="{{ $_category['id'] }}" type="radio" class="category w-[20px] h-[20px] appearance-none border-[1px] border-[#000] rounded-[.25rem] checked:bg-[#37495D] checked:border-0 relative before:content-['✓'] before:text-[#fff] before:text-transparent checked:before:text-[#fff] before:h-full before:w-full before:top-0 before:left-0 before:leading-1 before:flex before:items-center before:justify-center before:text-[.8rem] before:font-semibold" role="button">
							<label for="{{ md5($_category['id']) }}" class="opacity-[.8]">{{ $_category['name'] }}</label>
						</div>
						@endforeach
					</div>
					<div class="mt-[1rem] cursor-pointer flex items-center justify-between text-[#685905] p-[.5rem_1rem] bg-[#ffdb0814] rounded-[.5rem]" id="filter-categories-show-more">
						<span class="">{{ __("More categories") }}</span>
						<img src="/assets/images/dropdown.png" class="w-[20px]">
					</div>
				</div>

				@if(isset($category) && count(config("categories.category_children.{$category['id']}", [])) && empty(request()->query('q')))
				<div class="h-[1px] w-[30%] bg-[#d7d7d7] mb-[1.5rem] mt-[2rem]"></div>

				<div class="mb-[2.5rem]">					
					<div class="font-[600] mb-[1rem] flex items-start justify-between gap-[1rem]">
						<div class="mr-auto">{{ __('Subcategories') }}</div>
						<div class="" title="{{ __('Reset') }}">
							<svg xmlns="http://www.w3.org/2000/svg" class="reset-filter cursor-pointer" data-filter="subcategory" width="20" height="20" viewBox="0 0 24 24"><path fill="currentColor" d="M22 12c0 5.523-4.477 10-10 10S2 17.523 2 12S6.477 2 12 2v2a8 8 0 1 0 5.135 1.865L15 8V2h6l-2.447 2.447A9.98 9.98 0 0 1 22 12"/></svg>
						</div>
					</div>
					<div class="[&>div]:mb-[.75rem] max-h-[405px] overflow-hidden scrollbar-width-[none]" id="filter-subcategories">
						@foreach(config("categories.category_children.{$category['id']}", []) as $subcategory)
						<div class="flex items-center gap-x-[1rem] text-[1rem]">
							<input id="{{ md5($subcategory['id']) }}" name="subcategory[]" {{ request()->subcategory_slug === $subcategory['slug'] ? 'checked' : null }} data-subcategory="{{ $subcategory['slug'] }}" value="{{ $subcategory['id'] }}" type="radio" class="subcategory w-[20px] h-[20px] appearance-none border-[1px] border-[#000] rounded-[.25rem] checked:bg-[#37495D] checked:border-0 relative before:content-['✓'] before:text-[#fff] before:text-transparent checked:before:text-[#fff] before:h-full before:w-full before:top-0 before:left-0 before:leading-1 before:flex before:items-center before:justify-center before:text-[.8rem] before:font-semibold" role="button">
							<label for="{{ md5($subcategory['id']) }}" class="opacity-[.8]">{{ $subcategory['name'] }}</label>
						</div>
						@endforeach
					</div>
					<div class="mt-[1rem] cursor-pointer flex items-center justify-between text-[#ff6608] p-[.5rem_1rem] bg-[#ff660814] rounded-[.5rem]" id="filter-subcategories-show-more">
						<span class="">{{ __("Show more") }}</span>
						<img src="/assets/images/dropdown.png" class="w-[20px]">
					</div>
				</div>
				@endif

				<div class="mb-[2.5rem]">
					<div class="mb-[.75rem]">{{ __("Rating") }}</div>
					<div class="w-full px-[1rem] text-[.9rem] relative">
						<div class="absolute left-0 top-0 w-full h-full flex items-center justify-center z-0">
							<div class="w-full h-[10px] bg-[whitesmoke] rounded-full"></div>
						</div>
						<div class="flex items-center justify-between relative gap-[.75rem]" id="ratings">
							<input type="hidden" name="rating">
							<div class="h-[35px] w-[35px] flex items-center justify-center bg-[whitesmoke] rounded-[.25rem] hover:shadow-[0_0_0_1px_#c9a825] cursor-pointer hover:bg-[#ffd751] hover:font-[600] [&.active]:bg-[#ffd751] [&.active]:shadow-[0_0_0_1px_#c9a825] [&.active]:font-[600] {{ request()->query('rating') === '1' ? 'active' : null }}">1</div>
							<div class="h-[35px] w-[35px] flex items-center justify-center bg-[whitesmoke] rounded-[.25rem] hover:shadow-[0_0_0_1px_#c9a825] cursor-pointer hover:bg-[#ffd751] hover:font-[600] [&.active]:bg-[#ffd751] [&.active]:shadow-[0_0_0_1px_#c9a825] [&.active]:font-[600] {{ request()->query('rating') === '2' ? 'active' : null }}">2</div>
							<div class="h-[35px] w-[35px] flex items-center justify-center bg-[whitesmoke] rounded-[.25rem] hover:shadow-[0_0_0_1px_#c9a825] cursor-pointer hover:bg-[#ffd751] hover:font-[600] [&.active]:bg-[#ffd751] [&.active]:shadow-[0_0_0_1px_#c9a825] [&.active]:font-[600] {{ request()->query('rating') === '3' ? 'active' : null }}">3</div>
							<div class="h-[35px] w-[35px] flex items-center justify-center bg-[whitesmoke] rounded-[.25rem] hover:shadow-[0_0_0_1px_#c9a825] cursor-pointer hover:bg-[#ffd751] hover:font-[600] [&.active]:bg-[#ffd751] [&.active]:shadow-[0_0_0_1px_#c9a825] [&.active]:font-[600] {{ request()->query('rating') === '4' ? 'active' : null }}">4</div>
							<div class="h-[35px] w-[35px] flex items-center justify-center bg-[whitesmoke] rounded-[.25rem] hover:shadow-[0_0_0_1px_#c9a825] cursor-pointer hover:bg-[#ffd751] hover:font-[600] [&.active]:bg-[#ffd751] [&.active]:shadow-[0_0_0_1px_#c9a825] [&.active]:font-[600] {{ request()->query('rating') === '5' ? 'active' : null }}">5</div>
						</div>
					</div>
				</div>

				<div class="">
					<div class="mb-[.75rem]">{{ __("Price range") }}</div>
					<div class="w-full flex items-center gap-[.75rem]">
						<input type="text" name="price[min]" value="{{ $price_range['min'] ?? null }}" placeholder="{{ __('Min') }}" class="h-[40px] outline-0 p-[.5rem] border-[1px] rounded-[.25rem] flex-1 min-w-0">
						<input type="text" name="price[max]" value="{{ $price_range['max'] ?? null }}" placeholder="{{ __('Max') }}" class="h-[40px] outline-0 p-[.5rem] border-[1px] rounded-[.25rem] flex-1 min-w-0">
					</div>
				</div>

				<div class="h-[1px] w-full bg-[#d7d7d7] my-[1.5rem]"></div>

				<button id="apply-products-filter" class="h-[40px] bg-[#e34d32] rounded-[.35rem] text-[#fff] flex items-center justify-center px-[1rem] w-full font-[600]">{{ __('Apply filters') }}</button>
			</div>
		</div>
	</div>
</div>
@endsection
