@extends('front.axies.master')

@section('body')
<div class="p-[1.5rem] bg-[linear-gradient(180deg,#fcfcfc,#fff)]">
	<div class="text-center mb-[76px] min-h-[150px] flex flex-col justify-end items-start px-[1.5rem] bg-[#3b3747] text-[#fff] mb-[3rem] rounded-[.25rem] relative">
		<div class="absolute top-0 left-0 w-full h-full bg-center bg-cover opacity-[.05]" style="background-image: url(/assets/images/user-cover.webp);"></div>
		<div class="absolute bottom-[-50px] left-[50px] overflow-hidden max-[560px]:left-[1.5rem] w-[150px] h-[150px] shadow-[0_0_0_.25rem_#fff] rounded-[.1rem] bg-[#fff]">
			<img src="{{ src("storage/avatars/{$user->avatar}") }}" class="w-full rounded-[.25rem]" id="user-avatar">
			@if($user->email_verified_at)
			<span class="absolute bg-[#fff] top-0 right-0 p-[0_0_.5rem_.5rem] rounded-[0_0_0_9999px]" title="{{ __('Email verified') }}">
				<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"><path fill="#00a762" d="m8.6 22.5l-1.9-3.2l-3.6-.8l.35-3.7L1 12l2.45-2.8l-.35-3.7l3.6-.8l1.9-3.2L12 2.95l3.4-1.45l1.9 3.2l3.6.8l-.35 3.7L23 12l-2.45 2.8l.35 3.7l-3.6.8l-1.9 3.2l-3.4-1.45zm2.35-6.95L16.6 9.9l-1.4-1.45l-4.25 4.25l-2.15-2.1L7.4 12z"/></svg>
			</span>
			@endif
		</div>
		<div class="ml-[195px] max-[560px]:ml-[165px] mb-[.5rem] text-left capitalize">{{ $user->name }}</div>
		<div class="ml-[195px] max-[560px]:ml-[165px] mb-[1rem] text-left max-[360px]:hidden">{{ __('Joined on') }} {{ format_date((string)$user->created_at, 'd M, Y') }}</div>
		@if(route_is('user.profile'))
		<button class="p-[.75rem] pb-[.5rem] rounded-[.25rem] absolute bottom-[-50px] right-0 text-[#3b3747] bg-[#fff] border-[1px] border-[#3b3747] font-[700] uppercase text-[.8rem] hover:border[#5c46a7] hover:text-[#5c46a7] max-[400px]:text-[.7rem] max-[400px]:px-[.35rem]" id="upload-avatar">{{ __('Upload avatar') }}</button>
		@endif
	</div>

	<div class="uppercase text-[.8rem] overflow-auto scrollbar-width-[none] whitespace-nowrap flex flex-nowrap items-center gap-x-[1rem] mb-[1rem] [&>div.active]:text-[#ff6d53] [&>div.active]:font-[600]" id="user-menu">
		<div data-href="{{ route('user.dashboard') }}" class="cursor-pointer whitespace-nowrap py-[.5rem] leading-[1] {{ route_is('user.dashboard') ? 'active' : '' }}">{{ __('Dashboard') }}</div>
		<span class="w-[1px] bg-[#cccccc] block relative bottom-[2px]">&nbsp;</span>
		<div data-href="{{ route('user.profile') }}" class="cursor-pointer whitespace-nowrap py-[.5rem] leading-[1] {{ route_is('user.profile') ? 'active' : '' }}">{{ __('Profile') }}</div>
		<span class="w-[1px] bg-[#cccccc] block relative bottom-[2px]">&nbsp;</span>
		<div data-href="{{ route('user.notifications') }}" class="cursor-pointer whitespace-nowrap py-[.5rem] leading-[1] {{ route_is('user.notifications') ? 'active' : '' }}">{{ __('Notifications') }}</div>
		<span class="w-[1px] bg-[#cccccc] block relative bottom-[2px]">&nbsp;</span>
		<div data-href="{{ route('user.collection') }}" class="cursor-pointer whitespace-nowrap py-[.5rem] leading-[1] {{ route_is('user.collection') ? 'active' : '' }}">{{ __('Collection') }}</div>
		<span class="w-[1px] bg-[#cccccc] block relative bottom-[2px]">&nbsp;</span>
		<div data-href="{{ route('user.purchases') }}" class="cursor-pointer whitespace-nowrap py-[.5rem] leading-[1] {{ route_is('user.purchases') ? 'active' : '' }}">{{ __('Purchases') }}</div>
		<span class="w-[1px] bg-[#cccccc] block relative bottom-[2px]">&nbsp;</span>
		@if(config('app.prepaid_credits.enabled'))
		<div data-href="{{ route('user.prepaid_credits') }}" class="cursor-pointer whitespace-nowrap py-[.5rem] leading-[1] {{ route_is('user.prepaid_credits') ? 'active' : '' }}">{{ __('Prepaid credits') }}</div>
		<span class="w-[1px] bg-[#cccccc] block relative bottom-[2px]">&nbsp;</span>
		@endif
		@if(intval(config('app.user_coupons_page')))
		<div data-href="{{ route('user.coupons') }}" class="cursor-pointer whitespace-nowrap py-[.5rem] leading-[1] {{ route_is('user.coupons') ? 'active' : '' }}">{{ __('Coupons') }}</div>
		<span class="w-[1px] bg-[#cccccc] block relative bottom-[2px]">&nbsp;</span>
		@endif
		<div data-href="{{ route('user.security') }}" class="cursor-pointer whitespace-nowrap py-[.5rem] leading-[1] {{ route_is('user.security') ? 'active' : '' }}">{{ __('Security') }}</div>
		<span class="w-[1px] bg-[#cccccc] block relative bottom-[2px]">&nbsp;</span>
		@if(config('app.subscriptions.enabled'))
		<div data-href="{{ route('user.subscriptions') }}" class="cursor-pointer whitespace-nowrap py-[.5rem] leading-[1] {{ route_is('user.subscriptions') ? 'active' : '' }}">{{ __('Subscriptions') }}</div>
		<span class="w-[1px] bg-[#cccccc] block relative bottom-[2px]">&nbsp;</span>
		@endif
		<div data-href="{{ route('user.invoices') }}" class="cursor-pointer whitespace-nowrap py-[.5rem] leading-[1] {{ route_is('user.invoices') ? 'active' : '' }}">{{ __('Invoices') }}</div>
	</div>

	<div class="border-t-[1px] pt-[1.5rem]">
		@yield('user_page')
	</div>

</div>
@endsection