@extends('front.axies.user.master')

@section('user_page')
<div class="" data-tab="notifications">
	<div class="relative overflow-auto scrollbar-width-[none]">
		<table class="table w-full table-auto text-[1rem] overflow-x-auto">
			<thead class="bg-[#555270] text-[#fff]">
				<tr class="[&>th]:p-[1rem] [&>th:not(:last-child)]:border-r-[1px] [&>th]:font-[600]">
					<th class="rounded-tl-[.25rem] w-[80px]">-</th>
					<th class="text-left">{{ __('Notification') }}</th>
					<th class="rounded-tr-[.25rem]">-</th>
				</tr>
			</thead>
			<tbody class="[&>tr:not(:last-child)]:border-b-[1px]">
				@foreach($notifications as $notification)
				<tr class="[&>td]:p-[1rem] [&>td:not(:last-child)]:border-r-[1px] {{ !$notification->read ? 'unread' : '' }} [&.unread]:bg-[#f7f7f7]">
					<td class="w-[80px]">
						<a class="w-[50px] min-w-[50px] min-h-[50px] h-[50px] block rounded-[.5rem] bg-cover bg-center" style="background-image: url('{{ $notification->image }}');" href="{{ route('home.product', ['id' => $notification->product_id, 'slug' => $notification->slug]) }}"></a>
					</td>
					<td>
						<div class="mb-[.5rem]">{!! __($notification->text, ['product_name' => "<a href=". route('home.product', ['id' => $notification->product_id, 'slug' => $notification->slug]) ."<a class='font-[600] opacity-[.75]'>{$notification->name}</a>"]) !!}</div>
						<div class="text-[.8rem] font-[400]">{{ format_date($notification->updated_at, 'd M, Y - H:i') }}</div>
					</td>
					<td class="">
						<button class="read-user-notification mx-auto p-[.25rem_.5rem] bg-[#4b5661] text-[#fff] h-[35px] w-[35px] flex items-center justify-center rounded-full" title="{{ __('Mark as read') }}" data-redirect="0" data-id="{{ $notification->id }}" data-href="{{ route('home.product', ['id' => $notification->product_id, 'slug' => $notification->slug . ($notification->for == 1 ? '?tab=comments' : ($notification->for == 2 ? '?tab=reviews' : ''))]) }}">
							<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 256 256"><path fill="currentColor" d="M247.31 124.76c-.35-.79-8.82-19.58-27.65-38.41C194.57 61.26 162.88 48 128 48S61.43 61.26 36.34 86.35C17.51 105.18 9 124 8.69 124.76a8 8 0 0 0 0 6.5c.35.79 8.82 19.57 27.65 38.4C61.43 194.74 93.12 208 128 208s66.57-13.26 91.66-38.34c18.83-18.83 27.3-37.61 27.65-38.4a8 8 0 0 0 0-6.5M128 192c-30.78 0-57.67-11.19-79.93-33.25A133.5 133.5 0 0 1 25 128a133.3 133.3 0 0 1 23.07-30.75C70.33 75.19 97.22 64 128 64s57.67 11.19 79.93 33.25A133.5 133.5 0 0 1 231.05 128c-7.21 13.46-38.62 64-103.05 64m0-112a48 48 0 1 0 48 48a48.05 48.05 0 0 0-48-48m0 80a32 32 0 1 1 32-32a32 32 0 0 1-32 32"/></svg>
						</button>
					</td>
				</tr>
				@endforeach
			</tbody>
		</table>
	</div>
</div>
@endsection