@extends('front.axies.user.master')

@section('user_page')
<div class="" data-tab="prepaid-credits">
	<div class="relative">
		<table class="table w-full text-[1rem] overflow-x-auto">
			<thead class="bg-[#555270] text-[#fff]">
				<tr class="[&>th]:p-[.75rem_1rem] [&>th]:text-center [&>th:not(:last-child)]:border-r-[1px] [&>th]:font-[600]">
					<th class="rounded-tl-[.25rem]">{{ __('Amount') }}</th>
					<th>{{ __('Credits') }}</th>
					<th>{{ __('Expires at') }}</th>
					<th>{{ __('Discount') }}</th>
					<th class="rounded-tr-[.25rem]">{{ __('Status') }}</th>
				</tr>
			</thead>
			<tbody class="[&>tr:not(:last-child)]:border-b-[1px]">
				@foreach($user_prepaid_credits as $user_prepaid_credit)
				<tr class="[&>td]:p-[.75rem_1rem] [&>td]:text-center [&>td:not(:last-child)]:border-r-[1px]">
					<td>{{ price($user_prepaid_credit->amount) }}</td>
					<td>{{ price($user_prepaid_credit->credits) }}</td>
					<td class="">{{ $user_prepaid_credit->expires_at ?? '-' }}</td>
					<td class="">{{ $user_prepaid_credit->discount ?? '0' }}%</td>
					<td class="">
						<div class="{{ $user_prepaid_credit->status }} [&.active]:bg-[rgb(5_224_127/15%)] [&.expired]:bg-[rgb(255_117_92/4%)] p-[.25rem] text-[.9rem] font-[600] rounded-[.35rem] [&.active]:text-[#096d63] [&.expired]:text-[#ff755c] capitalize">{{ $user_prepaid_credit->status }}</div>
					</td>
				</tr>
				@endforeach
			</tbody>
		</table>
	</div>

	@if($user_prepaid_credits->hasPages())
	<div class="mt-[1.5rem]">
		{{ $user_prepaid_credits->links('vendor.pagination.tailwind') }}
	</div>
	@endif
</div>
@endsection