@extends('front.axies.user.master')

@section('user_page')
<form class="" data-tab="security" action="{{ route('user.security') }}" method="POST">
	@csrf
	<div class="[&_input]:font-[400]">
		<div class="mb-[1.5rem]">
			<label class="mb-[.5rem] block">{{ __('Enable Two Factor Authentication') }}</label>
			<div class="single-selection">
				<div class="relative group mr-[1rem]">
					<input type="hidden" name="two_factor_auth" value="{{ old('two_factor_auth', $user->two_factor_auth ? '1' : '0') }}">
					<div class="default font-[400] text-[#000] rounded-[.5rem] border-[1px] px-[.75rem] py-[0] flex items-center h-[50px] capitalize">{{ __('Yes') }}</div>
					<div class="absolute hidden pb-[.5rem] left-[0] bottom-full z-[9] w-full">
						<div class="text-[1.1rem] bg-[#fff] w-full max-h-[320px] overflow-auto rounded-[.75rem] shadow-lg dark:bg-[#39405d]">
							<a role="button" data-value="0" class="option px-[1rem] py-[.5rem] block hover:bg-[aliceblue]">{{ __('No') }}</a>
							<a role="button" data-value="1" class="option px-[1rem] py-[.5rem] block hover:bg-[aliceblue]">{{ __('Yes') }}</a>
						</div>
					</div>
				</div>
			</div>
		</div>
		
		<div class="">
			<div class="mb-[1rem]">{{ __('Change password') }}</div>
			<div class="p-[1.5rem] bg-[#f7f7f7] rounded-[.5rem]">
				<div class="mb-[1.5rem]">
					<label class="mb-[.5rem] block text-[1rem]">{{ __('Current password') }}</label>
					<input type="text" name="old_password" value="" class="focus:outline-0 rounded-[.5rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d]" placeholder="{{ __('Enter your current password') }}">
				</div>
				<div class="mb-[1.5rem]">
					<label class="mb-[.5rem] block text-[1rem]">{{ __('New password') }}</label>
					<input type="text" name="new_password" value=""  class="focus:outline-0 rounded-[.5rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d]" placeholder="{{ __('Enter a new password') }}">
				</div>
				<div class="">
					<label class="mb-[.5rem] block text-[1rem]">{{ __('Confirm new password') }}</label>
					<input type="text" name="new_password_confirm" value=""  class="focus:outline-0 rounded-[.5rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d]" placeholder="{{ __('Confirm the new password') }}">
				</div>
			</div>
		</div>
	</div>

	<div class="my-[1.5rem] border-t-[1px]"></div>

	<div class="">
		<button class="p-[.75rem_.75rem_.5rem] font-[600] rounded-[.35rem] bg-[#353847] text-[#fff] text-[1rem] uppercase">{{ __('Save changes') }}</button>
	</div>
</form>
@endsection