@extends('front.tendra.master')

@section('head_tags')
<meta name="robots" content="noindex, nofollow">

<link rel="stylesheet" href="/assets/slick/slick.css">
<link rel="stylesheet" href="/assets/slick/slick-theme.css">

<script src="/assets/slick/slick.min.js"></script>

<script>
	'use strict';

	$(() =>
	{
		$('#payment-methods').slick({
			infinite: false,
			slidesToShow: 1,
			slidesToScroll: 1,
			nextArrow: $('#payment-methods-nav button.next'),
			prevArrow: $('#payment-methods-nav button.prev'),
		})
	})

	const checkoutConfig = @json($checkout_config);
</script>

@if(config("payment_gateways.{$payment_gateway['name']}.assets"))
@foreach(config("payment_gateways.{$payment_gateway['name']}.assets", []) as $asset)
	@if($asset["type"] == "js")
		<script type="text/javascript" charset="utf-8" 
						@if($asset["replace"] ?? null)
						src="{{ str_replace_adv($asset["src"], $asset["replace"]) }}" 
						@else
						src="{{ $asset["src"] }}"
						@endif
		{{ $asset["defer"] ? "defer" : "" }}></script>
	@elseif($asset["type"] == "css")
		<link rel="stylesheet" href="{{ $asset["src"] }}">
	@elseif($asset["type"] == "js_init")
		<script type="text/javascript" charset="utf-8" {{ $asset["defer"] ? "defer" : "" }}>
			"use strict";
			@if($asset["replace"] ?? null)
				{!! str_replace_adv($asset["code"], $asset["replace"]) !!}
			@else
				{!! $asset["code"] !!}
			@endif
		</script>
	@endif
@endforeach
@endif
@endsection


@section('body')
<div class="pt-[2rem] px-[1.5rem] relative">
	<div id="ckeckout-mask" class="absolute top-[2rem] hidden left-0 w-full h-full z-[9] bg-transparent">
		<div class="max-w-[1200px] mx-auto flex items-center justify-center h-full p-[2rem] rounded-[.5rem] overflow-hidden text-center bg-[#ffffff24] backdrop-blur-[2px]">
			<svg xmlns="http://www.w3.org/2000/svg" width="50" height="50" viewBox="0 0 24 24"><g><circle cx="12" cy="2.5" r="1.5" fill="currentColor" opacity=".14"/><circle cx="16.75" cy="3.77" r="1.5" fill="currentColor" opacity=".29"/><circle cx="20.23" cy="7.25" r="1.5" fill="currentColor" opacity=".43"/><circle cx="21.5" cy="12" r="1.5" fill="currentColor" opacity=".57"/><circle cx="20.23" cy="16.75" r="1.5" fill="currentColor" opacity=".71"/><circle cx="16.75" cy="20.23" r="1.5" fill="currentColor" opacity=".86"/><circle cx="12" cy="21.5" r="1.5" fill="currentColor"/><animateTransform attributeName="transform" calcMode="discrete" dur="0.75s" repeatCount="indefinite" type="rotate" values="0 12 12;30 12 12;60 12 12;90 12 12;120 12 12;150 12 12;180 12 12;210 12 12;240 12 12;270 12 12;300 12 12;330 12 12;360 12 12"/></g></svg>
		</div>
	</div>

	<div class="grid grid-cols-2 max-[1024px]:grid-cols-1 max-[1024px]:gap-[1.5rem] text-[rem] max-w-[1200px] mx-auto">
		<div class="p-[3rem] max-[768px]:p-[1.5rem] rounded-l-[.5rem] bg-[#353847] text-[#fff]">
			<div class="text-[1.5rem] flex items-center font-[600] uppercase text-center overflow-hidden">
				{{ __('Checkout') }}
			</div>

			@if($type === 'items') {{-- items --}}
			<div class="my-[2.5rem] border-b-[1px]"></div>
			<div class="">
				@foreach($cart_items as $cart_item)
				<div class="flex gap-[1.5rem] mb-[1.5rem]">
					<div class="bg-cover bg-center w-[90px] h-[90px] min-w-[90px] rounded-[.5rem] relative" style="background-image: url('{{ $cart_item['cover'] }}');"></div>
					<div class="text-[.9rem] flex flex-col relative flex-1">
						<a href="{{ $cart_item['url'] }}" class="block mb-[.5rem] max-w-[280px] h-[43px] overflow-hidden pr-[30px]">{{ $cart_item['name'] }}</a>
						<a href="{{ $cart_item['category_url'] }}" class="mt-auto table w-fit p-[.5rem_.75rem] pb-[.35rem] rounded-[.5rem] bg-[#4a4e62] text-[.8rem]">{{ $cart_item['category_name'] }}</a>
						<div class="absolute bottom-0 right-0">{{ price($cart_item['price']) }}</div>
						<div class="absolute top-0 right-0 cursor-pointer">
							<svg class="cursor-pointer remove-from-cart" data-id="{{ $cart_item['id'] }}" xmlns="http://www.w3.org/2000/svg" width="23" height="23" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-width="1.5"><path stroke-linecap="round" d="M20.5 6h-17m6 5l.5 5m4.5-5l-.5 5"></path><path d="M6.5 6h.11a2 2 0 0 0 1.83-1.32l.034-.103l.097-.291c.083-.249.125-.373.18-.479a1.5 1.5 0 0 1 1.094-.788C9.962 3 10.093 3 10.355 3h3.29c.262 0 .393 0 .51.019a1.5 1.5 0 0 1 1.094.788c.055.106.097.23.18.479l.097.291A2 2 0 0 0 17.5 6"></path><path stroke-linecap="round" d="M18.374 15.4c-.177 2.654-.266 3.981-1.131 4.79s-2.195.81-4.856.81h-.774c-2.66 0-3.99 0-4.856-.81c-.865-.809-.953-2.136-1.13-4.79l-.46-6.9m13.666 0l-.2 3"></path></g></svg>
						</div>
					</div>
				</div>
				@if(!$loop->last)
				<div class="my-[1.5rem] border-b-[1px] border-[#414556]"></div>
				@endif
				@endforeach
			</div>

			@elseif($type === "subscription") {{-- subscription --}}

			<div class="my-[2.5rem] border-b-[1px]"></div>

			<div class="p-[1.5rem] bg-[#3f4356] rounded-[.35rem]">
				<div class="mb-[1rem] uppercase bg-[#353847] p-[1rem] rounded-[.35rem] font-[600]">{{ $subscription->name }}</div>
				@if($subscription->description)
				<div class="mb-[1rem]">
					{{ $subscription->description }}
				</div>
				@endif
				<div class="flex items-end leading-[1] mb-[1rem]">
					<span class="text-[1.8rem] font-[600]">{{ price($subscription->price) }} / </span>
					<span class="text-[1rem]">{{ __($subscription->title) }}</span>
				</div>
				<div class="mt-[1rem] pt-[1rem] border-t-[1px] border-[#515465]">
					<div class="[&>div:not(:last-child)]:mb-[.75rem]">
						@if(strip_tags($subscription->description))
						{!! $subscription->description !!}
						@elseif($subscription->specifications)
							@foreach($subscription->specifications ?? [] as $specification)
							<div class="flex items-center gap-[.75rem] text-[1rem]">
								<div class="w-[30px] h-[30px] p-[.5rem] rounded-[.35rem] border-[1px] border-[#ffbe48] [&.active]:opacity-100 [&.active]:bg-[#ffbe48] [&:not(.active)]:opacity-25 {{ $specification->included ? 'active' : '' }}">
									<img src="/assets/images/checkbox-2.webp" class="w-full">
								</div>
								<div class="opacity-75 h-[24px] overflow-hidden">{{ $specification->text }}</div>
							</div>
							@endforeach
						@endif
					</div>
				</div>
			</div>

			@else {{-- prepaid_credit --}}

			<div class="my-[2.5rem] border-b-[1px]"></div>

			<div class="p-[1.5rem] bg-[#3f4356] rounded-[.35rem]">
				<div class="mb-[1.5rem] uppercase bg-[#353847] p-[1rem] rounded-[.35rem] font-[600]">{{ $prepaid_credit->name }}</div>
				<div class="flex items-end leading-[1] mb-[1rem]">
					<span class="text-[1.8rem] font-[600]">{{ price($prepaid_credit->amount) }}</span>
				</div>
				<div class="mt-[1rem] pt-[1rem] border-t-[1px] border-[#515465]">
					<div class="[&>div:not(:last-child)]:mb-[.75rem]">
						@foreach($prepaid_credit->specs as $spec)
						<div class="flex items-center gap-[.75rem] text-[1rem]">
							<div class="w-[30px] h-[30px] p-[.5rem] rounded-[.35rem] border-[1px] border-[#ffe064] bg-[#ffe064]">
								<img src="/assets/images/checkbox-2.webp" class="w-full">
							</div>
							<div class="opacity-75 overflow-hidden">{{ $spec }}</div>
						</div>
						@endforeach
					</div>
				</div>
			</div>

			@endif
		</div>

		<div class="p-[3rem] max-[768px]:p-[1.5rem] bg-[#fff] rounded-r-[.5rem]">
			<div class="text-[1.5rem] flex items-center font-[600] uppercase text-center rounded-[.5rem] overflow-hidden">
				{{ __('Order summary') }}
			</div>

			<div class="my-[2.5rem] border-b-[1px]"></div>

			<div class="mb-[2.5rem]">
				<div class="[&>div:not(:last-child)]:mb-[1rem]">
					<div class="flex justify-between gap-[1.5rem]">
						<div class="capitalize">{{ __('Initial amount') }}</div>
						<div class="font-[600] ml-auto">
							{{ price($total_amount, 0) }}
						</div>
					</div>

					<div class="flex justify-between gap-[1.5rem]">
						<div class="capitalize">{{ __('Purchase fee') }}</div>
						<div class="font-[600] ml-auto">
							{{ price($fee, 0) }}
						</div>
					</div>

					<div class="flex justify-between gap-[1.5rem]">
						<div class="capitalize">{{ __('Discount') }}</div>
						<div class="font-[600] ml-auto text-[#359f35]">
							{{ ($discount ? '- ' : '') . price($discount, 0) }}
						</div>
					</div>

					<div class="flex justify-between gap-[1.5rem]">
						<div class="capitalize">{{ __('Tax') }}</div>
						<div class="font-[600] ml-auto">
							{{ price($tax, 0) }}
						</div>
					</div>

					<div class="flex font-[600] justify-between gap-[1.5rem] pt-[1rem] mt-[1rem] border-t-[1px]">
						<div class="capitalize">{{ __('Due amount') }}</div>
						<div class="ml-auto">
							{{ price($due_amount, 0) }}
						</div>
					</div>
				</div>
			</div>

			@if($type !== "prepaid-credits")
			<div class="relative mb-[2.5rem]">
				<div class="mb-[.5rem] text-[1.1rem]">{{ __('Do you have a coupon ?') }}</div>
				<div id="coupon" class="text-[#000] flex items-center bg-[#f7f7f7] rounded-[.25rem] overflow-hidden w-full">
					<input type="text" name="coupon" value="{{ $coupon->code ?? null }}" class="outline-0 bg-transparent h-[55px] px-[.75rem] flex-1" placeholder="{{ __('Enter coupon code') }}">
					<button class="h-[55px] px-[1rem] bg-[#f06850] font-[600] text-[#fff]">{{ __('Submit') }}</button>
				</div>
			</div>
			@endif

			@if($due_amount > 0)
			<div class="my-[2.5rem] border-b-[1px]"></div>
			
			<div class="relative">
				<div class="mb-[1rem] flex items-center justify-between">
					<div class="text-[1.1rem] uppercase font-[600]">{{ __('Payment method') }}</div>
					@if(count($payment_processors) >= 2)
					<div id="payment-methods-nav" class="max-w-[80px] grid grid-cols-2 gap-[.75rem]">
						<button class="cursor-pointer prev">
							<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 24 24"><path fill="currentColor" d="m7 12l5-5v3h4v4h-4v3zm15 0a10 10 0 0 1-10 10A10 10 0 0 1 2 12A10 10 0 0 1 12 2a10 10 0 0 1 10 10m-2 0a8 8 0 0 0-8-8a8 8 0 0 0-8 8a8 8 0 0 0 8 8a8 8 0 0 0 8-8"/></svg>
						</button>
						<button class="cursor-pointer next">
							<svg xmlns="http://www.w3.org/2000/svg" class="cursor-pointer" transform="scale(-1,1)" width="25" height="25" viewBox="0 0 24 24"><path fill="currentColor" d="m7 12l5-5v3h4v4h-4v3zm15 0a10 10 0 0 1-10 10A10 10 0 0 1 2 12A10 10 0 0 1 12 2a10 10 0 0 1 10 10m-2 0a8 8 0 0 0-8-8a8 8 0 0 0-8 8a8 8 0 0 0 8 8a8 8 0 0 0 8-8"/></svg>
						</button>
					</div>
					@endif
				</div>
				<div id="payment-methods" class="">
					@foreach($payment_processors as $k => $payment_processor)
						@isset($payment_processor['enabled'])
							@if($type === "prepaid-credits" && $payment_processor['name'] === 'credits')
								@continue;
							@endif
							<div class="">
								<div class="text-[#fff] min-h-[120px] flex rounded-[.35rem] cursor-pointer bg-[#493e8b]  hover:bg-[#42397a] [&.active]:bg-[#42397a]">
									<div class="p-[1rem] border-r-[1px] border-[#5e51b1] flex items-center justify-center w-full max-w-[60px]">
										<input id="gateway-{{ $k }}" name="gateway" value="{{ $payment_processor['name'] }}" type="radio" class="w-[25px] h-[25px] appearance-none border-[1px] border-[#fff] rounded-full checked:bg-[#8b60ff] checked:border-0 relative before:content-['✓'] before:text-[#fff] before:text-transparent checked:before:text-[#fff] before:h-full before:w-full before:top-0 before:left-0 before:leading-1 before:flex before:items-center before:justify-center before:text-[.9rem] before:font-semibold" role="button" {{ ($payment_gateway && $payment_gateway['name']  === $payment_processor['name']) ? 'checked' : '' }}>
									</div>
									<label for="gateway-{{ $k }}" class="p-[1rem] flex-1">
										<div class="uppercase bg-[#5e51b1] mb-[.75rem] font-[600] text-[.8rem] p-[.5rem_.75rem] pb-[.35rem] rounded-[.25rem] table">{{ $payment_processor['name'] }}</div>
										<div class="text-[.9rem]">{{ $payment_processor['description'] }}</div>
									</label>
								</div>
							</div>
						@endisset
					@endforeach
				</div>
			</div>
			@endif

			@if($payment_gateway || $due_amount <= 0)
			<div class="mb-[2.5rem] border-b-[1px]"></div>

			<form action="{{ route('home.checkout.payment') }}" method="POST" id="checkout-form" @if(config("payment_gateways.{$payment_gateway['name']}.form.checkout_buttons")) class="has-checkout-button" data-checkout-button="{{ config("payment_gateways.{$payment_gateway['name']}.form.checkout_buttons.0.id") }}" @endif>
				@csrf

				<input type="hidden" name="checkout_config" value="{{ encrypt(json_encode($checkout_params), false) }}">
				<input type="hidden" name="cart_id" :value="cartUuid">

				@if(config("payment_gateways.{$payment_gateway['name']}.form.checkout_buttons"))
					@foreach(config("payment_gateways.{$payment_gateway['name']}.form.checkout_buttons", []) as $checkout_button)
						@if($checkout_button["replace"] ?? null)
						{!! str_replace_adv($checkout_button["html"], $checkout_button["replace"]) !!}
						@else
						{!! $checkout_button["html"] !!}
						@endif
					@endforeach
				@endif

				@if(config("payment_gateways.{$payment_gateway['name']}.form.inputs"))
				<div class="grid grid-cols-2 gap-[1rem] mb-[1.5rem]">
					@foreach(config("payment_gateways.{$payment_gateway['name']}.form.inputs", []) as $input_name => $input_config)
					@php
						$input_attrs = implode(' ', $input_config['attributes'] ?? []);

						if($input_config['replace'])
						{
							$input_config['value'] = str_replace_adv($input_config['value'], $input_config['replace']);
						}
					@endphp
					<div class="{{ $input_config['type'] === 'hidden' ? 'hidden' : '' }}">
						<label class="mb-[.5rem] block">{{ __($input_config['label']) }}</label>
						<input {{ $input_attrs }} type="{{ $input_config['type'] }}" name="{{ $input_name }}" class="focus:outline-0 rounded-[.5rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d]" placeholder="..." value="{{ $input_config['value'] }}">
					</div>
					@endforeach
				</div>
				@endif

				@if(config('payments.guest_checkout') && !\Auth::check())
				<div class="mb-[1.5rem]">
					<div class="text-[1.1rem] uppercase font-[600]">{{ __('Email address') }}</div>
					<input type="email" name="guest_email" class="focus:outline-none rounded-[.5rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d]" placeholder="...">
					<small class="flex gap-[.5rem] mt-[.25rem]">
						<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24"><g fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M11.958 7.563v6.166"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 17.139h-.009"/><rect width="18.5" height="18.5" x="2.75" y="2.75" stroke-width="1.5" rx="6"/></g></svg>
						{{ __('An email address to receive download links') }}
					</small>
				</div>
				@endif

				@if(config("payment_gateways.{$payment_gateway['name']}.form.note") && request()->query('type') === 'items')
				<div class="mb-[2.5rem] p-[1rem] bg-[whitesmoke] rounded-[.25rem]">
					{!! nl2br(str_replace_adv(config("payment_gateways.{$payment_gateway['name']}.form.note.html"), config("payment_gateways.{$payment_gateway['name']}.form.note.replace"))) !!}
				</div>
				@endif
				
				@if(config('payments.buyer_note') && count($cart_items))
				<div class="mb-[1.5rem]">
					<div class="text-[1.1rem] uppercase font-[600]">{{ __('Notes') }} <sup>({{ __('Optional') }})</sup></div>
					<textarea name="notes" id="checkout_notes" class="focus:outline-0 rounded-[.5rem] w-full p-[1rem] border-[1px] text-[#3d3d3d]"></textarea>
				</div>
				@endif

				@if(config('payments.tos'))
				<div class="flex mb-[1rem] text-[1rem] gap-[.5rem]">
					<input type="checkbox" id="tos" class="w-[18px] h-[18px] appearance-none border-[1px] border-[#000] rounded-[.25rem] checked:bg-[#37495D] checked:border-0 relative before:content-['✓'] before:text-[#fff] before:text-transparent checked:before:text-[#fff] before:h-full before:w-full before:top-0 before:left-0 before:leading-1 before:flex before:items-center before:justify-center before:text-[.9rem] before:font-semibold" role="button" name="tos">
					<label for="tos">{{ __("I agree to the") }} <a href="" class="font-[600]">{{ __('Terms and conditions') }}</a></label>
				</div>
				@endif

				<button type="submit" class="table min-w-[150px] text-center p-[.75rem_1rem] pb-[.5rem] bg-[#ffd877]  hover:bg-[#ffca46] font-[600] rounded-[.35rem]">{{ __('Checkout') }}</a>
			</form>
			@endif
		</div>
	</div>
</div>
@endsection