@extends('front.tendra.master')

@section('body')
{{-- HERO --}}
<div class="pb-[5rem] relative top-[-90px] pt-[130px] flex items-center flex-col justify-start bg-[radial-gradient(#3f4a54,#2a3137)] after:content-[''] after:h-full after:w-full after:absolute after:top-0 after:left-0 after:bg-[linear-gradient(180deg,#00000014_50%,transparent_70%)] [&>*:not(.absolute)]:relative [&>*]:z-[2] px-[1.5rem]">
	<div class="top-0 left-0 w-full h-full absolute bg-bottom bg-cover opacity-[.3]" style="background-image:url('{{ src('storage/images/'.config('app.top_cover')) }}')"></div>
	<div class="text-[2.5rem] font-[700] max-[650px]:font-[600] max-w-[800px] mx-auto text-center leading-[1.8] capitalize text-[#fff] max-[768px]:text-[1.8rem]">
		{{ config('app.search_header', config('app.title')) }}
	</div>
	<div class="max-w-[500px] w-full mt-[2rem] relative" id="live-search">
		<form class="flex items-center" action="{{ route('home.products.q') }}" method="GET">
			<input type="search" name="q" class="rounded-l-[.5rem] w-full h-[55px] bg-[#ffffff26] px-[1rem] text-[#fff] border-0 focus:outline-none placeholder-[#cbd5e0]" placeholder="{{ __('Enter a title or some keywords') }}...">
			<button class="rounded-r-[.5rem] p-[.5rem_1.5rem] h-[55px] bg-[#68359A] text-[#fff] flex items-center font-semibold" type="submit">
				{{ __('Search') }}
			</button>
		</form>
		<div class="absolute hidden left-0 top-[65px] w-full h-[347px] rounded-[.5rem] bg-[#fff] p-[1rem] text-[1rem] [&>a:not(:last-child)]:mb-[1rem]" id="live-search-products"></div>
	</div>
</div>

{{-- USER PERSONAL NOTIFICATION --}}
@if(config('app.users_notif'))
<div class="hidden mt-[-90px] mb-[180px] text-[#fff] p-[1.25rem_1rem] relative mx-auto bg-[#424251] font-[400] leading-[1.8] text-[1.1rem] text-center pr-[55px]">
	<button type="button" class="close absolute right-[.75rem] top-[.75rem] rounded-[.25rem] bg-[#4c4c5e] border-[1px] border-[#eb9f5e] w-[25px] h-[25px] font-[system-ui] flex items-center justify-center text-[#fff] text-[1.1rem]">✕</button>
	<span class="">{{ config('app.users_notif') }}</span>
</div>
@endif

{{-- SECTIONS --}}
<div class="mt-[-90px] mb-[5rem] px-[1.5rem]">
	{{-- NEWEST ITEMS --}}
	<div class="mt-[4rem] max-w-[1200px] w-full mx-auto">
		<div class="text-center">
			<div class="text-[2.2rem] font-[600] capitalize">{{ __('Our newest items') }}</div>
			<div class="mt-[.5rem] text-[1.2rem] opacity-75 max-w-[800px] mx-auto">
				{{ __('Explore our newest Digital Products, from Development to Other Teaching & Academics, we always have something interesting for you') }}
			</div>
		</div>
		<div class="mt-[2rem] flex gap-[1.5rem] [&>div]:w-[calc((100%/6)-1.5rem+(1.5rem/6))] max-[1024px]:[&>div]:w-[calc((100%/5)-1.5rem+(1.5rem/5))] max-[1024px]:[&>div]:w-[calc((100%/4)-1.5rem+(1.5rem/4))] max-[768px]:[&>div]:w-[calc((100%/4)-1.5rem+(1.5rem/4))] max-[650px]:[&>div]:w-[calc((100%/3)-1.5rem+(1.5rem/3))] max-[560px]:[&>div]:w-[calc((100%/2)-1.5rem+(1.5rem/2))] max-[400px]:[&>div]:w-[calc((100%/1)-1.5rem+(1.5rem/1))] flex-wrap justify-center">
			@foreach($newest_products as $product)
			<div class="">
				<div class="block relative bg-cover bg-center h-[180px] rounded-[.5rem]" style="background-image: url('{{ src("/storage/covers/{$product->cover}") }}');">
					<a href="{{ item_url($product) }}" class="absolute w-full h-full block z-0"></a>
					<span class="absolute z-[1] top-[.75rem] right-[.75rem] group cursor-default opacity-50 add-to-collection" data-id="{{ $product->id }}">
						<svg xmlns="http://www.w3.org/2000/svg" :class="{hidden: itemInCollection('{{ $product->id }}')}" width="20" height="20" viewBox="0 0 20 20"><path fill="currentColor" d="M13.682 1.682c2.007-.48 3.667.026 4.849 1.094c1.032.934 1.628 2.559 1.432 4.39c-.147 1.374-.893 2.769-2.242 4.22l-7.274 6.923a.7.7 0 0 1-.963-.002L2.266 11.36C1.198 10.227.516 9.15.233 8.118C-.18 6.62-.04 5.107.61 3.875c.77-1.461 2.306-2.329 4.532-2.329c1.522 0 3.12.753 4.805 2.221c1.148-1.066 2.394-1.765 3.735-2.085M9.97 16.883l6.76-6.433c1.138-1.226 1.75-2.37 1.863-3.425c.151-1.415-.29-2.619-.997-3.258c-.859-.777-2.056-1.142-3.588-.776c-1.257.3-2.434 1.02-3.538 2.174a.7.7 0 0 1-.981.025C7.852 3.644 6.397 2.895 5.142 2.895c-1.722 0-2.78.597-3.307 1.598c-.489.926-.597 2.094-.272 3.275c.218.795.786 1.692 1.692 2.655z"/></svg>
						<svg xmlns="http://www.w3.org/2000/svg" :class="{hidden: !itemInCollection('{{ $product->id }}')}" width="20" height="20" viewBox="0 0 20 20"><path fill="#ff3b3b" d="M13.67 1.658c2.103-.494 4.165.222 5.135 1.434c.896 1.119 1.303 2.282 1.17 3.998c-.095 1.237-.5 2.154-1.298 3.163c-.147.186-.308.377-.511.609l-.548.618c-.8.903-3.155 3.163-7.103 6.82a.764.764 0 0 1-1.036-.004C6.09 15.12 3.896 13.028 2.89 12.014C1.033 10.14.326 9.05.07 7.293c-.27-1.84.245-3.349 1.398-4.521c1.082-1.1 3.017-1.508 4.928-1.12c1.119.228 2.31.96 3.6 2.181c1.101-1.129 2.327-1.86 3.675-2.175"/></svg>
					</span>
					<span class="cursor-default {{ $product->has_promo() ? 'has-promo' : '' }} [&.has-promo]:bg-[#00966591] font-[600] absolute z-[1] bottom-[.75rem] left-[.75rem] rounded-[.35rem] bg-[#392d2233] text-[#fff] backdrop-blur-[5px] text-[.8rem] p-[.2rem_.5rem] select-none">
						@if($product->has_promo())
						{{ $product->promo_price }}
						@else
						{{ price($product->price) }}
						@endif
					</span>
				</div>
				<a href="{{ item_url($product) }}" class="text-[1rem] block font-[500] mt-[.5rem] max-h-[72px] overflow-hidden">{{ $product->name }}</a>
			</div>
			@endforeach
		</div>
	</div>

	<div class="table max-w-[500px] w-full relative h-[1px] bg-[whitesmoke] m-[6rem_auto_4rem]"></div>

	{{-- FEATURED ITEMS --}}
	<div class="max-w-[1200px] w-full mx-auto" id="featured-products">
		<div class="text-center">
			<div class="text-[2.2rem] font-[600] capitalize">{{ __('Our featured items') }}</div>
			<div class="mt-[.5rem] text-[1.2rem] opacity-75 max-w-[800px] mx-auto">
				{{ __("Explore a handpicked assortment of our top products from this week's lineup") }}
			</div>
		</div>

		<div class="flex gap-[1rem] flex-wrap justify-center mt-[2.5rem] text-[.9rem] menu">
			@foreach($featured_products as $category_slug => $items_list)
    			@foreach(config('categories.category_parents') ?? [] as $category)
        		@if($category_slug == $category['slug'])
        			<button class="tab {{ $loop->parent->first ? 'active' : '' }} uppercase p-[.5rem_1rem] bg-[#fff] h-[50px] flex items-center justify-center leading-[1] rounded-[.5rem] hover:shadow-[0_0_0_1px_grey_inset] [&.active]:shadow-[0_0_0_1px_grey_inset]" data-category="{{ md5($category['slug']) }}">{{ $category['name'] }}</button>
    			@endif
				@endforeach
			@endforeach
		</div>

		@foreach($featured_products as $category_slug => $items_list)
		<div class="mt-[2.5rem] gap-[1.5rem] max-[1199px]:grid-cols-3 hidden [&.active]:grid max-[900px]:grid-cols-2 max-[650px]:grid-cols-1 grid-cols-4 {{ $category_slug }} {{ $loop->first ? 'active' : '' }}" data-section="{{ md5($category_slug) }}">
			@foreach($items_list as $product)
			<div class="overflow-hidden rounded-[.5rem] text-[1rem] max-[650px]:grid max-[650px]:grid-cols-2 max-[650px]:gap-[1rem] max-[560px]:block shadow-[0_0_20px_10px_#00000005] p-[1rem] max-[650px]:p-[1.5rem]">
				<div class="relative mb-[1rem]">
					<a href="{{ item_url($product) }}" class="flex">
						<img src="{{ src("/storage/covers/{$product->cover}") }}" class="rounded-[.5rem]">
					</a>
					<span class="absolute z-[1] top-[.75rem] right-[.75rem] group cursor-default opacity-50 add-to-collection" data-id="{{ $product->id }}">
						<svg xmlns="http://www.w3.org/2000/svg" :class="{hidden: itemInCollection('{{ $product->id }}')}" width="20" height="20" viewBox="0 0 20 20"><path fill="currentColor" d="M13.682 1.682c2.007-.48 3.667.026 4.849 1.094c1.032.934 1.628 2.559 1.432 4.39c-.147 1.374-.893 2.769-2.242 4.22l-7.274 6.923a.7.7 0 0 1-.963-.002L2.266 11.36C1.198 10.227.516 9.15.233 8.118C-.18 6.62-.04 5.107.61 3.875c.77-1.461 2.306-2.329 4.532-2.329c1.522 0 3.12.753 4.805 2.221c1.148-1.066 2.394-1.765 3.735-2.085M9.97 16.883l6.76-6.433c1.138-1.226 1.75-2.37 1.863-3.425c.151-1.415-.29-2.619-.997-3.258c-.859-.777-2.056-1.142-3.588-.776c-1.257.3-2.434 1.02-3.538 2.174a.7.7 0 0 1-.981.025C7.852 3.644 6.397 2.895 5.142 2.895c-1.722 0-2.78.597-3.307 1.598c-.489.926-.597 2.094-.272 3.275c.218.795.786 1.692 1.692 2.655z"/></svg>
						<svg xmlns="http://www.w3.org/2000/svg" :class="{hidden: !itemInCollection('{{ $product->id }}')}" width="20" height="20" viewBox="0 0 20 20"><path fill="#ff3b3b" d="M13.67 1.658c2.103-.494 4.165.222 5.135 1.434c.896 1.119 1.303 2.282 1.17 3.998c-.095 1.237-.5 2.154-1.298 3.163c-.147.186-.308.377-.511.609l-.548.618c-.8.903-3.155 3.163-7.103 6.82a.764.764 0 0 1-1.036-.004C6.09 15.12 3.896 13.028 2.89 12.014C1.033 10.14.326 9.05.07 7.293c-.27-1.84.245-3.349 1.398-4.521c1.082-1.1 3.017-1.508 4.928-1.12c1.119.228 2.31.96 3.6 2.181c1.101-1.129 2.327-1.86 3.675-2.175"/></svg>
					</span>
				</div>
				<div class="">
					<div class="mb-[1rem]">
						<a href="{{ item_url($product) }}" class="block h-[50px] overflow-hidden font-[600] opacity-75">{{ $product->name }}</a>
					</div>
					<div class="flex items-center justify-between">
						<a href="{{ category_url($product->category['slug']) }}" class="max-w-[50%] bg-[#FEF098] text-[#975b07] text-[.8rem] font-[600] p-[.325rem_.75rem] font-[500] rounded-full bg-[#ffe3b9] overflow-hidden text-ellipsis whitespace-nowrap" title="">{{ \Str::limit($product->category['name'], 40) }}</a>
						<div class="ml-auto">
							<div class="h-[28px] w-[28px] bg-[#392d22]" style="-webkit-mask-image:url('/assets/images/uiw_star-on.svg'); -webkit-mask-position:bottom center; -webkit-mask-size:cover;-webkit-mask-repeat:no-repeat">
								<span class="bg-[#ff9900] h-[28px] block" style="width:{{ rand(10, 75) }}%"></span>
							</div>
						</div>
					</div>
					<div class="text-[.9rem] mt-[1rem] font-[400] h-[65px] overflow-hidden">
						{{ $product->short_description }}
					</div>
					<div class="flex items-end justify-between mt-[1rem] h-[40px]">
						<div class="text-[1.2rem] font-[600] mr-[1rem] leading-[1] select-none">
							@if($product->has_promo())
							<span class="text-[#0a7d44]">{{ price($product->promo_price) }}</span>
							@else
							{{ price($product->price) }}
							@endif
						</div>
						<div data-id="{{ $product->id }}" class="cursor-pointer buy-now h-[40px] bg-[#392D22] rounded-[.5rem] text-[#fff] flex items-center px-[1rem] gap-x-[.5rem]">
							<span class="whitespace-nowrap">{{ __('Buy now') }}</span>
							<svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 24 24"><g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" color="currentColor"><path d="m3.062 14.441l.365-2.142c.432-2.533.647-3.8 1.502-4.55C5.784 7 7.012 7 9.467 7h5.066c2.455 0 3.683 0 4.538.75s1.07 2.016 1.502 4.549l.365 2.142c.598 3.505.896 5.257-.023 6.408C19.995 22 18.295 22 14.898 22H9.102c-3.398 0-5.097 0-6.017-1.15c-.92-1.152-.62-2.904-.023-6.409"/><path d="m7.5 9l.215-3.01a4.296 4.296 0 0 1 8.57 0L16.5 9"/></g></svg>
						</div>
					</div>
				</div>
			</div>
			@endforeach
		</div>
		@endforeach
	</div>

	<div class="table max-w-[500px] w-full relative h-[1px] bg-[whitesmoke] m-[6rem_auto_4rem]"></div>

	{{-- PRICING TABLE --}}
	<div class="max-w-[1200px] w-full mx-auto">
		<div class="text-center">
			<div class="text-[2.2rem] font-[600] capitalize">{{ __('Our pricing plans') }}</div>
			<div class="mt-[.5rem] text-[1.2rem] opacity-75 max-w-[800px] mx-auto">
				{{ __('Explore our pricing plans, from Standard to Professional, choose the one that meets your needs.') }}
			</div>
		</div>
		<div class="grid grid-cols-3 max-[950px]:grid-cols-2 max-[650px]:grid-cols-1 gap-[2rem] max-w-[1100px] mx-auto mt-[2rem]">
			@foreach($subscriptions as $subscription)
			<div class="relative rounded-[.5rem] p-[1.5rem] bg-[#fff] shadow-[0_0_20px_10px_#00000005] [&.popular] {{ $subscription->popular === '1' ? 'popular' : '' }}">
				<div class="">
					<div class="font-[600] mb-[.75rem] uppercase text-[1rem]">{{ $subscription->name }}</div>
					<div class="text-[1rem] opacity-75 h-[48px] overflow-hidden">{{ $subscription->subheading }}</div>
				</div>
				<div class="mt-[1.5rem]">
					<div class="flex items-end leading-[1]">
						<span class="text-[1.8rem] font-[600] select-none">{{ price($subscription->price) }} / </span>
						<span class="text-[1rem]">{{ __($subscription->title) }}</span>
					</div>
				</div>
				<div class="mt-[1.5rem] pt-[1.5rem] border-t-[1px]">
					<a href="{{ route('home.checkout', ['id' => $subscription->id, 'type' => 'subscription']) }}" class="capitalize text-[1rem] bg-[#163020] text-[#adffcc] font-[600] rounded-[.5rem] p-[.75rem_1rem] block text-center">{{ __("Get started") }}</a>
				</div>
				<div class="mt-[1.5rem] pt-[1.5rem] border-t-[1px]">
					<div class="text-[.9rem] uppercase mb-[1rem]">{{ __('Included features') }}</div>
					<div class="[&>div:not(:last-child)]:mb-[.75rem]">						
						@if(strip_tags($subscription->description))
						{!! $subscription->description !!}
						@elseif($subscription->specifications)
							@foreach($subscription->specifications ?? [] as $specification)
							<div class="flex items-center gap-[.75rem] text-[1rem]">
								<div class="w-[30px] h-[30px] p-[.5rem] rounded-[.35rem] border-[1px] border-[#9CFF2E] [&.active]:opacity-100 [&.active]:bg-[#9CFF2E] [&:not(.active)>img]:opacity-25 {{ $specification->included ? 'active' : '' }}">
									<img src="/assets/images/checkbox-2.webp" class="w-full">
								</div>
								<div class="opacity-75 h-[24px] overflow-hidden">{{ $specification->text }}</div>
							</div>
							@endforeach
						@endif
					</div>
				</div>
			</div>
			@endforeach
		</div>
	</div>

	<div class="table max-w-[500px] w-full relative h-[1px] bg-[whitesmoke] m-[6rem_auto_4rem]"></div>

	{{-- BLOG --}}
	<div class="max-w-[1200px] w-full mx-auto">
		<div class="text-center">
			<div class="text-[2.2rem] font-[600] capitalize">{{ __('Our latest news') }}</div>
			<div class="mt-[.5rem] text-[1.2rem] opacity-75 max-w-[800px] mx-auto">
				{{ __('Explore our latest articles for more ideas and inspiration, technology, design, tutorials, business and much more') }}
			</div>
		</div>
		<div class="grid grid-cols-4 max-[1024px]:grid-cols-3 max-[1024px]:[&>div:nth-child(n+4)]:hidden max-[800px]:grid-cols-2 max-[560px]:grid-cols-1 max-[800px]:[&>div:nth-child(n+4)]:block gap-[1.5rem] mt-[2rem]">
			@foreach($posts as $post)
			<div class="rounded-[.5rem] overflow-hidden p-[1rem] bg-[#fff] text-[1rem]">
				<div class="relative">
					<a href="{{ route('home.post', ['slug' => $post->slug]) }}" class="block"><img src="{{ src("/storage/posts/{$post->cover}") }}" class="rounded-[.5rem]"></a>
					@isset($post->category['slug'])
					<a href="{{ route('home.blog.category', ['category' => $post->category['slug']]) }}" class="absolute left-[.75rem] top-[.75rem] text-[.8rem] p-[.5rem_.75rem] leading-[1] text-[#fff] block bg-[#ffffff5c] backdrop-blur-[5px] rounded-[.5rem] hover:bg-[#fff] hover:text-[#000] transition-all">
						{{ \Str::limit($post->category['name']) }}
					</a>
					@endisset
				</div>
				<div class="mt-[1.25rem]">
					<div class="mb-[1.25rem] text-[.9rem] flex items-end gap-x-[.5rem]">
						<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"><path fill="currentColor" d="M17 14a1 1 0 1 0 0-2a1 1 0 0 0 0 2m0 4a1 1 0 1 0 0-2a1 1 0 0 0 0 2m-4-5a1 1 0 1 1-2 0a1 1 0 0 1 2 0m0 4a1 1 0 1 1-2 0a1 1 0 0 1 2 0m-6-3a1 1 0 1 0 0-2a1 1 0 0 0 0 2m0 4a1 1 0 1 0 0-2a1 1 0 0 0 0 2"/><path fill="currentColor" fill-rule="evenodd" d="M7 1.75a.75.75 0 0 1 .75.75v.763c.662-.013 1.391-.013 2.193-.013h4.113c.803 0 1.532 0 2.194.013V2.5a.75.75 0 0 1 1.5 0v.827c.26.02.506.045.739.076c1.172.158 2.121.49 2.87 1.238c.748.749 1.08 1.698 1.238 2.87c.153 1.14.153 2.595.153 4.433v2.112c0 1.838 0 3.294-.153 4.433c-.158 1.172-.49 2.121-1.238 2.87c-.749.748-1.698 1.08-2.87 1.238c-1.14.153-2.595.153-4.433.153H9.945c-1.838 0-3.294 0-4.433-.153c-1.172-.158-2.121-.49-2.87-1.238c-.748-.749-1.08-1.698-1.238-2.87c-.153-1.14-.153-2.595-.153-4.433v-2.112c0-1.838 0-3.294.153-4.433c.158-1.172.49-2.121 1.238-2.87c.749-.748 1.698-1.08 2.87-1.238c.233-.031.48-.056.739-.076V2.5A.75.75 0 0 1 7 1.75M5.71 4.89c-1.005.135-1.585.389-2.008.812c-.423.423-.677 1.003-.812 2.009c-.023.17-.042.35-.058.539h18.336c-.016-.19-.035-.369-.058-.54c-.135-1.005-.389-1.585-.812-2.008c-.423-.423-1.003-.677-2.009-.812c-1.027-.138-2.382-.14-4.289-.14h-4c-1.907 0-3.261.002-4.29.14M2.75 12c0-.854 0-1.597.013-2.25h18.474c.013.653.013 1.396.013 2.25v2c0 1.907-.002 3.262-.14 4.29c-.135 1.005-.389 1.585-.812 2.008c-.423.423-1.003.677-2.009.812c-1.027.138-2.382.14-4.289.14h-4c-1.907 0-3.261-.002-4.29-.14c-1.005-.135-1.585-.389-2.008-.812c-.423-.423-.677-1.003-.812-2.009c-.138-1.027-.14-2.382-.14-4.289z" clip-rule="evenodd"/></svg>
						<span class="leading-[1]">{{ $post->created_at->format('J m, Y') }}</span>
					</div>
					<div class="flex gap-[.5rem] mb-[1.25rem]">
						@foreach(array_slice(array_map('trim', explode(',', $post->tags)), 0, 3) as $tag)
						<a href="{{ route('home.blog.tag', ['tag' => $tag]) }}" class="text-[.8rem] bg-[#ffe0b2] text-[#59401c] font-[600] rounded-[.5rem] p-[.25rem_.5rem] whitespace-nowrap text-ellipsis overflow-hidden">
							{{ $tag }}
						</a>
						@endforeach
					</div>
					<a href="{{ route('home.post', ['slug' => $post->slug]) }}" class="block h-[50px] overflow-hidden font-[600] opacity-75">{{ $post->name }}</a>
					<div class="mt-[1rem] flex items-end">
						<div class="flex items-center gap-[.5rem] relative bottom-[-5px] opacity-75">
							<svg xmlns="http://www.w3.org/2000/svg" class="relative bottom-[1px]" width="25px" height="25px" viewBox="0 0 256 256"><path fill="currentColor" d="M245.48 125.57c-.34-.78-8.66-19.23-27.24-37.81C201 70.54 171.38 50 128 50S55 70.54 37.76 87.76c-18.58 18.58-26.9 37-27.24 37.81a6 6 0 0 0 0 4.88c.34.77 8.66 19.22 27.24 37.8C55 185.47 84.62 206 128 206s73-20.53 90.24-37.75c18.58-18.58 26.9-37 27.24-37.8a6 6 0 0 0 0-4.88M128 194c-31.38 0-58.78-11.42-81.45-33.93A134.8 134.8 0 0 1 22.69 128a134.6 134.6 0 0 1 23.86-32.06C69.22 73.42 96.62 62 128 62s58.78 11.42 81.45 33.94A134.6 134.6 0 0 1 233.31 128C226.94 140.21 195 194 128 194m0-112a46 46 0 1 0 46 46a46.06 46.06 0 0 0-46-46m0 80a34 34 0 1 1 34-34a34 34 0 0 1-34 34"/></svg>
							<span class="leading-[1] text-[.9rem]">{{ $post->views }}</span>
						</div>
						<a href="{{ route('home.post', ['slug' => $post->slug]) }}" class="table ml-auto leading-[1] p-[.65rem_1rem] bg-[#504661] text-[#fff] rounded-[.5rem]">{{ __('Read more') }}</a>
					</div>
				</div>
			</div>
			@endforeach
		</div>
	</div>
</div>
@endsection