@extends('front.tendra.master')

@section('body')
<div class="py-[.75rem] flex items-center bg-[#493b69] text-[#fff]">
	<div class="max-w-[1200px] w-full mx-auto">
		<div class="flex font-[500] items-center gap-x-[.5rem] text-[1rem]">
			<a href="/" class="h-[30px] flex items-center gap-x-[.5rem] p-[.5rem_.65rem] pb-[.35rem] bg-[#fff] rounded-[.25rem] text-[#6d52ab] justify-center">
				<span class=""><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 16 16"><path fill="currentColor" d="M6.906.384a1.75 1.75 0 0 1 2.187 0l5.25 4.2c.415.332.657.835.657 1.367v7.019a1.75 1.75 0 0 1-1.75 1.75h-2.5a.75.75 0 0 1-.75-.75V8.72H6v5.25a.75.75 0 0 1-.75.75h-2.5A1.75 1.75 0 0 1 1 12.97V5.95c0-.531.242-1.034.657-1.366z"/></svg></span>
				<span class="h-auto relative bottom-[-2px]">Home</span>
			</a>
			<span class="h-[30px] flex items-center">|</span>
			<div href="" class="h-[30px] p-[.5rem_.65rem] pb-[.35rem] bg-[#64538b] text-[#fff] flex items-center justify-center rounded-[.25rem]">{{ __('Blog') }}</div>
			<span class="h-[30px] flex items-center">|</span>
			<a href="" class="h-[30px] p-[.5rem_.65rem] pb-[.35rem] bg-[#64538b] text-[#fff] flex items-center justify-center rounded-[.25rem]">Neon 4k hd best for desktop wallpaper</a>
		</div>
	</div>
</div>


<div class="p-[2rem] bg-[#eee]">
	<div class="max-w-[1200px] w-full mx-auto grid grid-cols-2 gap-[2rem] min-h-[350px]">
		<div class="py-[1rem]">
			<div class="flex flex-col justify-center h-full">
				<div class="font-[500] opacity-75 uppercase mb-[1.5rem]">{{ $post->category }}</div>
				<div class="mb-[2rem] h-[.5rem] rounded-full w-[10%] bg-[grey]"></div>
				<div class="font-[600] text-[2.2rem] mb-[1.5rem]">{{ $post->name }}</div>
				<div class="opacity-75">{{ $post->short_description }}</div>
			</div>
		</div>
		<div style="background-image: url('{{ src("storage/posts/{$post->cover}")  }}');" class="bg-cover bg-center h-full rounded-[.5rem]"></div>
	</div>
</div>

<div class="mt-[3rem]">
	<div class="max-w-[800px] mx-auto px-[2rem]">
		{{-- POST DESCRIPTION --}}
		<div class="">
			{!! $post->content !!}
		</div>

		<div class="my-[2rem] border-t-[1px]"></div>
	</div>

	<div class="max-w-[900px] mx-auto">
		<div class="font-[600] text-[1.5rem]">{{ __('Similar articles') }}</div>
		<div class="grid grid-cols-3 gap-[1.5rem] mt-[1.5rem]">
			@foreach($related_posts as $related_post)
			<div class="rounded-[.5rem] overflow-hidden text-[1rem]">
					<div class="relative">
						<img src="{{ src("storage/posts/{$related_post->cover}") }}" class="rounded-[.5rem]">
						<a href="{{ route('home.blog.category', ['category' => $related_post->category_name]) }}" class="absolute left-[.75rem] top-[.75rem] text-[.8rem] p-[.5rem_.75rem] leading-[1] text-[#fff] block bg-[#ffffff5c] backdrop-blur-[5px] rounded-[.5rem] hover:bg-[#fff] hover:text-[#000] transition-all">
							{{ $related_post->category_name }}
						</a>
					</div>
					<div class="mt-[1.25rem] px-[1rem]">
						<div class="mb-[1.25rem] text-[.9rem] flex items-end gap-x-[.5rem]">
							<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"><path fill="currentColor" d="M17 14a1 1 0 1 0 0-2a1 1 0 0 0 0 2m0 4a1 1 0 1 0 0-2a1 1 0 0 0 0 2m-4-5a1 1 0 1 1-2 0a1 1 0 0 1 2 0m0 4a1 1 0 1 1-2 0a1 1 0 0 1 2 0m-6-3a1 1 0 1 0 0-2a1 1 0 0 0 0 2m0 4a1 1 0 1 0 0-2a1 1 0 0 0 0 2"/><path fill="currentColor" fill-rule="evenodd" d="M7 1.75a.75.75 0 0 1 .75.75v.763c.662-.013 1.391-.013 2.193-.013h4.113c.803 0 1.532 0 2.194.013V2.5a.75.75 0 0 1 1.5 0v.827c.26.02.506.045.739.076c1.172.158 2.121.49 2.87 1.238c.748.749 1.08 1.698 1.238 2.87c.153 1.14.153 2.595.153 4.433v2.112c0 1.838 0 3.294-.153 4.433c-.158 1.172-.49 2.121-1.238 2.87c-.749.748-1.698 1.08-2.87 1.238c-1.14.153-2.595.153-4.433.153H9.945c-1.838 0-3.294 0-4.433-.153c-1.172-.158-2.121-.49-2.87-1.238c-.748-.749-1.08-1.698-1.238-2.87c-.153-1.14-.153-2.595-.153-4.433v-2.112c0-1.838 0-3.294.153-4.433c.158-1.172.49-2.121 1.238-2.87c.749-.748 1.698-1.08 2.87-1.238c.233-.031.48-.056.739-.076V2.5A.75.75 0 0 1 7 1.75M5.71 4.89c-1.005.135-1.585.389-2.008.812c-.423.423-.677 1.003-.812 2.009c-.023.17-.042.35-.058.539h18.336c-.016-.19-.035-.369-.058-.54c-.135-1.005-.389-1.585-.812-2.008c-.423-.423-1.003-.677-2.009-.812c-1.027-.138-2.382-.14-4.289-.14h-4c-1.907 0-3.261.002-4.29.14M2.75 12c0-.854 0-1.597.013-2.25h18.474c.013.653.013 1.396.013 2.25v2c0 1.907-.002 3.262-.14 4.29c-.135 1.005-.389 1.585-.812 2.008c-.423.423-1.003.677-2.009.812c-1.027.138-2.382.14-4.289.14h-4c-1.907 0-3.261-.002-4.29-.14c-1.005-.135-1.585-.389-2.008-.812c-.423-.423-.677-1.003-.812-2.009c-.138-1.027-.14-2.382-.14-4.289z" clip-rule="evenodd"/></svg>
							<span class="leading-[1]">{{ $related_post->created_at->format('Y-m-d') }}</span>
						</div>
						<div class="flex gap-[.5rem] mb-[1.25rem]">
							@foreach($related_post->tags ?? [] as $tag)
							<a href="{{ route('home.blog.tag', ['tag' => $tag]) }}" class="text-[.8rem] bg-[#ffe0b2] text-[#59401c] font-[600] rounded-[.5rem] p-[.25rem_.5rem] whitespace-nowrap text-ellipsis overflow-hidden">
								{{ $tag }}
							</a>
							@endforeach
						</div>
						<a href="{{ route('home.post', ['slug' => $related_post->slug]) }}" class="block h-[50px] overflow-hidden font-[600] opacity-75">{{ limit($related_post->name, 100) }}</a>
						<div class="mt-[1rem] flex items-end">
							<div class="flex items-center gap-[.5rem] relative bottom-[-5px] opacity-75">
								<svg xmlns="http://www.w3.org/2000/svg" class="relative bottom-[1px]" width="25px" height="25px" viewBox="0 0 256 256"><path fill="currentColor" d="M245.48 125.57c-.34-.78-8.66-19.23-27.24-37.81C201 70.54 171.38 50 128 50S55 70.54 37.76 87.76c-18.58 18.58-26.9 37-27.24 37.81a6 6 0 0 0 0 4.88c.34.77 8.66 19.22 27.24 37.8C55 185.47 84.62 206 128 206s73-20.53 90.24-37.75c18.58-18.58 26.9-37 27.24-37.8a6 6 0 0 0 0-4.88M128 194c-31.38 0-58.78-11.42-81.45-33.93A134.8 134.8 0 0 1 22.69 128a134.6 134.6 0 0 1 23.86-32.06C69.22 73.42 96.62 62 128 62s58.78 11.42 81.45 33.94A134.6 134.6 0 0 1 233.31 128C226.94 140.21 195 194 128 194m0-112a46 46 0 1 0 46 46a46.06 46.06 0 0 0-46-46m0 80a34 34 0 1 1 34-34a34 34 0 0 1-34 34"/></svg>
								<span class="leading-[1] text-[.9rem]">{{ $related_post->views }}</span>
							</div>
							<a href="{{ route('home.post', ['slug' => $related_post->slug]) }}" class="table ml-auto leading-[1] p-[.65rem_1rem] bg-[#504661] text-[#fff] rounded-[.5rem]">{{ __('Read more') }}</a>
						</div>
					</div>
				</div>
			@endforeach
		</div>
	</div>
</div>
@endsection