@extends('front.tendra.master')

@section('body')
<div class="py-[.75rem] px-[1.5rem] flex items-center bg-[#493b69] text-[#fff]">
	<div class="max-w-[1200px] w-full mx-auto">
		<div class="flex font-[500] items-center gap-x-[.5rem] text-[1rem]">
			<a href="" class="h-[30px] flex items-center gap-x-[.5rem] p-[.5rem_.65rem] pb-[.35rem] bg-[#fff] rounded-[.25rem] text-[#6d52ab] justify-center">
				<span class=""><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 16 16"><path fill="currentColor" d="M6.906.384a1.75 1.75 0 0 1 2.187 0l5.25 4.2c.415.332.657.835.657 1.367v7.019a1.75 1.75 0 0 1-1.75 1.75h-2.5a.75.75 0 0 1-.75-.75V8.72H6v5.25a.75.75 0 0 1-.75.75h-2.5A1.75 1.75 0 0 1 1 12.97V5.95c0-.531.242-1.034.657-1.366z"></path></svg></span>
				<span class="h-auto relative bottom-[-2px]">{{ __('Home') }}</span>
			</a>
			<span class="h-[30px] flex items-center">|</span>
			<div href="" class="h-[30px] p-[.5rem_.65rem] pb-[.35rem] bg-[#64538b] text-[#fff] flex items-center justify-center rounded-[.25rem]">{{ __('Pricing table') }}</div>
		</div>
	</div>
</div>

<div class="pt-[3rem] px-[1.5rem]">
	<div class="max-w-[1200px] w-full mx-auto">
		<div class="text-center">
			<div class="text-[2.2rem] max-[768px]:text-[1.8rem] font-[600] capitalize mb-[1.5rem]">{{ __('Discover our membership plans') }}</div>
			<div class="mt-[.5rem] text-[1.2rem] opacity-75 max-w-[800px] mx-auto leading-[1.8]">
				{{ __("Upgrade your journey with our tailored membership plans! Whether Basic, Plus, or Premium, there's something for everyone. Subscribe now and enjoy exclusive perks!") }}
			</div>
		</div>
		<div class="grid grid-cols-3 max-[1024px]:grid-cols-2 max-[650px]:grid-cols-1 gap-[2rem] max-w-[1100px] mx-auto mt-[3rem]">
			@foreach($subscriptions as $subscription)
			<div class="relative rounded-[.5rem] p-[1.5rem] bg-[#fff] shadow-[0_0_20px_10px_#00000005] [&.popular] {{ $subscription->popular === '1' ? 'popular' : '' }}">
				<div class="">
					<div class="font-[600] mb-[.75rem] uppercase text-[1rem]">{{ $subscription->name }}</div>
					<div class="text-[1rem] opacity-75 h-[48px] overflow-hidden">{{ $subscription->subheading }}</div>
				</div>
				<div class="mt-[1.5rem]">
					<div class="flex items-end leading-[1]">
						<span class="text-[1.8rem] font-[600] select-none">{{ price($subscription->price) }} / </span>
						<span class="text-[1rem]">{{ __($subscription->title) }}</span>
					</div>
				</div>
				<div class="mt-[1.5rem] pt-[1.5rem] border-t-[1px]">
					<a href="{{ route('home.checkout', ['id' => $subscription->id, 'type' => 'subscription']) }}" class="capitalize text-[1rem] bg-[#163020] text-[#adffcc] font-[600] rounded-[.5rem] p-[.75rem_1rem] block text-center">{{ __("Get started") }}</a>
				</div>
				<div class="mt-[1.5rem] pt-[1.5rem] border-t-[1px]">
					<div class="text-[.9rem] uppercase mb-[1rem]">{{ __('Included features') }}</div>
					<div class="[&>div:not(:last-child)]:mb-[.75rem]">						
						@if(strip_tags($subscription->description))
						{!! $subscription->description !!}
						@elseif($subscription->specifications)
							@foreach($subscription->specifications ?? [] as $specification)
							<div class="flex items-center gap-[.75rem] text-[1rem]">
								<div class="w-[30px] h-[30px] p-[.5rem] rounded-[.35rem] border-[1px] border-[#9CFF2E] [&.active]:opacity-100 [&.active]:bg-[#9CFF2E] [&:not(.active)>img]:opacity-25 {{ $specification->included ? 'active' : '' }}">
									<img src="/assets/images/checkbox-2.webp" class="w-full">
								</div>
								<div class="opacity-75 h-[24px] overflow-hidden">{{ $specification->text }}</div>
							</div>
							@endforeach
						@endif
					</div>
				</div>
			</div>
			@endforeach
		</div>
	</div>
</div>
@endsection