@extends('front.tendra.master')

@section('body')
<div class="py-[1.5rem] relative bg-[#473073] text-[#fff] py-[3rem] flex items-center">
	<div class="max-w-[1200px] text-center mx-auto">
		<div class="text-[3rem] font-[600] first-letter:text-[#ff7c64]">{{ __('FAQ & Support') }}</div>
		<div class="text-[1.5rem] mt-[.5rem] relative text-[#fff] max-w-[700px] font-[400]">{{ __("Dedicated Support for Your Digital Marketplace: Always Here to Help with Quick Solutions, Expert Guidance, and 24/7 Assistance to Ensure Your Success") }}</div>
	</div>
</div>

<div class="mt-[3rem]">
	<div class="max-w-[800px] mx-auto px-[2rem]">
		{{-- FAQ --}}
		@if($faqs->count())
		<div class="">
			<div class="uppercase cursor-pointer text-[.9rem] font-[600] bg-[#fff] flex items-center justify-between gap-[1rem] rounded-[.25rem] p-[1.5rem]" id="faq-toggler">
				{{ __('Frequently asked questions') }}
				<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m19 9l-7 7l-7-7"/></svg>
			</div>
			<div class="mt-[2rem] hidden">
				@foreach($faqs as $faq)
				<div class="{{ !$loop->last ? 'mb-[2rem]' : '' }}">
					<div class="mb-[1rem] font-[600]">{{ $faq->question }}</div>
					<div class="opacity-[.8]">{!! $faq->answer !!}</div>
				</div>
				@endforeach
			</div>
		</div>

		<div class="my-[2rem] border-t-[1px]"></div>
		@endif

		{{-- PAGE DESCRIPTION --}}
		@if($support && strlen(strip_tags($support->content ?? '')))
		<div class="">
			{!! $support->content !!}
		</div>

		<div class="my-[2rem] border-t-[1px]"></div>
		@endif

		<form action="{{ route('home.support') }}" method="POST" class="p-[1.5rem] bg-[#fff] rounded-[.5rem]" id="contact-form">
			@if(session('support_response'))
			<div class="mb-[2rem] bg-[#009f8d] rounded-[.25rem] text-[#fff] p-[1rem]">{{ session('support_response') }}</div>
			@endif

			@csrf
			<div class="mb-[2rem] pb-[2rem] border-b-[1px]">
				<div class="font-[600] text-[1.5rem] mb-[.5rem]">{{ __("Need any assistance ?") }}</div>
				<div class="">{{ __("Reach out and we'll get in touch within 24 hours") }}</div>
			</div>
			<div class="mb-[1rem]">
				<label class="mb-[.5rem] font-semibold block">{{ __('Email address') }}</label>
				<input type="email" name="email" class="focus:outline-none rounded-[.5rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d]" placeholder="..." required="">
			</div>
			<div class="mb-[1rem]">
				<label class="mb-[.5rem] font-semibold block">{{ __('Subject') }}</label>
				<input type="text" name="subject" class="focus:outline-none rounded-[.5rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d]" placeholder="..." required="">
			</div>
			<div class="mb-[1rem]">
				<label class="mb-[.5rem] font-semibold block">{{ __('Message') }}</label>
				<textarea name="message" class="focus:outline-none rounded-[.5rem] w-full p-[.5rem_1rem] border-[1px] text-[#3d3d3d] h-[200px] resize-none" placeholder="{{ __('Enter your message') }}" required=""></textarea>
			</div>
			<button class="text-[1.2rem] px-[1rem] py-[.75rem] font-[500] text-[#fff] border-[1px] flex items-center border-[#6f44f5] rounded-[.35rem] h-[45px] bg-[#6f44f5] hover:bg-[#5D54B6]">{{ __('Submit') }}</button>
		</form>
	</div>
</div>
@endsection