@extends('front.tendra.user.master')

@section('user_page')
<div class="font-[600] uppercase text-[1rem] mb-[1rem]">{{ __('Coupons') }}</div>

<div class="p-[1.5rem] bg-[#fff] rounded-[.5rem]" data-tab="coupons">
	<div class="overflow-auto">
		<table class="table w-full text-center text-[1rem] overflow-x-auto border-separate border-spacing-[.75rem]">
			<thead class="bg-[#555270] text-[#fff]">
				<tr class="[&>th]:p-[.75rem_1rem] [&>th]:font-[500] [&>th]:rounded-[.35rem]">
					<th class="">{{ __('Coupon code') }}</th>
					<th class="">{{ __('Value') }}</th>
					<th class="">{{ __('Expires at') }}</th>
					<th class="">{{ __('Status') }}</th>
				</tr>
			</thead>
			<tbody class="">
				@foreach($coupons as $coupon)
				<tr class="[&>td]:p-[.5rem_1rem] font-[400] [&>td:not(:last-child)]:bg-[whitesmoke] [&>td]:rounded-[.35rem]">
					<td class="uppercase text-[.9rem]">
						<div class="flex items-end justify-between">
							<span class="leading-[1]">{{ $coupon->code }}</span>
							<svg xmlns="http://www.w3.org/2000/svg" class="copy-coupon ml-[.5rem] cursor-pointer" width="20" height="20" viewBox="0 0 24 24"><path fill="currentColor" d="M6 5h2.5a3 3 0 0 1 3-3a3 3 0 0 1 3 3H17a3 3 0 0 1 3 3v11a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V8a3 3 0 0 1 3-3m0 1a2 2 0 0 0-2 2v11a2 2 0 0 0 2 2h11a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2h-1v3H7V6zm2 2h7V6H8zm3.5-5a2 2 0 0 0-2 2h4a2 2 0 0 0-2-2M6 11h11v1H6zm0 3h11v1H6zm0 3h9v1H6z"/></svg>
						</div>
					</td>
					<td class="text-[.9rem]">{{ $coupon->is_percentage ? ('%'.$coupon->value) : price($coupon->value, false) }}</td>
					<td class="text-[.9rem]">{{ format_date($coupon->expires_at, 'Y-m-d H:i') }}</td>
					@php 
					$coupon_status = $coupon->expired ? 'expired' : 'active';
					@endphp
					<td class="{{ $coupon_status }} [&.active]:bg-[rgb(5_224_127/15%)] [&.expired]:bg-[rgb(255_117_92/4%)]">
						<div class="p-[.25rem] text-[.9rem] font-[600] rounded-[.35rem] [&.active]:text-[#096d63] [&.expired]:text-[#ff755c] capitalize {{ $coupon_status }}">{{ $coupon_status }}</div>
					</td>
				</tr>
				@endforeach
			</tbody>
		</table>
	</div>

	@if($coupons->hasPages())
	<div class="mt-[1.5rem]">
		{{ $coupons->links('vendor.pagination.tailwind') }}
	</div>
	@endif
</div>
@endsection