@extends('front.tendra.user.master')

@section('user_page')
<div class="font-[600] uppercase text-[1rem] mb-[1rem]">{{ __('Invoices') }}</div>

<div class="p-[1.5rem] bg-[#fff] rounded-[.5rem]" data-tab="invoices">
	<div class="overflow-auto">
		<table class="table w-full text-[1rem]">
			<thead class="bg-[#00dbe1] text-[#fff]">
				<tr class="[&>th]:p-[1rem] [&>th]:text-center [&>th:not(:last-child)]:border-r-[1px] [&>th]:font-[600]">
					<th class="rounded-tl-[.5rem]">{{ __('Reference ID') }}</th>
					<th>{{ __('Amount') }}</th>
					<th>{{ __('Date') }}</th>
					<th class="rounded-tr-[.5rem]">{{ __('Export') }}</th>
				</tr>
			</thead>
			<tbody class="[&>tr:not(:last-child)]:border-b-[1px]">
				@foreach($invoices ?? [] as $invoice)
				<tr class="[&>td]:p-[.75rem_1rem] [&>td]:text-center [&>td:not(:last-child)]:border-r-[1px]">
					<td>{{ $invoice->reference_id }}</td>
					<td>{{ $invoice->currency .' '. $invoice->amount }}</td>
					<td class="">{{ $invoice->created_at->format('Y-m-d H:i') }}</td>
					<td class="p-[.5rem]">
						@if(config('app.invoice.template', 1) == 1)
						<button class="uppercase text-[.8rem] bg-[whitesmoke] font-[500] rounded-[.35rem] p-[.5rem_.75rem] pb-[.35rem] flex gap-[.25rem] mx-auto" @click="downloadItem({{ $invoice->id }}, '#download-invoice')">
							{{ __('Download') }}
						</button>
						@else
						<button class="uppercase text-[.8rem] bg-[whitesmoke] font-[500] rounded-[.35rem] p-[.5rem_.75rem] pb-[.35rem] flex gap-[.25rem] mx-auto" @click="downloadInvoice({{ $invoice->id }}, '#download-invoice')">
							{{ __('Download') }}
						</button>
						@endif
					</td>
				</tr>
				@endforeach
			</tbody>
		</table>
	</div>

	<form action="{{ route('home.export_invoice') }}" class="d-none" method="post" id="download-invoice">
		@csrf
		<input type="hidden" name="itemId" v-model="itemId">
	</form>

	@if($invoices->hasPages())
	<div class="mt-[1.5rem]">
		{{ $invoices->links('vendor.pagination.tailwind') }}
	</div>
	@endif
</div>
@endsection