@extends('front.tendra.user.master')

@section('user_page')
<div class="font-[600] uppercase text-[1rem] mb-[1rem]">{{ __('Prepaid credits') }}</div>

<div class="p-[1.5rem] bg-[#fff] rounded-[.5rem]" data-tab="prepaid-credits">
	<div class="overflow-auto">
		<table class="table w-full text-[1rem]">
			<thead class="bg-[#ff6d54] text-[#fff]">
				<tr class="[&>th]:p-[1rem] [&>th]:text-center [&>th:not(:last-child)]:border-r-[1px] [&>th]:font-[600]">
					<th class="rounded-tl-[.5rem]">{{ __('Amount') }}</th>
					<th>{{ __('Credits') }}</th>
					<th>{{ __('Expires at') }}</th>
					<th>{{ __('Discount') }}</th>
					<th class="rounded-tr-[.5rem]">{{ __('Status') }}</th>
				</tr>
			</thead>
			<tbody class="[&>tr:not(:last-child)]:border-b-[1px]">
				@foreach($user_prepaid_credits as $user_prepaid_credit)
				<tr class="[&>td]:p-[.75rem_1rem] [&>td]:text-center [&>td:not(:last-child)]:border-r-[1px]">
					<td>{{ price($user_prepaid_credit->amount) }}</td>
					<td>{{ price($user_prepaid_credit->credits) }}</td>
					<td>{{ $user_prepaid_credit->expires_at ?? '-' }}</td>
					<td class="">{{ $user_prepaid_credit->discount ?? '0' }}%</td>
					<td class="">
						<div class="{{ $user_prepaid_credit->status }} [&.active]:bg-[rgb(5_224_127/15%)] [&.expired]:bg-[rgb(255_117_92/4%)] p-[.25rem] text-[.9rem] font-[600] rounded-[.35rem] [&.active]:text-[#096d63] [&.expired]:text-[#ff755c] [&.pending]:text-[#ffbd44] [&.pending]:bg-[#ffbd4430] capitalize">{{ __(mb_ucfirst($user_prepaid_credit->status)) }}</div>
					</td>
				</tr>
				@endforeach
			</tbody>
		</table>
	</div>

	@if($user_prepaid_credits->hasPages())
	<div class="mt-[1.5rem]">
		{{ $user_prepaid_credits->links('vendor.pagination.tailwind') }}
	</div>
	@endif
</div>
@endsection