@extends('front.tendra.user.master')

@section('user_page')
<div class="font-[600] uppercase text-[1rem] mb-[1rem]">{{ __('Subscriptions') }}</div>

<div class="p-[1.5rem] bg-[#fff] rounded-[.5rem]" data-tab="subscriptions">
	<div class="overflow-auto">
		<table class="table w-full text-[1rem]">
			<thead class="bg-[#00dbe1] text-[#fff]">
				<tr class="[&>th]:p-[1rem] [&>th]:text-center [&>th:not(:last-child)]:border-r-[1px] [&>th]:font-[600]">
					<th class="rounded-tl-[.5rem]">{{ __('Subscription') }}</th>
					<th>{{ __('Starts at') }}</th>
					<th>{{ __('Expires at') }}</th>
					<th>{{ __('Remaining days') }}</th>
					<th>{{ __('Downloads') }}</th>
					<th>{{ __('Daily downloads') }}</th>
					<th class="rounded-tr-[.5rem]">{{ __('Status') }}</th>
				</tr>
			</thead>
			<tbody class="[&>tr:not(:last-child)]:border-b-[1px]">
				@foreach($user_subscriptions as $user_subscription)
				<tr class="[&>td]:p-[.75rem_1rem] [&>td]:text-center [&>td:not(:last-child)]:border-r-[1px]">
					<td>{{ $user_subscription->name }}</td>
					<td class="text-[.9rem]">{{ format_date($user_subscription->starts_at, 'Y-m-d H:i') }}</td>
					<td class="text-[.9rem]">{{ format_date($user_subscription->ends_at, 'Y-m-d H:i') }}</td>
					<td class="text-[.9rem]">
						@if($user_subscription->ends_at)
						{{ $user_subscription->remaining_days }}
						@else
						{{ __('Unlimited') }}
						@endif
					</td>
					<td class="text-[.9rem]">
						@if($user_subscription->limit_downloads > 0)
						{{ "{$user_subscription->downloads}/{$user_subscription->limit_downloads}" }}
						@else
						{{ __('Unlimited') }}
						@endif
					</td>
					<td class="text-[.9rem]">
						@if($user_subscription->limit_downloads_per_day > 0)
						{{ "{$user_subscription->daily_downloads}/{$user_subscription->limit_downloads_per_day}" }}
						@else
						{{ __('Unlimited') }}
						@endif
					</td>
					@php 
					$subscription_status = !$user_subscription->payment_status ? 'pending' : ($user_subscription->expired ? 'expired' : 'active');
					@endphp
					<td class="">
						<div class="p-[.5rem_.75rem] {{ $subscription_status }} font-[600] rounded-[.35rem] [&.active]:text-[#096d63] [&.active]:bg-[#f7fcfc] [&.expired]:text-[#ff755c] [&.expired]:bg-[#fffaf9] bg-[whitesmoke] capitalize">{{ $subscription_status }}</div>
					</td>
				</tr>
				@endforeach
			</tbody>
		</table>
	</div>

	@if($user_subscriptions->hasPages())
	<div class="mt-[1.5rem]">
		{{ $user_subscriptions->links('vendor.pagination.tailwind') }}
	</div>
	@endif
</div>
@endsection