<?php

/**
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Adyen\Model\Checkout;

use \ArrayAccess;
use Adyen\Model\Checkout\ObjectSerializer;

/**
 * DonationPaymentRequest Class Doc Comment
 *
 * @category Class
 * @package  Adyen
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class DonationPaymentRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'DonationPaymentRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'accountInfo' => '\Adyen\Model\Checkout\AccountInfo',
        'additionalData' => 'array<string,string>',
        'amount' => '\Adyen\Model\Checkout\Amount',
        'applicationInfo' => '\Adyen\Model\Checkout\ApplicationInfo',
        'authenticationData' => '\Adyen\Model\Checkout\AuthenticationData',
        'billingAddress' => '\Adyen\Model\Checkout\BillingAddress',
        'browserInfo' => '\Adyen\Model\Checkout\BrowserInfo',
        'channel' => 'string',
        'checkoutAttemptId' => 'string',
        'conversionId' => 'string',
        'countryCode' => 'string',
        'dateOfBirth' => '\DateTime',
        'deliverAt' => '\DateTime',
        'deliveryAddress' => '\Adyen\Model\Checkout\DeliveryAddress',
        'deviceFingerprint' => 'string',
        'donationAccount' => 'string',
        'donationCampaignId' => 'string',
        'donationOriginalPspReference' => 'string',
        'donationToken' => 'string',
        'lineItems' => '\Adyen\Model\Checkout\LineItem[]',
        'merchantAccount' => 'string',
        'merchantRiskIndicator' => '\Adyen\Model\Checkout\MerchantRiskIndicator',
        'metadata' => 'array<string,string>',
        'mpiData' => '\Adyen\Model\Checkout\ThreeDSecureData',
        'origin' => 'string',
        'paymentMethod' => '\Adyen\Model\Checkout\DonationPaymentMethod',
        'recurringProcessingModel' => 'string',
        'redirectFromIssuerMethod' => 'string',
        'redirectToIssuerMethod' => 'string',
        'reference' => 'string',
        'returnUrl' => 'string',
        'sessionValidity' => 'string',
        'shopperEmail' => 'string',
        'shopperIP' => 'string',
        'shopperInteraction' => 'string',
        'shopperLocale' => 'string',
        'shopperName' => '\Adyen\Model\Checkout\Name',
        'shopperReference' => 'string',
        'socialSecurityNumber' => 'string',
        'telephoneNumber' => 'string',
        'threeDS2RequestData' => '\Adyen\Model\Checkout\ThreeDS2RequestFields',
        'threeDSAuthenticationOnly' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'accountInfo' => null,
        'additionalData' => null,
        'amount' => null,
        'applicationInfo' => null,
        'authenticationData' => null,
        'billingAddress' => null,
        'browserInfo' => null,
        'channel' => null,
        'checkoutAttemptId' => null,
        'conversionId' => null,
        'countryCode' => null,
        'dateOfBirth' => 'date-time',
        'deliverAt' => 'date-time',
        'deliveryAddress' => null,
        'deviceFingerprint' => null,
        'donationAccount' => null,
        'donationCampaignId' => null,
        'donationOriginalPspReference' => null,
        'donationToken' => null,
        'lineItems' => null,
        'merchantAccount' => null,
        'merchantRiskIndicator' => null,
        'metadata' => null,
        'mpiData' => null,
        'origin' => null,
        'paymentMethod' => null,
        'recurringProcessingModel' => null,
        'redirectFromIssuerMethod' => null,
        'redirectToIssuerMethod' => null,
        'reference' => null,
        'returnUrl' => null,
        'sessionValidity' => null,
        'shopperEmail' => null,
        'shopperIP' => null,
        'shopperInteraction' => null,
        'shopperLocale' => null,
        'shopperName' => null,
        'shopperReference' => null,
        'socialSecurityNumber' => null,
        'telephoneNumber' => null,
        'threeDS2RequestData' => null,
        'threeDSAuthenticationOnly' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'accountInfo' => false,
        'additionalData' => false,
        'amount' => false,
        'applicationInfo' => false,
        'authenticationData' => false,
        'billingAddress' => false,
        'browserInfo' => false,
        'channel' => false,
        'checkoutAttemptId' => false,
        'conversionId' => false,
        'countryCode' => false,
        'dateOfBirth' => false,
        'deliverAt' => false,
        'deliveryAddress' => false,
        'deviceFingerprint' => false,
        'donationAccount' => false,
        'donationCampaignId' => false,
        'donationOriginalPspReference' => false,
        'donationToken' => false,
        'lineItems' => false,
        'merchantAccount' => false,
        'merchantRiskIndicator' => false,
        'metadata' => false,
        'mpiData' => false,
        'origin' => false,
        'paymentMethod' => false,
        'recurringProcessingModel' => false,
        'redirectFromIssuerMethod' => false,
        'redirectToIssuerMethod' => false,
        'reference' => false,
        'returnUrl' => false,
        'sessionValidity' => false,
        'shopperEmail' => false,
        'shopperIP' => false,
        'shopperInteraction' => false,
        'shopperLocale' => false,
        'shopperName' => false,
        'shopperReference' => false,
        'socialSecurityNumber' => false,
        'telephoneNumber' => false,
        'threeDS2RequestData' => false,
        'threeDSAuthenticationOnly' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'accountInfo' => 'accountInfo',
        'additionalData' => 'additionalData',
        'amount' => 'amount',
        'applicationInfo' => 'applicationInfo',
        'authenticationData' => 'authenticationData',
        'billingAddress' => 'billingAddress',
        'browserInfo' => 'browserInfo',
        'channel' => 'channel',
        'checkoutAttemptId' => 'checkoutAttemptId',
        'conversionId' => 'conversionId',
        'countryCode' => 'countryCode',
        'dateOfBirth' => 'dateOfBirth',
        'deliverAt' => 'deliverAt',
        'deliveryAddress' => 'deliveryAddress',
        'deviceFingerprint' => 'deviceFingerprint',
        'donationAccount' => 'donationAccount',
        'donationCampaignId' => 'donationCampaignId',
        'donationOriginalPspReference' => 'donationOriginalPspReference',
        'donationToken' => 'donationToken',
        'lineItems' => 'lineItems',
        'merchantAccount' => 'merchantAccount',
        'merchantRiskIndicator' => 'merchantRiskIndicator',
        'metadata' => 'metadata',
        'mpiData' => 'mpiData',
        'origin' => 'origin',
        'paymentMethod' => 'paymentMethod',
        'recurringProcessingModel' => 'recurringProcessingModel',
        'redirectFromIssuerMethod' => 'redirectFromIssuerMethod',
        'redirectToIssuerMethod' => 'redirectToIssuerMethod',
        'reference' => 'reference',
        'returnUrl' => 'returnUrl',
        'sessionValidity' => 'sessionValidity',
        'shopperEmail' => 'shopperEmail',
        'shopperIP' => 'shopperIP',
        'shopperInteraction' => 'shopperInteraction',
        'shopperLocale' => 'shopperLocale',
        'shopperName' => 'shopperName',
        'shopperReference' => 'shopperReference',
        'socialSecurityNumber' => 'socialSecurityNumber',
        'telephoneNumber' => 'telephoneNumber',
        'threeDS2RequestData' => 'threeDS2RequestData',
        'threeDSAuthenticationOnly' => 'threeDSAuthenticationOnly'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'accountInfo' => 'setAccountInfo',
        'additionalData' => 'setAdditionalData',
        'amount' => 'setAmount',
        'applicationInfo' => 'setApplicationInfo',
        'authenticationData' => 'setAuthenticationData',
        'billingAddress' => 'setBillingAddress',
        'browserInfo' => 'setBrowserInfo',
        'channel' => 'setChannel',
        'checkoutAttemptId' => 'setCheckoutAttemptId',
        'conversionId' => 'setConversionId',
        'countryCode' => 'setCountryCode',
        'dateOfBirth' => 'setDateOfBirth',
        'deliverAt' => 'setDeliverAt',
        'deliveryAddress' => 'setDeliveryAddress',
        'deviceFingerprint' => 'setDeviceFingerprint',
        'donationAccount' => 'setDonationAccount',
        'donationCampaignId' => 'setDonationCampaignId',
        'donationOriginalPspReference' => 'setDonationOriginalPspReference',
        'donationToken' => 'setDonationToken',
        'lineItems' => 'setLineItems',
        'merchantAccount' => 'setMerchantAccount',
        'merchantRiskIndicator' => 'setMerchantRiskIndicator',
        'metadata' => 'setMetadata',
        'mpiData' => 'setMpiData',
        'origin' => 'setOrigin',
        'paymentMethod' => 'setPaymentMethod',
        'recurringProcessingModel' => 'setRecurringProcessingModel',
        'redirectFromIssuerMethod' => 'setRedirectFromIssuerMethod',
        'redirectToIssuerMethod' => 'setRedirectToIssuerMethod',
        'reference' => 'setReference',
        'returnUrl' => 'setReturnUrl',
        'sessionValidity' => 'setSessionValidity',
        'shopperEmail' => 'setShopperEmail',
        'shopperIP' => 'setShopperIP',
        'shopperInteraction' => 'setShopperInteraction',
        'shopperLocale' => 'setShopperLocale',
        'shopperName' => 'setShopperName',
        'shopperReference' => 'setShopperReference',
        'socialSecurityNumber' => 'setSocialSecurityNumber',
        'telephoneNumber' => 'setTelephoneNumber',
        'threeDS2RequestData' => 'setThreeDS2RequestData',
        'threeDSAuthenticationOnly' => 'setThreeDSAuthenticationOnly'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'accountInfo' => 'getAccountInfo',
        'additionalData' => 'getAdditionalData',
        'amount' => 'getAmount',
        'applicationInfo' => 'getApplicationInfo',
        'authenticationData' => 'getAuthenticationData',
        'billingAddress' => 'getBillingAddress',
        'browserInfo' => 'getBrowserInfo',
        'channel' => 'getChannel',
        'checkoutAttemptId' => 'getCheckoutAttemptId',
        'conversionId' => 'getConversionId',
        'countryCode' => 'getCountryCode',
        'dateOfBirth' => 'getDateOfBirth',
        'deliverAt' => 'getDeliverAt',
        'deliveryAddress' => 'getDeliveryAddress',
        'deviceFingerprint' => 'getDeviceFingerprint',
        'donationAccount' => 'getDonationAccount',
        'donationCampaignId' => 'getDonationCampaignId',
        'donationOriginalPspReference' => 'getDonationOriginalPspReference',
        'donationToken' => 'getDonationToken',
        'lineItems' => 'getLineItems',
        'merchantAccount' => 'getMerchantAccount',
        'merchantRiskIndicator' => 'getMerchantRiskIndicator',
        'metadata' => 'getMetadata',
        'mpiData' => 'getMpiData',
        'origin' => 'getOrigin',
        'paymentMethod' => 'getPaymentMethod',
        'recurringProcessingModel' => 'getRecurringProcessingModel',
        'redirectFromIssuerMethod' => 'getRedirectFromIssuerMethod',
        'redirectToIssuerMethod' => 'getRedirectToIssuerMethod',
        'reference' => 'getReference',
        'returnUrl' => 'getReturnUrl',
        'sessionValidity' => 'getSessionValidity',
        'shopperEmail' => 'getShopperEmail',
        'shopperIP' => 'getShopperIP',
        'shopperInteraction' => 'getShopperInteraction',
        'shopperLocale' => 'getShopperLocale',
        'shopperName' => 'getShopperName',
        'shopperReference' => 'getShopperReference',
        'socialSecurityNumber' => 'getSocialSecurityNumber',
        'telephoneNumber' => 'getTelephoneNumber',
        'threeDS2RequestData' => 'getThreeDS2RequestData',
        'threeDSAuthenticationOnly' => 'getThreeDSAuthenticationOnly'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const CHANNEL_I_OS = 'iOS';
    public const CHANNEL_ANDROID = 'Android';
    public const CHANNEL_WEB = 'Web';
    public const RECURRING_PROCESSING_MODEL_CARD_ON_FILE = 'CardOnFile';
    public const RECURRING_PROCESSING_MODEL_SUBSCRIPTION = 'Subscription';
    public const RECURRING_PROCESSING_MODEL_UNSCHEDULED_CARD_ON_FILE = 'UnscheduledCardOnFile';
    public const SHOPPER_INTERACTION_ECOMMERCE = 'Ecommerce';
    public const SHOPPER_INTERACTION_CONT_AUTH = 'ContAuth';
    public const SHOPPER_INTERACTION_MOTO = 'Moto';
    public const SHOPPER_INTERACTION_POS = 'POS';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getChannelAllowableValues()
    {
        return [
            self::CHANNEL_I_OS,
            self::CHANNEL_ANDROID,
            self::CHANNEL_WEB,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getRecurringProcessingModelAllowableValues()
    {
        return [
            self::RECURRING_PROCESSING_MODEL_CARD_ON_FILE,
            self::RECURRING_PROCESSING_MODEL_SUBSCRIPTION,
            self::RECURRING_PROCESSING_MODEL_UNSCHEDULED_CARD_ON_FILE,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getShopperInteractionAllowableValues()
    {
        return [
            self::SHOPPER_INTERACTION_ECOMMERCE,
            self::SHOPPER_INTERACTION_CONT_AUTH,
            self::SHOPPER_INTERACTION_MOTO,
            self::SHOPPER_INTERACTION_POS,
        ];
    }
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('accountInfo', $data ?? [], null);
        $this->setIfExists('additionalData', $data ?? [], null);
        $this->setIfExists('amount', $data ?? [], null);
        $this->setIfExists('applicationInfo', $data ?? [], null);
        $this->setIfExists('authenticationData', $data ?? [], null);
        $this->setIfExists('billingAddress', $data ?? [], null);
        $this->setIfExists('browserInfo', $data ?? [], null);
        $this->setIfExists('channel', $data ?? [], null);
        $this->setIfExists('checkoutAttemptId', $data ?? [], null);
        $this->setIfExists('conversionId', $data ?? [], null);
        $this->setIfExists('countryCode', $data ?? [], null);
        $this->setIfExists('dateOfBirth', $data ?? [], null);
        $this->setIfExists('deliverAt', $data ?? [], null);
        $this->setIfExists('deliveryAddress', $data ?? [], null);
        $this->setIfExists('deviceFingerprint', $data ?? [], null);
        $this->setIfExists('donationAccount', $data ?? [], null);
        $this->setIfExists('donationCampaignId', $data ?? [], null);
        $this->setIfExists('donationOriginalPspReference', $data ?? [], null);
        $this->setIfExists('donationToken', $data ?? [], null);
        $this->setIfExists('lineItems', $data ?? [], null);
        $this->setIfExists('merchantAccount', $data ?? [], null);
        $this->setIfExists('merchantRiskIndicator', $data ?? [], null);
        $this->setIfExists('metadata', $data ?? [], null);
        $this->setIfExists('mpiData', $data ?? [], null);
        $this->setIfExists('origin', $data ?? [], null);
        $this->setIfExists('paymentMethod', $data ?? [], null);
        $this->setIfExists('recurringProcessingModel', $data ?? [], null);
        $this->setIfExists('redirectFromIssuerMethod', $data ?? [], null);
        $this->setIfExists('redirectToIssuerMethod', $data ?? [], null);
        $this->setIfExists('reference', $data ?? [], null);
        $this->setIfExists('returnUrl', $data ?? [], null);
        $this->setIfExists('sessionValidity', $data ?? [], null);
        $this->setIfExists('shopperEmail', $data ?? [], null);
        $this->setIfExists('shopperIP', $data ?? [], null);
        $this->setIfExists('shopperInteraction', $data ?? [], null);
        $this->setIfExists('shopperLocale', $data ?? [], null);
        $this->setIfExists('shopperName', $data ?? [], null);
        $this->setIfExists('shopperReference', $data ?? [], null);
        $this->setIfExists('socialSecurityNumber', $data ?? [], null);
        $this->setIfExists('telephoneNumber', $data ?? [], null);
        $this->setIfExists('threeDS2RequestData', $data ?? [], null);
        $this->setIfExists('threeDSAuthenticationOnly', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['amount'] === null) {
            $invalidProperties[] = "'amount' can't be null";
        }
        $allowedValues = $this->getChannelAllowableValues();
        if (!is_null($this->container['channel']) && !in_array($this->container['channel'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'channel', must be one of '%s'",
                $this->container['channel'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['merchantAccount'] === null) {
            $invalidProperties[] = "'merchantAccount' can't be null";
        }
        if ($this->container['paymentMethod'] === null) {
            $invalidProperties[] = "'paymentMethod' can't be null";
        }
        $allowedValues = $this->getRecurringProcessingModelAllowableValues();
        if (!is_null($this->container['recurringProcessingModel']) && !in_array($this->container['recurringProcessingModel'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'recurringProcessingModel', must be one of '%s'",
                $this->container['recurringProcessingModel'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['reference'] === null) {
            $invalidProperties[] = "'reference' can't be null";
        }
        if ($this->container['returnUrl'] === null) {
            $invalidProperties[] = "'returnUrl' can't be null";
        }
        $allowedValues = $this->getShopperInteractionAllowableValues();
        if (!is_null($this->container['shopperInteraction']) && !in_array($this->container['shopperInteraction'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'shopperInteraction', must be one of '%s'",
                $this->container['shopperInteraction'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets accountInfo
     *
     * @return \Adyen\Model\Checkout\AccountInfo|null
     */
    public function getAccountInfo()
    {
        return $this->container['accountInfo'];
    }

    /**
     * Sets accountInfo
     *
     * @param \Adyen\Model\Checkout\AccountInfo|null $accountInfo accountInfo
     *
     * @return self
     */
    public function setAccountInfo($accountInfo)
    {
        $this->container['accountInfo'] = $accountInfo;

        return $this;
    }

    /**
     * Gets additionalData
     *
     * @return array<string,string>|null
     */
    public function getAdditionalData()
    {
        return $this->container['additionalData'];
    }

    /**
     * Sets additionalData
     *
     * @param array<string,string>|null $additionalData This field contains additional data, which may be required for a particular payment request.  The `additionalData` object consists of entries, each of which includes the key and value.
     *
     * @return self
     */
    public function setAdditionalData($additionalData)
    {
        $this->container['additionalData'] = $additionalData;

        return $this;
    }

    /**
     * Gets amount
     *
     * @return \Adyen\Model\Checkout\Amount
     */
    public function getAmount()
    {
        return $this->container['amount'];
    }

    /**
     * Sets amount
     *
     * @param \Adyen\Model\Checkout\Amount $amount amount
     *
     * @return self
     */
    public function setAmount($amount)
    {
        $this->container['amount'] = $amount;

        return $this;
    }

    /**
     * Gets applicationInfo
     *
     * @return \Adyen\Model\Checkout\ApplicationInfo|null
     */
    public function getApplicationInfo()
    {
        return $this->container['applicationInfo'];
    }

    /**
     * Sets applicationInfo
     *
     * @param \Adyen\Model\Checkout\ApplicationInfo|null $applicationInfo applicationInfo
     *
     * @return self
     */
    public function setApplicationInfo($applicationInfo)
    {
        $this->container['applicationInfo'] = $applicationInfo;

        return $this;
    }

    /**
     * Gets authenticationData
     *
     * @return \Adyen\Model\Checkout\AuthenticationData|null
     */
    public function getAuthenticationData()
    {
        return $this->container['authenticationData'];
    }

    /**
     * Sets authenticationData
     *
     * @param \Adyen\Model\Checkout\AuthenticationData|null $authenticationData authenticationData
     *
     * @return self
     */
    public function setAuthenticationData($authenticationData)
    {
        $this->container['authenticationData'] = $authenticationData;

        return $this;
    }

    /**
     * Gets billingAddress
     *
     * @return \Adyen\Model\Checkout\BillingAddress|null
     */
    public function getBillingAddress()
    {
        return $this->container['billingAddress'];
    }

    /**
     * Sets billingAddress
     *
     * @param \Adyen\Model\Checkout\BillingAddress|null $billingAddress billingAddress
     *
     * @return self
     */
    public function setBillingAddress($billingAddress)
    {
        $this->container['billingAddress'] = $billingAddress;

        return $this;
    }

    /**
     * Gets browserInfo
     *
     * @return \Adyen\Model\Checkout\BrowserInfo|null
     */
    public function getBrowserInfo()
    {
        return $this->container['browserInfo'];
    }

    /**
     * Sets browserInfo
     *
     * @param \Adyen\Model\Checkout\BrowserInfo|null $browserInfo browserInfo
     *
     * @return self
     */
    public function setBrowserInfo($browserInfo)
    {
        $this->container['browserInfo'] = $browserInfo;

        return $this;
    }

    /**
     * Gets channel
     *
     * @return string|null
     */
    public function getChannel()
    {
        return $this->container['channel'];
    }

    /**
     * Sets channel
     *
     * @param string|null $channel The platform where a payment transaction takes place. This field is optional for filtering out payment methods that are only available on specific platforms. If this value is not set, then we will try to infer it from the `sdkVersion` or `token`.  Possible values: * iOS * Android * Web
     *
     * @return self
     */
    public function setChannel($channel)
    {
        $allowedValues = $this->getChannelAllowableValues();
        if (!in_array($channel, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'channel', must be one of '%s'",
                    $channel,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['channel'] = $channel;

        return $this;
    }

    /**
     * Gets checkoutAttemptId
     *
     * @return string|null
     */
    public function getCheckoutAttemptId()
    {
        return $this->container['checkoutAttemptId'];
    }

    /**
     * Sets checkoutAttemptId
     *
     * @param string|null $checkoutAttemptId Checkout attempt ID that corresponds to the Id generated by the client SDK for tracking user payment journey.
     *
     * @return self
     */
    public function setCheckoutAttemptId($checkoutAttemptId)
    {
        $this->container['checkoutAttemptId'] = $checkoutAttemptId;

        return $this;
    }

    /**
     * Gets conversionId
     *
     * @return string|null
     * @deprecated
     */
    public function getConversionId()
    {
        return $this->container['conversionId'];
    }

    /**
     * Sets conversionId
     *
     * @param string|null $conversionId Conversion ID that corresponds to the Id generated by the client SDK for tracking user payment journey.
     *
     * @return self
     * @deprecated
     */
    public function setConversionId($conversionId)
    {
        $this->container['conversionId'] = $conversionId;

        return $this;
    }

    /**
     * Gets countryCode
     *
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->container['countryCode'];
    }

    /**
     * Sets countryCode
     *
     * @param string|null $countryCode The shopper country.  Format: [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) Example: NL or DE
     *
     * @return self
     */
    public function setCountryCode($countryCode)
    {
        $this->container['countryCode'] = $countryCode;

        return $this;
    }

    /**
     * Gets dateOfBirth
     *
     * @return \DateTime|null
     */
    public function getDateOfBirth()
    {
        return $this->container['dateOfBirth'];
    }

    /**
     * Sets dateOfBirth
     *
     * @param \DateTime|null $dateOfBirth The shopper's date of birth.  Format [ISO-8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DD
     *
     * @return self
     */
    public function setDateOfBirth($dateOfBirth)
    {
        $this->container['dateOfBirth'] = $dateOfBirth;

        return $this;
    }

    /**
     * Gets deliverAt
     *
     * @return \DateTime|null
     */
    public function getDeliverAt()
    {
        return $this->container['deliverAt'];
    }

    /**
     * Sets deliverAt
     *
     * @param \DateTime|null $deliverAt The date and time the purchased goods should be delivered.  Format [ISO 8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DDThh:mm:ss.sssTZD  Example: 2017-07-17T13:42:40.428+01:00
     *
     * @return self
     */
    public function setDeliverAt($deliverAt)
    {
        $this->container['deliverAt'] = $deliverAt;

        return $this;
    }

    /**
     * Gets deliveryAddress
     *
     * @return \Adyen\Model\Checkout\DeliveryAddress|null
     */
    public function getDeliveryAddress()
    {
        return $this->container['deliveryAddress'];
    }

    /**
     * Sets deliveryAddress
     *
     * @param \Adyen\Model\Checkout\DeliveryAddress|null $deliveryAddress deliveryAddress
     *
     * @return self
     */
    public function setDeliveryAddress($deliveryAddress)
    {
        $this->container['deliveryAddress'] = $deliveryAddress;

        return $this;
    }

    /**
     * Gets deviceFingerprint
     *
     * @return string|null
     */
    public function getDeviceFingerprint()
    {
        return $this->container['deviceFingerprint'];
    }

    /**
     * Sets deviceFingerprint
     *
     * @param string|null $deviceFingerprint A string containing the shopper's device fingerprint. For more information, refer to [Device fingerprinting](https://docs.adyen.com/risk-management/device-fingerprinting).
     *
     * @return self
     */
    public function setDeviceFingerprint($deviceFingerprint)
    {
        $this->container['deviceFingerprint'] = $deviceFingerprint;

        return $this;
    }

    /**
     * Gets donationAccount
     *
     * @return string|null
     */
    public function getDonationAccount()
    {
        return $this->container['donationAccount'];
    }

    /**
     * Sets donationAccount
     *
     * @param string|null $donationAccount Donation account to which the transaction is credited.
     *
     * @return self
     */
    public function setDonationAccount($donationAccount)
    {
        $this->container['donationAccount'] = $donationAccount;

        return $this;
    }

    /**
     * Gets donationCampaignId
     *
     * @return string|null
     */
    public function getDonationCampaignId()
    {
        return $this->container['donationCampaignId'];
    }

    /**
     * Sets donationCampaignId
     *
     * @param string|null $donationCampaignId The donation campaign ID received in the `/donationCampaigns` call.
     *
     * @return self
     */
    public function setDonationCampaignId($donationCampaignId)
    {
        $this->container['donationCampaignId'] = $donationCampaignId;

        return $this;
    }

    /**
     * Gets donationOriginalPspReference
     *
     * @return string|null
     */
    public function getDonationOriginalPspReference()
    {
        return $this->container['donationOriginalPspReference'];
    }

    /**
     * Sets donationOriginalPspReference
     *
     * @param string|null $donationOriginalPspReference PSP reference of the transaction from which the donation token is generated. Required when `donationToken` is provided.
     *
     * @return self
     */
    public function setDonationOriginalPspReference($donationOriginalPspReference)
    {
        $this->container['donationOriginalPspReference'] = $donationOriginalPspReference;

        return $this;
    }

    /**
     * Gets donationToken
     *
     * @return string|null
     */
    public function getDonationToken()
    {
        return $this->container['donationToken'];
    }

    /**
     * Sets donationToken
     *
     * @param string|null $donationToken Donation token received in the `/payments` call.
     *
     * @return self
     */
    public function setDonationToken($donationToken)
    {
        $this->container['donationToken'] = $donationToken;

        return $this;
    }

    /**
     * Gets lineItems
     *
     * @return \Adyen\Model\Checkout\LineItem[]|null
     */
    public function getLineItems()
    {
        return $this->container['lineItems'];
    }

    /**
     * Sets lineItems
     *
     * @param \Adyen\Model\Checkout\LineItem[]|null $lineItems Price and product information about the purchased items, to be included on the invoice sent to the shopper. > This field is required for 3x 4x Oney, Affirm, Afterpay, Clearpay, Klarna, Ratepay, and Zip.
     *
     * @return self
     */
    public function setLineItems($lineItems)
    {
        $this->container['lineItems'] = $lineItems;

        return $this;
    }

    /**
     * Gets merchantAccount
     *
     * @return string
     */
    public function getMerchantAccount()
    {
        return $this->container['merchantAccount'];
    }

    /**
     * Sets merchantAccount
     *
     * @param string $merchantAccount The merchant account identifier, with which you want to process the transaction.
     *
     * @return self
     */
    public function setMerchantAccount($merchantAccount)
    {
        $this->container['merchantAccount'] = $merchantAccount;

        return $this;
    }

    /**
     * Gets merchantRiskIndicator
     *
     * @return \Adyen\Model\Checkout\MerchantRiskIndicator|null
     */
    public function getMerchantRiskIndicator()
    {
        return $this->container['merchantRiskIndicator'];
    }

    /**
     * Sets merchantRiskIndicator
     *
     * @param \Adyen\Model\Checkout\MerchantRiskIndicator|null $merchantRiskIndicator merchantRiskIndicator
     *
     * @return self
     */
    public function setMerchantRiskIndicator($merchantRiskIndicator)
    {
        $this->container['merchantRiskIndicator'] = $merchantRiskIndicator;

        return $this;
    }

    /**
     * Gets metadata
     *
     * @return array<string,string>|null
     */
    public function getMetadata()
    {
        return $this->container['metadata'];
    }

    /**
     * Sets metadata
     *
     * @param array<string,string>|null $metadata Metadata consists of entries, each of which includes a key and a value. Limits: * Maximum 20 key-value pairs per request. When exceeding, the \"177\" error occurs: \"Metadata size exceeds limit\". * Maximum 20 characters per key. * Maximum 80 characters per value.
     *
     * @return self
     */
    public function setMetadata($metadata)
    {
        $this->container['metadata'] = $metadata;

        return $this;
    }

    /**
     * Gets mpiData
     *
     * @return \Adyen\Model\Checkout\ThreeDSecureData|null
     */
    public function getMpiData()
    {
        return $this->container['mpiData'];
    }

    /**
     * Sets mpiData
     *
     * @param \Adyen\Model\Checkout\ThreeDSecureData|null $mpiData mpiData
     *
     * @return self
     */
    public function setMpiData($mpiData)
    {
        $this->container['mpiData'] = $mpiData;

        return $this;
    }

    /**
     * Gets origin
     *
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->container['origin'];
    }

    /**
     * Sets origin
     *
     * @param string|null $origin Required for the 3D Secure 2 `channel` **Web** integration.  Set this parameter to the origin URL of the page that you are loading the 3D Secure Component from.
     *
     * @return self
     */
    public function setOrigin($origin)
    {
        $this->container['origin'] = $origin;

        return $this;
    }

    /**
     * Gets paymentMethod
     *
     * @return \Adyen\Model\Checkout\DonationPaymentMethod
     */
    public function getPaymentMethod()
    {
        return $this->container['paymentMethod'];
    }

    /**
     * Sets paymentMethod
     *
     * @param \Adyen\Model\Checkout\DonationPaymentMethod $paymentMethod paymentMethod
     *
     * @return self
     */
    public function setPaymentMethod($paymentMethod)
    {
        $this->container['paymentMethod'] = $paymentMethod;

        return $this;
    }

    /**
     * Gets recurringProcessingModel
     *
     * @return string|null
     */
    public function getRecurringProcessingModel()
    {
        return $this->container['recurringProcessingModel'];
    }

    /**
     * Sets recurringProcessingModel
     *
     * @param string|null $recurringProcessingModel Defines a recurring payment type. Required when creating a token to store payment details or using stored payment details. Allowed values: * `Subscription` – A transaction for a fixed or variable amount, which follows a fixed schedule. * `CardOnFile` – With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * `UnscheduledCardOnFile` – An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have variable amounts. For example, automatic top-ups when a cardholder's balance drops below a certain amount.
     *
     * @return self
     */
    public function setRecurringProcessingModel($recurringProcessingModel)
    {
        $allowedValues = $this->getRecurringProcessingModelAllowableValues();
        if (!in_array($recurringProcessingModel, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'recurringProcessingModel', must be one of '%s'",
                    $recurringProcessingModel,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['recurringProcessingModel'] = $recurringProcessingModel;

        return $this;
    }

    /**
     * Gets redirectFromIssuerMethod
     *
     * @return string|null
     */
    public function getRedirectFromIssuerMethod()
    {
        return $this->container['redirectFromIssuerMethod'];
    }

    /**
     * Sets redirectFromIssuerMethod
     *
     * @param string|null $redirectFromIssuerMethod Specifies the redirect method (GET or POST) when redirecting back from the issuer.
     *
     * @return self
     */
    public function setRedirectFromIssuerMethod($redirectFromIssuerMethod)
    {
        $this->container['redirectFromIssuerMethod'] = $redirectFromIssuerMethod;

        return $this;
    }

    /**
     * Gets redirectToIssuerMethod
     *
     * @return string|null
     */
    public function getRedirectToIssuerMethod()
    {
        return $this->container['redirectToIssuerMethod'];
    }

    /**
     * Sets redirectToIssuerMethod
     *
     * @param string|null $redirectToIssuerMethod Specifies the redirect method (GET or POST) when redirecting to the issuer.
     *
     * @return self
     */
    public function setRedirectToIssuerMethod($redirectToIssuerMethod)
    {
        $this->container['redirectToIssuerMethod'] = $redirectToIssuerMethod;

        return $this;
    }

    /**
     * Gets reference
     *
     * @return string
     */
    public function getReference()
    {
        return $this->container['reference'];
    }

    /**
     * Sets reference
     *
     * @param string $reference The reference to uniquely identify a payment. This reference is used in all communication with you about the payment status. We recommend using a unique value per payment; however, it is not a requirement. If you need to provide multiple references for a transaction, separate them with hyphens (\"-\"). Maximum length: 80 characters.
     *
     * @return self
     */
    public function setReference($reference)
    {
        $this->container['reference'] = $reference;

        return $this;
    }

    /**
     * Gets returnUrl
     *
     * @return string
     */
    public function getReturnUrl()
    {
        return $this->container['returnUrl'];
    }

    /**
     * Sets returnUrl
     *
     * @param string $returnUrl The URL to return to in case of a redirection. The format depends on the channel. This URL can have a maximum of 1024 characters. * For web, include the protocol `http://` or `https://`. You can also include your own additional query parameters, for example, shopper ID or order reference number. Example: `https://your-company.com/checkout?shopperOrder=12xy` * For iOS, use the custom URL for your app. To know more about setting custom URL schemes, refer to the [Apple Developer documentation](https://developer.apple.com/documentation/uikit/inter-process_communication/allowing_apps_and_websites_to_link_to_your_content/defining_a_custom_url_scheme_for_your_app). Example: `my-app://` * For Android, use a custom URL handled by an Activity on your app. You can configure it with an [intent filter](https://developer.android.com/guide/components/intents-filters). Example: `my-app://your.package.name` If the URL to return to includes non-ASCII characters, like spaces or special letters, URL encode the value. > The URL must not include personally identifiable information (PII), for example name or email address.
     *
     * @return self
     */
    public function setReturnUrl($returnUrl)
    {
        $this->container['returnUrl'] = $returnUrl;

        return $this;
    }

    /**
     * Gets sessionValidity
     *
     * @return string|null
     */
    public function getSessionValidity()
    {
        return $this->container['sessionValidity'];
    }

    /**
     * Sets sessionValidity
     *
     * @param string|null $sessionValidity The date and time until when the session remains valid, in [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format.  For example: 2020-07-18T15:42:40.428+01:00
     *
     * @return self
     */
    public function setSessionValidity($sessionValidity)
    {
        $this->container['sessionValidity'] = $sessionValidity;

        return $this;
    }

    /**
     * Gets shopperEmail
     *
     * @return string|null
     */
    public function getShopperEmail()
    {
        return $this->container['shopperEmail'];
    }

    /**
     * Sets shopperEmail
     *
     * @param string|null $shopperEmail The shopper's email address. We recommend that you provide this data, as it is used in velocity fraud checks. > For 3D Secure 2 transactions, schemes require `shopperEmail` for all browser-based and mobile implementations.
     *
     * @return self
     */
    public function setShopperEmail($shopperEmail)
    {
        $this->container['shopperEmail'] = $shopperEmail;

        return $this;
    }

    /**
     * Gets shopperIP
     *
     * @return string|null
     */
    public function getShopperIP()
    {
        return $this->container['shopperIP'];
    }

    /**
     * Sets shopperIP
     *
     * @param string|null $shopperIP The shopper's IP address. In general, we recommend that you provide this data, as it is used in a number of risk checks (for instance, number of payment attempts or location-based checks). > For 3D Secure 2 transactions, schemes require `shopperIP` for all browser-based implementations. This field is also mandatory for some merchants depending on your business model. For more information, [contact Support](https://www.adyen.help/hc/en-us/requests/new).
     *
     * @return self
     */
    public function setShopperIP($shopperIP)
    {
        $this->container['shopperIP'] = $shopperIP;

        return $this;
    }

    /**
     * Gets shopperInteraction
     *
     * @return string|null
     */
    public function getShopperInteraction()
    {
        return $this->container['shopperInteraction'];
    }

    /**
     * Sets shopperInteraction
     *
     * @param string|null $shopperInteraction Specifies the sales channel, through which the shopper gives their card details, and whether the shopper is a returning customer. For the web service API, Adyen assumes Ecommerce shopper interaction by default.  This field has the following possible values: * `Ecommerce` - Online transactions where the cardholder is present (online). For better authorisation rates, we recommend sending the card security code (CSC) along with the request. * `ContAuth` - Card on file and/or subscription transactions, where the cardholder is known to the merchant (returning customer). If the shopper is present (online), you can supply also the CSC to improve authorisation (one-click payment). * `Moto` - Mail-order and telephone-order transactions where the shopper is in contact with the merchant via email or telephone. * `POS` - Point-of-sale transactions where the shopper is physically present to make a payment using a secure payment terminal.
     *
     * @return self
     */
    public function setShopperInteraction($shopperInteraction)
    {
        $allowedValues = $this->getShopperInteractionAllowableValues();
        if (!in_array($shopperInteraction, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'shopperInteraction', must be one of '%s'",
                    $shopperInteraction,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['shopperInteraction'] = $shopperInteraction;

        return $this;
    }

    /**
     * Gets shopperLocale
     *
     * @return string|null
     */
    public function getShopperLocale()
    {
        return $this->container['shopperLocale'];
    }

    /**
     * Sets shopperLocale
     *
     * @param string|null $shopperLocale The combination of a language code and a country code to specify the language to be used in the payment.
     *
     * @return self
     */
    public function setShopperLocale($shopperLocale)
    {
        $this->container['shopperLocale'] = $shopperLocale;

        return $this;
    }

    /**
     * Gets shopperName
     *
     * @return \Adyen\Model\Checkout\Name|null
     */
    public function getShopperName()
    {
        return $this->container['shopperName'];
    }

    /**
     * Sets shopperName
     *
     * @param \Adyen\Model\Checkout\Name|null $shopperName shopperName
     *
     * @return self
     */
    public function setShopperName($shopperName)
    {
        $this->container['shopperName'] = $shopperName;

        return $this;
    }

    /**
     * Gets shopperReference
     *
     * @return string|null
     */
    public function getShopperReference()
    {
        return $this->container['shopperReference'];
    }

    /**
     * Sets shopperReference
     *
     * @param string|null $shopperReference Required for recurring payments.  Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. > Your reference must not include personally identifiable information (PII), for example name or email address.
     *
     * @return self
     */
    public function setShopperReference($shopperReference)
    {
        $this->container['shopperReference'] = $shopperReference;

        return $this;
    }

    /**
     * Gets socialSecurityNumber
     *
     * @return string|null
     */
    public function getSocialSecurityNumber()
    {
        return $this->container['socialSecurityNumber'];
    }

    /**
     * Sets socialSecurityNumber
     *
     * @param string|null $socialSecurityNumber The shopper's social security number.
     *
     * @return self
     */
    public function setSocialSecurityNumber($socialSecurityNumber)
    {
        $this->container['socialSecurityNumber'] = $socialSecurityNumber;

        return $this;
    }

    /**
     * Gets telephoneNumber
     *
     * @return string|null
     */
    public function getTelephoneNumber()
    {
        return $this->container['telephoneNumber'];
    }

    /**
     * Sets telephoneNumber
     *
     * @param string|null $telephoneNumber The shopper's telephone number.
     *
     * @return self
     */
    public function setTelephoneNumber($telephoneNumber)
    {
        $this->container['telephoneNumber'] = $telephoneNumber;

        return $this;
    }

    /**
     * Gets threeDS2RequestData
     *
     * @return \Adyen\Model\Checkout\ThreeDS2RequestFields|null
     */
    public function getThreeDS2RequestData()
    {
        return $this->container['threeDS2RequestData'];
    }

    /**
     * Sets threeDS2RequestData
     *
     * @param \Adyen\Model\Checkout\ThreeDS2RequestFields|null $threeDS2RequestData threeDS2RequestData
     *
     * @return self
     */
    public function setThreeDS2RequestData($threeDS2RequestData)
    {
        $this->container['threeDS2RequestData'] = $threeDS2RequestData;

        return $this;
    }

    /**
     * Gets threeDSAuthenticationOnly
     *
     * @return bool|null
     * @deprecated
     */
    public function getThreeDSAuthenticationOnly()
    {
        return $this->container['threeDSAuthenticationOnly'];
    }

    /**
     * Sets threeDSAuthenticationOnly
     *
     * @param bool|null $threeDSAuthenticationOnly If set to true, you will only perform the [3D Secure 2 authentication](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only), and not the payment authorisation.
     *
     * @return self
     * @deprecated
     */
    public function setThreeDSAuthenticationOnly($threeDSAuthenticationOnly)
    {
        $this->container['threeDSAuthenticationOnly'] = $threeDSAuthenticationOnly;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    public function toArray(): array
    {
        $array = [];
        foreach (self::$openAPITypes as $propertyName => $propertyType) {
            $propertyValue = $this[$propertyName];
            if ($propertyValue !== null) {
                // Check if the property value is an object and has a toArray() method
                if (is_object($propertyValue) && method_exists($propertyValue, 'toArray')) {
                    $array[$propertyName] = $propertyValue->toArray();
                // Check if it's type datetime
                } elseif ($propertyValue instanceof \DateTime) {
                    $array[$propertyName] = $propertyValue->format(DATE_ATOM);
                // If it's an array type we should check whether it contains objects and if so call toArray method
                } elseif (is_array($propertyValue)) {
                    $array[$propertyName] = array_map(function ($item) {
                        return $item instanceof ModelInterface ? $item->toArray() : $item;
                    }, $propertyValue);
                } else {
                    // Otherwise, directly assign the property value to the array
                    $array[$propertyName] = $propertyValue;
                }
            }
        }
        return $array;
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}
