<?php

/**
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Adyen\Model\Checkout;

use \ArrayAccess;
use Adyen\Model\Checkout\ObjectSerializer;

/**
 * LineItem Class Doc Comment
 *
 * @category Class
 * @package  Adyen
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class LineItem implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'LineItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'amountExcludingTax' => 'int',
        'amountIncludingTax' => 'int',
        'brand' => 'string',
        'color' => 'string',
        'description' => 'string',
        'id' => 'string',
        'imageUrl' => 'string',
        'itemCategory' => 'string',
        'manufacturer' => 'string',
        'marketplaceSellerId' => 'string',
        'productUrl' => 'string',
        'quantity' => 'int',
        'receiverEmail' => 'string',
        'size' => 'string',
        'sku' => 'string',
        'taxAmount' => 'int',
        'taxPercentage' => 'int',
        'upc' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'amountExcludingTax' => 'int64',
        'amountIncludingTax' => 'int64',
        'brand' => null,
        'color' => null,
        'description' => null,
        'id' => null,
        'imageUrl' => null,
        'itemCategory' => null,
        'manufacturer' => null,
        'marketplaceSellerId' => null,
        'productUrl' => null,
        'quantity' => 'int64',
        'receiverEmail' => null,
        'size' => null,
        'sku' => null,
        'taxAmount' => 'int64',
        'taxPercentage' => 'int64',
        'upc' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'amountExcludingTax' => false,
        'amountIncludingTax' => false,
        'brand' => false,
        'color' => false,
        'description' => false,
        'id' => false,
        'imageUrl' => false,
        'itemCategory' => false,
        'manufacturer' => false,
        'marketplaceSellerId' => false,
        'productUrl' => false,
        'quantity' => false,
        'receiverEmail' => false,
        'size' => false,
        'sku' => false,
        'taxAmount' => false,
        'taxPercentage' => false,
        'upc' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'amountExcludingTax' => 'amountExcludingTax',
        'amountIncludingTax' => 'amountIncludingTax',
        'brand' => 'brand',
        'color' => 'color',
        'description' => 'description',
        'id' => 'id',
        'imageUrl' => 'imageUrl',
        'itemCategory' => 'itemCategory',
        'manufacturer' => 'manufacturer',
        'marketplaceSellerId' => 'marketplaceSellerId',
        'productUrl' => 'productUrl',
        'quantity' => 'quantity',
        'receiverEmail' => 'receiverEmail',
        'size' => 'size',
        'sku' => 'sku',
        'taxAmount' => 'taxAmount',
        'taxPercentage' => 'taxPercentage',
        'upc' => 'upc'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'amountExcludingTax' => 'setAmountExcludingTax',
        'amountIncludingTax' => 'setAmountIncludingTax',
        'brand' => 'setBrand',
        'color' => 'setColor',
        'description' => 'setDescription',
        'id' => 'setId',
        'imageUrl' => 'setImageUrl',
        'itemCategory' => 'setItemCategory',
        'manufacturer' => 'setManufacturer',
        'marketplaceSellerId' => 'setMarketplaceSellerId',
        'productUrl' => 'setProductUrl',
        'quantity' => 'setQuantity',
        'receiverEmail' => 'setReceiverEmail',
        'size' => 'setSize',
        'sku' => 'setSku',
        'taxAmount' => 'setTaxAmount',
        'taxPercentage' => 'setTaxPercentage',
        'upc' => 'setUpc'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'amountExcludingTax' => 'getAmountExcludingTax',
        'amountIncludingTax' => 'getAmountIncludingTax',
        'brand' => 'getBrand',
        'color' => 'getColor',
        'description' => 'getDescription',
        'id' => 'getId',
        'imageUrl' => 'getImageUrl',
        'itemCategory' => 'getItemCategory',
        'manufacturer' => 'getManufacturer',
        'marketplaceSellerId' => 'getMarketplaceSellerId',
        'productUrl' => 'getProductUrl',
        'quantity' => 'getQuantity',
        'receiverEmail' => 'getReceiverEmail',
        'size' => 'getSize',
        'sku' => 'getSku',
        'taxAmount' => 'getTaxAmount',
        'taxPercentage' => 'getTaxPercentage',
        'upc' => 'getUpc'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('amountExcludingTax', $data ?? [], null);
        $this->setIfExists('amountIncludingTax', $data ?? [], null);
        $this->setIfExists('brand', $data ?? [], null);
        $this->setIfExists('color', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('imageUrl', $data ?? [], null);
        $this->setIfExists('itemCategory', $data ?? [], null);
        $this->setIfExists('manufacturer', $data ?? [], null);
        $this->setIfExists('marketplaceSellerId', $data ?? [], null);
        $this->setIfExists('productUrl', $data ?? [], null);
        $this->setIfExists('quantity', $data ?? [], null);
        $this->setIfExists('receiverEmail', $data ?? [], null);
        $this->setIfExists('size', $data ?? [], null);
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('taxAmount', $data ?? [], null);
        $this->setIfExists('taxPercentage', $data ?? [], null);
        $this->setIfExists('upc', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets amountExcludingTax
     *
     * @return int|null
     */
    public function getAmountExcludingTax()
    {
        return $this->container['amountExcludingTax'];
    }

    /**
     * Sets amountExcludingTax
     *
     * @param int|null $amountExcludingTax Item amount excluding the tax, in minor units.
     *
     * @return self
     */
    public function setAmountExcludingTax($amountExcludingTax)
    {
        $this->container['amountExcludingTax'] = $amountExcludingTax;

        return $this;
    }

    /**
     * Gets amountIncludingTax
     *
     * @return int|null
     */
    public function getAmountIncludingTax()
    {
        return $this->container['amountIncludingTax'];
    }

    /**
     * Sets amountIncludingTax
     *
     * @param int|null $amountIncludingTax Item amount including the tax, in minor units.
     *
     * @return self
     */
    public function setAmountIncludingTax($amountIncludingTax)
    {
        $this->container['amountIncludingTax'] = $amountIncludingTax;

        return $this;
    }

    /**
     * Gets brand
     *
     * @return string|null
     */
    public function getBrand()
    {
        return $this->container['brand'];
    }

    /**
     * Sets brand
     *
     * @param string|null $brand Brand of the item.
     *
     * @return self
     */
    public function setBrand($brand)
    {
        $this->container['brand'] = $brand;

        return $this;
    }

    /**
     * Gets color
     *
     * @return string|null
     */
    public function getColor()
    {
        return $this->container['color'];
    }

    /**
     * Sets color
     *
     * @param string|null $color Color of the item.
     *
     * @return self
     */
    public function setColor($color)
    {
        $this->container['color'] = $color;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description Description of the line item.
     *
     * @return self
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id ID of the line item.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets imageUrl
     *
     * @return string|null
     */
    public function getImageUrl()
    {
        return $this->container['imageUrl'];
    }

    /**
     * Sets imageUrl
     *
     * @param string|null $imageUrl Link to the picture of the purchased item.
     *
     * @return self
     */
    public function setImageUrl($imageUrl)
    {
        $this->container['imageUrl'] = $imageUrl;

        return $this;
    }

    /**
     * Gets itemCategory
     *
     * @return string|null
     */
    public function getItemCategory()
    {
        return $this->container['itemCategory'];
    }

    /**
     * Sets itemCategory
     *
     * @param string|null $itemCategory Item category, used by the payment methods PayPal and Ratepay.
     *
     * @return self
     */
    public function setItemCategory($itemCategory)
    {
        $this->container['itemCategory'] = $itemCategory;

        return $this;
    }

    /**
     * Gets manufacturer
     *
     * @return string|null
     */
    public function getManufacturer()
    {
        return $this->container['manufacturer'];
    }

    /**
     * Sets manufacturer
     *
     * @param string|null $manufacturer Manufacturer of the item.
     *
     * @return self
     */
    public function setManufacturer($manufacturer)
    {
        $this->container['manufacturer'] = $manufacturer;

        return $this;
    }

    /**
     * Gets marketplaceSellerId
     *
     * @return string|null
     */
    public function getMarketplaceSellerId()
    {
        return $this->container['marketplaceSellerId'];
    }

    /**
     * Sets marketplaceSellerId
     *
     * @param string|null $marketplaceSellerId Marketplace seller id.
     *
     * @return self
     */
    public function setMarketplaceSellerId($marketplaceSellerId)
    {
        $this->container['marketplaceSellerId'] = $marketplaceSellerId;

        return $this;
    }

    /**
     * Gets productUrl
     *
     * @return string|null
     */
    public function getProductUrl()
    {
        return $this->container['productUrl'];
    }

    /**
     * Sets productUrl
     *
     * @param string|null $productUrl Link to the purchased item.
     *
     * @return self
     */
    public function setProductUrl($productUrl)
    {
        $this->container['productUrl'] = $productUrl;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param int|null $quantity Number of items.
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets receiverEmail
     *
     * @return string|null
     */
    public function getReceiverEmail()
    {
        return $this->container['receiverEmail'];
    }

    /**
     * Sets receiverEmail
     *
     * @param string|null $receiverEmail Email associated with the given product in the basket (usually in electronic gift cards).
     *
     * @return self
     */
    public function setReceiverEmail($receiverEmail)
    {
        $this->container['receiverEmail'] = $receiverEmail;

        return $this;
    }

    /**
     * Gets size
     *
     * @return string|null
     */
    public function getSize()
    {
        return $this->container['size'];
    }

    /**
     * Sets size
     *
     * @param string|null $size Size of the item.
     *
     * @return self
     */
    public function setSize($size)
    {
        $this->container['size'] = $size;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku Stock keeping unit.
     *
     * @return self
     */
    public function setSku($sku)
    {
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets taxAmount
     *
     * @return int|null
     */
    public function getTaxAmount()
    {
        return $this->container['taxAmount'];
    }

    /**
     * Sets taxAmount
     *
     * @param int|null $taxAmount Tax amount, in minor units.
     *
     * @return self
     */
    public function setTaxAmount($taxAmount)
    {
        $this->container['taxAmount'] = $taxAmount;

        return $this;
    }

    /**
     * Gets taxPercentage
     *
     * @return int|null
     */
    public function getTaxPercentage()
    {
        return $this->container['taxPercentage'];
    }

    /**
     * Sets taxPercentage
     *
     * @param int|null $taxPercentage Tax percentage, in minor units.
     *
     * @return self
     */
    public function setTaxPercentage($taxPercentage)
    {
        $this->container['taxPercentage'] = $taxPercentage;

        return $this;
    }

    /**
     * Gets upc
     *
     * @return string|null
     */
    public function getUpc()
    {
        return $this->container['upc'];
    }

    /**
     * Sets upc
     *
     * @param string|null $upc Universal Product Code.
     *
     * @return self
     */
    public function setUpc($upc)
    {
        $this->container['upc'] = $upc;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    public function toArray(): array
    {
        $array = [];
        foreach (self::$openAPITypes as $propertyName => $propertyType) {
            $propertyValue = $this[$propertyName];
            if ($propertyValue !== null) {
                // Check if the property value is an object and has a toArray() method
                if (is_object($propertyValue) && method_exists($propertyValue, 'toArray')) {
                    $array[$propertyName] = $propertyValue->toArray();
                // Check if it's type datetime
                } elseif ($propertyValue instanceof \DateTime) {
                    $array[$propertyName] = $propertyValue->format(DATE_ATOM);
                // If it's an array type we should check whether it contains objects and if so call toArray method
                } elseif (is_array($propertyValue)) {
                    $array[$propertyName] = array_map(function ($item) {
                        return $item instanceof ModelInterface ? $item->toArray() : $item;
                    }, $propertyValue);
                } else {
                    // Otherwise, directly assign the property value to the array
                    $array[$propertyName] = $propertyValue;
                }
            }
        }
        return $array;
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}
