<?php

/**
 * Adyen Checkout API
 *
 * The version of the OpenAPI document: 71
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Adyen\Model\Checkout;

use \ArrayAccess;
use Adyen\Model\Checkout\ObjectSerializer;

/**
 * ThreeDS2RequestFields Class Doc Comment
 *
 * @category Class
 * @package  Adyen
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ThreeDS2RequestFields implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ThreeDS2RequestFields';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'acctInfo' => '\Adyen\Model\Checkout\AcctInfo',
        'acctType' => 'string',
        'acquirerBIN' => 'string',
        'acquirerMerchantID' => 'string',
        'addrMatch' => 'string',
        'authenticationOnly' => 'bool',
        'challengeIndicator' => 'string',
        'deviceRenderOptions' => '\Adyen\Model\Checkout\DeviceRenderOptions',
        'homePhone' => '\Adyen\Model\Checkout\Phone',
        'mcc' => 'string',
        'merchantName' => 'string',
        'messageVersion' => 'string',
        'mobilePhone' => '\Adyen\Model\Checkout\Phone',
        'notificationURL' => 'string',
        'payTokenInd' => 'bool',
        'paymentAuthenticationUseCase' => 'string',
        'purchaseInstalData' => 'string',
        'recurringExpiry' => 'string',
        'recurringFrequency' => 'string',
        'sdkAppID' => 'string',
        'sdkEphemPubKey' => '\Adyen\Model\Checkout\SDKEphemPubKey',
        'sdkMaxTimeout' => 'int',
        'sdkReferenceNumber' => 'string',
        'sdkTransID' => 'string',
        'threeDSCompInd' => 'string',
        'threeDSRequestorAuthenticationInd' => 'string',
        'threeDSRequestorAuthenticationInfo' => '\Adyen\Model\Checkout\ThreeDSRequestorAuthenticationInfo',
        'threeDSRequestorChallengeInd' => 'string',
        'threeDSRequestorID' => 'string',
        'threeDSRequestorName' => 'string',
        'threeDSRequestorPriorAuthenticationInfo' => '\Adyen\Model\Checkout\ThreeDSRequestorPriorAuthenticationInfo',
        'threeDSRequestorURL' => 'string',
        'transType' => 'string',
        'transactionType' => 'string',
        'whiteListStatus' => 'string',
        'workPhone' => '\Adyen\Model\Checkout\Phone'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'acctInfo' => null,
        'acctType' => null,
        'acquirerBIN' => null,
        'acquirerMerchantID' => null,
        'addrMatch' => null,
        'authenticationOnly' => null,
        'challengeIndicator' => null,
        'deviceRenderOptions' => null,
        'homePhone' => null,
        'mcc' => null,
        'merchantName' => null,
        'messageVersion' => null,
        'mobilePhone' => null,
        'notificationURL' => null,
        'payTokenInd' => null,
        'paymentAuthenticationUseCase' => null,
        'purchaseInstalData' => null,
        'recurringExpiry' => null,
        'recurringFrequency' => null,
        'sdkAppID' => null,
        'sdkEphemPubKey' => null,
        'sdkMaxTimeout' => 'int32',
        'sdkReferenceNumber' => null,
        'sdkTransID' => null,
        'threeDSCompInd' => null,
        'threeDSRequestorAuthenticationInd' => null,
        'threeDSRequestorAuthenticationInfo' => null,
        'threeDSRequestorChallengeInd' => null,
        'threeDSRequestorID' => null,
        'threeDSRequestorName' => null,
        'threeDSRequestorPriorAuthenticationInfo' => null,
        'threeDSRequestorURL' => null,
        'transType' => null,
        'transactionType' => null,
        'whiteListStatus' => null,
        'workPhone' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'acctInfo' => false,
        'acctType' => false,
        'acquirerBIN' => false,
        'acquirerMerchantID' => false,
        'addrMatch' => false,
        'authenticationOnly' => false,
        'challengeIndicator' => false,
        'deviceRenderOptions' => false,
        'homePhone' => false,
        'mcc' => false,
        'merchantName' => false,
        'messageVersion' => false,
        'mobilePhone' => false,
        'notificationURL' => false,
        'payTokenInd' => false,
        'paymentAuthenticationUseCase' => false,
        'purchaseInstalData' => false,
        'recurringExpiry' => false,
        'recurringFrequency' => false,
        'sdkAppID' => false,
        'sdkEphemPubKey' => false,
        'sdkMaxTimeout' => true,
        'sdkReferenceNumber' => false,
        'sdkTransID' => false,
        'threeDSCompInd' => false,
        'threeDSRequestorAuthenticationInd' => false,
        'threeDSRequestorAuthenticationInfo' => false,
        'threeDSRequestorChallengeInd' => false,
        'threeDSRequestorID' => false,
        'threeDSRequestorName' => false,
        'threeDSRequestorPriorAuthenticationInfo' => false,
        'threeDSRequestorURL' => false,
        'transType' => false,
        'transactionType' => false,
        'whiteListStatus' => false,
        'workPhone' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'acctInfo' => 'acctInfo',
        'acctType' => 'acctType',
        'acquirerBIN' => 'acquirerBIN',
        'acquirerMerchantID' => 'acquirerMerchantID',
        'addrMatch' => 'addrMatch',
        'authenticationOnly' => 'authenticationOnly',
        'challengeIndicator' => 'challengeIndicator',
        'deviceRenderOptions' => 'deviceRenderOptions',
        'homePhone' => 'homePhone',
        'mcc' => 'mcc',
        'merchantName' => 'merchantName',
        'messageVersion' => 'messageVersion',
        'mobilePhone' => 'mobilePhone',
        'notificationURL' => 'notificationURL',
        'payTokenInd' => 'payTokenInd',
        'paymentAuthenticationUseCase' => 'paymentAuthenticationUseCase',
        'purchaseInstalData' => 'purchaseInstalData',
        'recurringExpiry' => 'recurringExpiry',
        'recurringFrequency' => 'recurringFrequency',
        'sdkAppID' => 'sdkAppID',
        'sdkEphemPubKey' => 'sdkEphemPubKey',
        'sdkMaxTimeout' => 'sdkMaxTimeout',
        'sdkReferenceNumber' => 'sdkReferenceNumber',
        'sdkTransID' => 'sdkTransID',
        'threeDSCompInd' => 'threeDSCompInd',
        'threeDSRequestorAuthenticationInd' => 'threeDSRequestorAuthenticationInd',
        'threeDSRequestorAuthenticationInfo' => 'threeDSRequestorAuthenticationInfo',
        'threeDSRequestorChallengeInd' => 'threeDSRequestorChallengeInd',
        'threeDSRequestorID' => 'threeDSRequestorID',
        'threeDSRequestorName' => 'threeDSRequestorName',
        'threeDSRequestorPriorAuthenticationInfo' => 'threeDSRequestorPriorAuthenticationInfo',
        'threeDSRequestorURL' => 'threeDSRequestorURL',
        'transType' => 'transType',
        'transactionType' => 'transactionType',
        'whiteListStatus' => 'whiteListStatus',
        'workPhone' => 'workPhone'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'acctInfo' => 'setAcctInfo',
        'acctType' => 'setAcctType',
        'acquirerBIN' => 'setAcquirerBIN',
        'acquirerMerchantID' => 'setAcquirerMerchantID',
        'addrMatch' => 'setAddrMatch',
        'authenticationOnly' => 'setAuthenticationOnly',
        'challengeIndicator' => 'setChallengeIndicator',
        'deviceRenderOptions' => 'setDeviceRenderOptions',
        'homePhone' => 'setHomePhone',
        'mcc' => 'setMcc',
        'merchantName' => 'setMerchantName',
        'messageVersion' => 'setMessageVersion',
        'mobilePhone' => 'setMobilePhone',
        'notificationURL' => 'setNotificationURL',
        'payTokenInd' => 'setPayTokenInd',
        'paymentAuthenticationUseCase' => 'setPaymentAuthenticationUseCase',
        'purchaseInstalData' => 'setPurchaseInstalData',
        'recurringExpiry' => 'setRecurringExpiry',
        'recurringFrequency' => 'setRecurringFrequency',
        'sdkAppID' => 'setSdkAppID',
        'sdkEphemPubKey' => 'setSdkEphemPubKey',
        'sdkMaxTimeout' => 'setSdkMaxTimeout',
        'sdkReferenceNumber' => 'setSdkReferenceNumber',
        'sdkTransID' => 'setSdkTransID',
        'threeDSCompInd' => 'setThreeDSCompInd',
        'threeDSRequestorAuthenticationInd' => 'setThreeDSRequestorAuthenticationInd',
        'threeDSRequestorAuthenticationInfo' => 'setThreeDSRequestorAuthenticationInfo',
        'threeDSRequestorChallengeInd' => 'setThreeDSRequestorChallengeInd',
        'threeDSRequestorID' => 'setThreeDSRequestorID',
        'threeDSRequestorName' => 'setThreeDSRequestorName',
        'threeDSRequestorPriorAuthenticationInfo' => 'setThreeDSRequestorPriorAuthenticationInfo',
        'threeDSRequestorURL' => 'setThreeDSRequestorURL',
        'transType' => 'setTransType',
        'transactionType' => 'setTransactionType',
        'whiteListStatus' => 'setWhiteListStatus',
        'workPhone' => 'setWorkPhone'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'acctInfo' => 'getAcctInfo',
        'acctType' => 'getAcctType',
        'acquirerBIN' => 'getAcquirerBIN',
        'acquirerMerchantID' => 'getAcquirerMerchantID',
        'addrMatch' => 'getAddrMatch',
        'authenticationOnly' => 'getAuthenticationOnly',
        'challengeIndicator' => 'getChallengeIndicator',
        'deviceRenderOptions' => 'getDeviceRenderOptions',
        'homePhone' => 'getHomePhone',
        'mcc' => 'getMcc',
        'merchantName' => 'getMerchantName',
        'messageVersion' => 'getMessageVersion',
        'mobilePhone' => 'getMobilePhone',
        'notificationURL' => 'getNotificationURL',
        'payTokenInd' => 'getPayTokenInd',
        'paymentAuthenticationUseCase' => 'getPaymentAuthenticationUseCase',
        'purchaseInstalData' => 'getPurchaseInstalData',
        'recurringExpiry' => 'getRecurringExpiry',
        'recurringFrequency' => 'getRecurringFrequency',
        'sdkAppID' => 'getSdkAppID',
        'sdkEphemPubKey' => 'getSdkEphemPubKey',
        'sdkMaxTimeout' => 'getSdkMaxTimeout',
        'sdkReferenceNumber' => 'getSdkReferenceNumber',
        'sdkTransID' => 'getSdkTransID',
        'threeDSCompInd' => 'getThreeDSCompInd',
        'threeDSRequestorAuthenticationInd' => 'getThreeDSRequestorAuthenticationInd',
        'threeDSRequestorAuthenticationInfo' => 'getThreeDSRequestorAuthenticationInfo',
        'threeDSRequestorChallengeInd' => 'getThreeDSRequestorChallengeInd',
        'threeDSRequestorID' => 'getThreeDSRequestorID',
        'threeDSRequestorName' => 'getThreeDSRequestorName',
        'threeDSRequestorPriorAuthenticationInfo' => 'getThreeDSRequestorPriorAuthenticationInfo',
        'threeDSRequestorURL' => 'getThreeDSRequestorURL',
        'transType' => 'getTransType',
        'transactionType' => 'getTransactionType',
        'whiteListStatus' => 'getWhiteListStatus',
        'workPhone' => 'getWorkPhone'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const ACCT_TYPE__01 = '01';
    public const ACCT_TYPE__02 = '02';
    public const ACCT_TYPE__03 = '03';
    public const ADDR_MATCH_Y = 'Y';
    public const ADDR_MATCH_N = 'N';
    public const CHALLENGE_INDICATOR_NO_PREFERENCE = 'noPreference';
    public const CHALLENGE_INDICATOR_REQUEST_NO_CHALLENGE = 'requestNoChallenge';
    public const CHALLENGE_INDICATOR_REQUEST_CHALLENGE = 'requestChallenge';
    public const CHALLENGE_INDICATOR_REQUEST_CHALLENGE_AS_MANDATE = 'requestChallengeAsMandate';
    public const THREE_DS_REQUESTOR_CHALLENGE_IND__01 = '01';
    public const THREE_DS_REQUESTOR_CHALLENGE_IND__02 = '02';
    public const THREE_DS_REQUESTOR_CHALLENGE_IND__03 = '03';
    public const THREE_DS_REQUESTOR_CHALLENGE_IND__04 = '04';
    public const THREE_DS_REQUESTOR_CHALLENGE_IND__05 = '05';
    public const THREE_DS_REQUESTOR_CHALLENGE_IND__06 = '06';
    public const TRANS_TYPE__01 = '01';
    public const TRANS_TYPE__03 = '03';
    public const TRANS_TYPE__10 = '10';
    public const TRANS_TYPE__11 = '11';
    public const TRANS_TYPE__28 = '28';
    public const TRANSACTION_TYPE_GOODS_OR_SERVICE_PURCHASE = 'goodsOrServicePurchase';
    public const TRANSACTION_TYPE_CHECK_ACCEPTANCE = 'checkAcceptance';
    public const TRANSACTION_TYPE_ACCOUNT_FUNDING = 'accountFunding';
    public const TRANSACTION_TYPE_QUASI_CASH_TRANSACTION = 'quasiCashTransaction';
    public const TRANSACTION_TYPE_PREPAID_ACTIVATION_AND_LOAD = 'prepaidActivationAndLoad';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getAcctTypeAllowableValues()
    {
        return [
            self::ACCT_TYPE__01,
            self::ACCT_TYPE__02,
            self::ACCT_TYPE__03,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getAddrMatchAllowableValues()
    {
        return [
            self::ADDR_MATCH_Y,
            self::ADDR_MATCH_N,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getChallengeIndicatorAllowableValues()
    {
        return [
            self::CHALLENGE_INDICATOR_NO_PREFERENCE,
            self::CHALLENGE_INDICATOR_REQUEST_NO_CHALLENGE,
            self::CHALLENGE_INDICATOR_REQUEST_CHALLENGE,
            self::CHALLENGE_INDICATOR_REQUEST_CHALLENGE_AS_MANDATE,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getThreeDSRequestorChallengeIndAllowableValues()
    {
        return [
            self::THREE_DS_REQUESTOR_CHALLENGE_IND__01,
            self::THREE_DS_REQUESTOR_CHALLENGE_IND__02,
            self::THREE_DS_REQUESTOR_CHALLENGE_IND__03,
            self::THREE_DS_REQUESTOR_CHALLENGE_IND__04,
            self::THREE_DS_REQUESTOR_CHALLENGE_IND__05,
            self::THREE_DS_REQUESTOR_CHALLENGE_IND__06,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTransTypeAllowableValues()
    {
        return [
            self::TRANS_TYPE__01,
            self::TRANS_TYPE__03,
            self::TRANS_TYPE__10,
            self::TRANS_TYPE__11,
            self::TRANS_TYPE__28,
        ];
    }
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTransactionTypeAllowableValues()
    {
        return [
            self::TRANSACTION_TYPE_GOODS_OR_SERVICE_PURCHASE,
            self::TRANSACTION_TYPE_CHECK_ACCEPTANCE,
            self::TRANSACTION_TYPE_ACCOUNT_FUNDING,
            self::TRANSACTION_TYPE_QUASI_CASH_TRANSACTION,
            self::TRANSACTION_TYPE_PREPAID_ACTIVATION_AND_LOAD,
        ];
    }
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('acctInfo', $data ?? [], null);
        $this->setIfExists('acctType', $data ?? [], null);
        $this->setIfExists('acquirerBIN', $data ?? [], null);
        $this->setIfExists('acquirerMerchantID', $data ?? [], null);
        $this->setIfExists('addrMatch', $data ?? [], null);
        $this->setIfExists('authenticationOnly', $data ?? [], null);
        $this->setIfExists('challengeIndicator', $data ?? [], null);
        $this->setIfExists('deviceRenderOptions', $data ?? [], null);
        $this->setIfExists('homePhone', $data ?? [], null);
        $this->setIfExists('mcc', $data ?? [], null);
        $this->setIfExists('merchantName', $data ?? [], null);
        $this->setIfExists('messageVersion', $data ?? [], null);
        $this->setIfExists('mobilePhone', $data ?? [], null);
        $this->setIfExists('notificationURL', $data ?? [], null);
        $this->setIfExists('payTokenInd', $data ?? [], null);
        $this->setIfExists('paymentAuthenticationUseCase', $data ?? [], null);
        $this->setIfExists('purchaseInstalData', $data ?? [], null);
        $this->setIfExists('recurringExpiry', $data ?? [], null);
        $this->setIfExists('recurringFrequency', $data ?? [], null);
        $this->setIfExists('sdkAppID', $data ?? [], null);
        $this->setIfExists('sdkEphemPubKey', $data ?? [], null);
        $this->setIfExists('sdkMaxTimeout', $data ?? [], null);
        $this->setIfExists('sdkReferenceNumber', $data ?? [], null);
        $this->setIfExists('sdkTransID', $data ?? [], null);
        $this->setIfExists('threeDSCompInd', $data ?? [], null);
        $this->setIfExists('threeDSRequestorAuthenticationInd', $data ?? [], null);
        $this->setIfExists('threeDSRequestorAuthenticationInfo', $data ?? [], null);
        $this->setIfExists('threeDSRequestorChallengeInd', $data ?? [], null);
        $this->setIfExists('threeDSRequestorID', $data ?? [], null);
        $this->setIfExists('threeDSRequestorName', $data ?? [], null);
        $this->setIfExists('threeDSRequestorPriorAuthenticationInfo', $data ?? [], null);
        $this->setIfExists('threeDSRequestorURL', $data ?? [], null);
        $this->setIfExists('transType', $data ?? [], null);
        $this->setIfExists('transactionType', $data ?? [], null);
        $this->setIfExists('whiteListStatus', $data ?? [], null);
        $this->setIfExists('workPhone', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getAcctTypeAllowableValues();
        if (!is_null($this->container['acctType']) && !in_array($this->container['acctType'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'acctType', must be one of '%s'",
                $this->container['acctType'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getAddrMatchAllowableValues();
        if (!is_null($this->container['addrMatch']) && !in_array($this->container['addrMatch'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'addrMatch', must be one of '%s'",
                $this->container['addrMatch'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getChallengeIndicatorAllowableValues();
        if (!is_null($this->container['challengeIndicator']) && !in_array($this->container['challengeIndicator'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'challengeIndicator', must be one of '%s'",
                $this->container['challengeIndicator'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getThreeDSRequestorChallengeIndAllowableValues();
        if (!is_null($this->container['threeDSRequestorChallengeInd']) && !in_array($this->container['threeDSRequestorChallengeInd'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'threeDSRequestorChallengeInd', must be one of '%s'",
                $this->container['threeDSRequestorChallengeInd'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getTransTypeAllowableValues();
        if (!is_null($this->container['transType']) && !in_array($this->container['transType'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'transType', must be one of '%s'",
                $this->container['transType'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getTransactionTypeAllowableValues();
        if (!is_null($this->container['transactionType']) && !in_array($this->container['transactionType'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'transactionType', must be one of '%s'",
                $this->container['transactionType'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets acctInfo
     *
     * @return \Adyen\Model\Checkout\AcctInfo|null
     */
    public function getAcctInfo()
    {
        return $this->container['acctInfo'];
    }

    /**
     * Sets acctInfo
     *
     * @param \Adyen\Model\Checkout\AcctInfo|null $acctInfo acctInfo
     *
     * @return self
     */
    public function setAcctInfo($acctInfo)
    {
        $this->container['acctInfo'] = $acctInfo;

        return $this;
    }

    /**
     * Gets acctType
     *
     * @return string|null
     */
    public function getAcctType()
    {
        return $this->container['acctType'];
    }

    /**
     * Sets acctType
     *
     * @param string|null $acctType Indicates the type of account. For example, for a multi-account card product. Length: 2 characters. Allowed values: * **01** — Not applicable * **02** — Credit * **03** — Debit
     *
     * @return self
     */
    public function setAcctType($acctType)
    {
        $allowedValues = $this->getAcctTypeAllowableValues();
        if (!in_array($acctType, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'acctType', must be one of '%s'",
                    $acctType,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['acctType'] = $acctType;

        return $this;
    }

    /**
     * Gets acquirerBIN
     *
     * @return string|null
     */
    public function getAcquirerBIN()
    {
        return $this->container['acquirerBIN'];
    }

    /**
     * Sets acquirerBIN
     *
     * @param string|null $acquirerBIN Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The acquiring BIN enrolled for 3D Secure 2. This string should match the value that you will use in the authorisation. Use 123456 on the Test platform.
     *
     * @return self
     */
    public function setAcquirerBIN($acquirerBIN)
    {
        $this->container['acquirerBIN'] = $acquirerBIN;

        return $this;
    }

    /**
     * Gets acquirerMerchantID
     *
     * @return string|null
     */
    public function getAcquirerMerchantID()
    {
        return $this->container['acquirerMerchantID'];
    }

    /**
     * Sets acquirerMerchantID
     *
     * @param string|null $acquirerMerchantID Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The merchantId that is enrolled for 3D Secure 2 by the merchant's acquirer. This string should match the value that you will use in the authorisation. Use 123456 on the Test platform.
     *
     * @return self
     */
    public function setAcquirerMerchantID($acquirerMerchantID)
    {
        $this->container['acquirerMerchantID'] = $acquirerMerchantID;

        return $this;
    }

    /**
     * Gets addrMatch
     *
     * @return string|null
     */
    public function getAddrMatch()
    {
        return $this->container['addrMatch'];
    }

    /**
     * Sets addrMatch
     *
     * @param string|null $addrMatch Indicates whether the Cardholder Shipping Address and Cardholder Billing Address are the same. Allowed values: * **Y** — Shipping Address matches Billing Address. * **N** — Shipping Address does not match Billing Address.
     *
     * @return self
     */
    public function setAddrMatch($addrMatch)
    {
        $allowedValues = $this->getAddrMatchAllowableValues();
        if (!in_array($addrMatch, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'addrMatch', must be one of '%s'",
                    $addrMatch,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['addrMatch'] = $addrMatch;

        return $this;
    }

    /**
     * Gets authenticationOnly
     *
     * @return bool|null
     * @deprecated
     */
    public function getAuthenticationOnly()
    {
        return $this->container['authenticationOnly'];
    }

    /**
     * Sets authenticationOnly
     *
     * @param bool|null $authenticationOnly If set to true, you will only perform the [3D Secure 2 authentication](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only), and not the payment authorisation.
     *
     * @return self
     * @deprecated
     */
    public function setAuthenticationOnly($authenticationOnly)
    {
        $this->container['authenticationOnly'] = $authenticationOnly;

        return $this;
    }

    /**
     * Gets challengeIndicator
     *
     * @return string|null
     * @deprecated
     */
    public function getChallengeIndicator()
    {
        return $this->container['challengeIndicator'];
    }

    /**
     * Sets challengeIndicator
     *
     * @param string|null $challengeIndicator Possibility to specify a preference for receiving a challenge from the issuer. Allowed values: * `noPreference` * `requestNoChallenge` * `requestChallenge` * `requestChallengeAsMandate`
     *
     * @return self
     * @deprecated
     */
    public function setChallengeIndicator($challengeIndicator)
    {
        $allowedValues = $this->getChallengeIndicatorAllowableValues();
        if (!in_array($challengeIndicator, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'challengeIndicator', must be one of '%s'",
                    $challengeIndicator,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['challengeIndicator'] = $challengeIndicator;

        return $this;
    }

    /**
     * Gets deviceRenderOptions
     *
     * @return \Adyen\Model\Checkout\DeviceRenderOptions|null
     */
    public function getDeviceRenderOptions()
    {
        return $this->container['deviceRenderOptions'];
    }

    /**
     * Sets deviceRenderOptions
     *
     * @param \Adyen\Model\Checkout\DeviceRenderOptions|null $deviceRenderOptions deviceRenderOptions
     *
     * @return self
     */
    public function setDeviceRenderOptions($deviceRenderOptions)
    {
        $this->container['deviceRenderOptions'] = $deviceRenderOptions;

        return $this;
    }

    /**
     * Gets homePhone
     *
     * @return \Adyen\Model\Checkout\Phone|null
     */
    public function getHomePhone()
    {
        return $this->container['homePhone'];
    }

    /**
     * Sets homePhone
     *
     * @param \Adyen\Model\Checkout\Phone|null $homePhone homePhone
     *
     * @return self
     */
    public function setHomePhone($homePhone)
    {
        $this->container['homePhone'] = $homePhone;

        return $this;
    }

    /**
     * Gets mcc
     *
     * @return string|null
     */
    public function getMcc()
    {
        return $this->container['mcc'];
    }

    /**
     * Sets mcc
     *
     * @param string|null $mcc Required for merchants that have been enrolled for 3D Secure 2 by another party than Adyen, mostly [authentication-only integrations](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The `mcc` is a four-digit code with which the previously given `acquirerMerchantID` is registered at the scheme.
     *
     * @return self
     */
    public function setMcc($mcc)
    {
        $this->container['mcc'] = $mcc;

        return $this;
    }

    /**
     * Gets merchantName
     *
     * @return string|null
     */
    public function getMerchantName()
    {
        return $this->container['merchantName'];
    }

    /**
     * Sets merchantName
     *
     * @param string|null $merchantName Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). The merchant name that the issuer presents to the shopper if they get a challenge. We recommend to use the same value that you will use in the authorization. Maximum length is 40 characters. > Optional for a [full 3D Secure 2 integration](https://docs.adyen.com/online-payments/3d-secure/native-3ds2/api-integration). Use this field if you are enrolled for 3D Secure 2 with us and want to override the merchant name already configured on your account.
     *
     * @return self
     */
    public function setMerchantName($merchantName)
    {
        $this->container['merchantName'] = $merchantName;

        return $this;
    }

    /**
     * Gets messageVersion
     *
     * @return string|null
     */
    public function getMessageVersion()
    {
        return $this->container['messageVersion'];
    }

    /**
     * Sets messageVersion
     *
     * @param string|null $messageVersion The `messageVersion` value indicating the 3D Secure 2 protocol version.
     *
     * @return self
     */
    public function setMessageVersion($messageVersion)
    {
        $this->container['messageVersion'] = $messageVersion;

        return $this;
    }

    /**
     * Gets mobilePhone
     *
     * @return \Adyen\Model\Checkout\Phone|null
     */
    public function getMobilePhone()
    {
        return $this->container['mobilePhone'];
    }

    /**
     * Sets mobilePhone
     *
     * @param \Adyen\Model\Checkout\Phone|null $mobilePhone mobilePhone
     *
     * @return self
     */
    public function setMobilePhone($mobilePhone)
    {
        $this->container['mobilePhone'] = $mobilePhone;

        return $this;
    }

    /**
     * Gets notificationURL
     *
     * @return string|null
     */
    public function getNotificationURL()
    {
        return $this->container['notificationURL'];
    }

    /**
     * Sets notificationURL
     *
     * @param string|null $notificationURL URL to where the issuer should send the `CRes`. Required if you are not using components for `channel` **Web** or if you are using classic integration `deviceChannel` **browser**.
     *
     * @return self
     */
    public function setNotificationURL($notificationURL)
    {
        $this->container['notificationURL'] = $notificationURL;

        return $this;
    }

    /**
     * Gets payTokenInd
     *
     * @return bool|null
     */
    public function getPayTokenInd()
    {
        return $this->container['payTokenInd'];
    }

    /**
     * Sets payTokenInd
     *
     * @param bool|null $payTokenInd Value **true** indicates that the transaction was de-tokenised prior to being received by the ACS.
     *
     * @return self
     */
    public function setPayTokenInd($payTokenInd)
    {
        $this->container['payTokenInd'] = $payTokenInd;

        return $this;
    }

    /**
     * Gets paymentAuthenticationUseCase
     *
     * @return string|null
     */
    public function getPaymentAuthenticationUseCase()
    {
        return $this->container['paymentAuthenticationUseCase'];
    }

    /**
     * Sets paymentAuthenticationUseCase
     *
     * @param string|null $paymentAuthenticationUseCase Indicates the type of payment for which an authentication is requested (message extension)
     *
     * @return self
     */
    public function setPaymentAuthenticationUseCase($paymentAuthenticationUseCase)
    {
        $this->container['paymentAuthenticationUseCase'] = $paymentAuthenticationUseCase;

        return $this;
    }

    /**
     * Gets purchaseInstalData
     *
     * @return string|null
     */
    public function getPurchaseInstalData()
    {
        return $this->container['purchaseInstalData'];
    }

    /**
     * Sets purchaseInstalData
     *
     * @param string|null $purchaseInstalData Indicates the maximum number of authorisations permitted for instalment payments. Length: 1–3 characters.
     *
     * @return self
     */
    public function setPurchaseInstalData($purchaseInstalData)
    {
        $this->container['purchaseInstalData'] = $purchaseInstalData;

        return $this;
    }

    /**
     * Gets recurringExpiry
     *
     * @return string|null
     */
    public function getRecurringExpiry()
    {
        return $this->container['recurringExpiry'];
    }

    /**
     * Sets recurringExpiry
     *
     * @param string|null $recurringExpiry Date after which no further authorisations shall be performed. Format: YYYYMMDD
     *
     * @return self
     */
    public function setRecurringExpiry($recurringExpiry)
    {
        $this->container['recurringExpiry'] = $recurringExpiry;

        return $this;
    }

    /**
     * Gets recurringFrequency
     *
     * @return string|null
     */
    public function getRecurringFrequency()
    {
        return $this->container['recurringFrequency'];
    }

    /**
     * Sets recurringFrequency
     *
     * @param string|null $recurringFrequency Indicates the minimum number of days between authorisations. Maximum length: 4 characters.
     *
     * @return self
     */
    public function setRecurringFrequency($recurringFrequency)
    {
        $this->container['recurringFrequency'] = $recurringFrequency;

        return $this;
    }

    /**
     * Gets sdkAppID
     *
     * @return string|null
     */
    public function getSdkAppID()
    {
        return $this->container['sdkAppID'];
    }

    /**
     * Sets sdkAppID
     *
     * @param string|null $sdkAppID The `sdkAppID` value as received from the 3D Secure 2 SDK.
     *
     * @return self
     */
    public function setSdkAppID($sdkAppID)
    {
        $this->container['sdkAppID'] = $sdkAppID;

        return $this;
    }

    /**
     * Gets sdkEphemPubKey
     *
     * @return \Adyen\Model\Checkout\SDKEphemPubKey|null
     */
    public function getSdkEphemPubKey()
    {
        return $this->container['sdkEphemPubKey'];
    }

    /**
     * Sets sdkEphemPubKey
     *
     * @param \Adyen\Model\Checkout\SDKEphemPubKey|null $sdkEphemPubKey sdkEphemPubKey
     *
     * @return self
     */
    public function setSdkEphemPubKey($sdkEphemPubKey)
    {
        $this->container['sdkEphemPubKey'] = $sdkEphemPubKey;

        return $this;
    }

    /**
     * Gets sdkMaxTimeout
     *
     * @return int|null
     */
    public function getSdkMaxTimeout()
    {
        return $this->container['sdkMaxTimeout'];
    }

    /**
     * Sets sdkMaxTimeout
     *
     * @param int|null $sdkMaxTimeout The maximum amount of time in minutes for the 3D Secure 2 authentication process. Optional and only for `deviceChannel` set to **app**. Defaults to **60** minutes.
     *
     * @return self
     */
    public function setSdkMaxTimeout($sdkMaxTimeout)
    {
        $this->container['sdkMaxTimeout'] = $sdkMaxTimeout;

        return $this;
    }

    /**
     * Gets sdkReferenceNumber
     *
     * @return string|null
     */
    public function getSdkReferenceNumber()
    {
        return $this->container['sdkReferenceNumber'];
    }

    /**
     * Sets sdkReferenceNumber
     *
     * @param string|null $sdkReferenceNumber The `sdkReferenceNumber` value as received from the 3D Secure 2 SDK.
     *
     * @return self
     */
    public function setSdkReferenceNumber($sdkReferenceNumber)
    {
        $this->container['sdkReferenceNumber'] = $sdkReferenceNumber;

        return $this;
    }

    /**
     * Gets sdkTransID
     *
     * @return string|null
     */
    public function getSdkTransID()
    {
        return $this->container['sdkTransID'];
    }

    /**
     * Sets sdkTransID
     *
     * @param string|null $sdkTransID The `sdkTransID` value as received from the 3D Secure 2 SDK.
     *
     * @return self
     */
    public function setSdkTransID($sdkTransID)
    {
        $this->container['sdkTransID'] = $sdkTransID;

        return $this;
    }

    /**
     * Gets threeDSCompInd
     *
     * @return string|null
     */
    public function getThreeDSCompInd()
    {
        return $this->container['threeDSCompInd'];
    }

    /**
     * Sets threeDSCompInd
     *
     * @param string|null $threeDSCompInd Completion indicator for the device fingerprinting.
     *
     * @return self
     */
    public function setThreeDSCompInd($threeDSCompInd)
    {
        $this->container['threeDSCompInd'] = $threeDSCompInd;

        return $this;
    }

    /**
     * Gets threeDSRequestorAuthenticationInd
     *
     * @return string|null
     */
    public function getThreeDSRequestorAuthenticationInd()
    {
        return $this->container['threeDSRequestorAuthenticationInd'];
    }

    /**
     * Sets threeDSRequestorAuthenticationInd
     *
     * @param string|null $threeDSRequestorAuthenticationInd Indicates the type of Authentication request.
     *
     * @return self
     */
    public function setThreeDSRequestorAuthenticationInd($threeDSRequestorAuthenticationInd)
    {
        $this->container['threeDSRequestorAuthenticationInd'] = $threeDSRequestorAuthenticationInd;

        return $this;
    }

    /**
     * Gets threeDSRequestorAuthenticationInfo
     *
     * @return \Adyen\Model\Checkout\ThreeDSRequestorAuthenticationInfo|null
     */
    public function getThreeDSRequestorAuthenticationInfo()
    {
        return $this->container['threeDSRequestorAuthenticationInfo'];
    }

    /**
     * Sets threeDSRequestorAuthenticationInfo
     *
     * @param \Adyen\Model\Checkout\ThreeDSRequestorAuthenticationInfo|null $threeDSRequestorAuthenticationInfo threeDSRequestorAuthenticationInfo
     *
     * @return self
     */
    public function setThreeDSRequestorAuthenticationInfo($threeDSRequestorAuthenticationInfo)
    {
        $this->container['threeDSRequestorAuthenticationInfo'] = $threeDSRequestorAuthenticationInfo;

        return $this;
    }

    /**
     * Gets threeDSRequestorChallengeInd
     *
     * @return string|null
     */
    public function getThreeDSRequestorChallengeInd()
    {
        return $this->container['threeDSRequestorChallengeInd'];
    }

    /**
     * Sets threeDSRequestorChallengeInd
     *
     * @param string|null $threeDSRequestorChallengeInd Indicates whether a challenge is requested for this transaction. Possible values: * **01** — No preference * **02** — No challenge requested * **03** — Challenge requested (3DS Requestor preference) * **04** — Challenge requested (Mandate) * **05** — No challenge (transactional risk analysis is already performed) * **06** — Data Only
     *
     * @return self
     */
    public function setThreeDSRequestorChallengeInd($threeDSRequestorChallengeInd)
    {
        $allowedValues = $this->getThreeDSRequestorChallengeIndAllowableValues();
        if (!in_array($threeDSRequestorChallengeInd, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'threeDSRequestorChallengeInd', must be one of '%s'",
                    $threeDSRequestorChallengeInd,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['threeDSRequestorChallengeInd'] = $threeDSRequestorChallengeInd;

        return $this;
    }

    /**
     * Gets threeDSRequestorID
     *
     * @return string|null
     */
    public function getThreeDSRequestorID()
    {
        return $this->container['threeDSRequestorID'];
    }

    /**
     * Sets threeDSRequestorID
     *
     * @param string|null $threeDSRequestorID Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only) for Visa. Unique 3D Secure requestor identifier assigned by the Directory Server when you enrol for 3D Secure 2.
     *
     * @return self
     */
    public function setThreeDSRequestorID($threeDSRequestorID)
    {
        $this->container['threeDSRequestorID'] = $threeDSRequestorID;

        return $this;
    }

    /**
     * Gets threeDSRequestorName
     *
     * @return string|null
     */
    public function getThreeDSRequestorName()
    {
        return $this->container['threeDSRequestorName'];
    }

    /**
     * Sets threeDSRequestorName
     *
     * @param string|null $threeDSRequestorName Required for [authentication-only integration](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only) for Visa. Unique 3D Secure requestor name assigned by the Directory Server when you enrol for 3D Secure 2.
     *
     * @return self
     */
    public function setThreeDSRequestorName($threeDSRequestorName)
    {
        $this->container['threeDSRequestorName'] = $threeDSRequestorName;

        return $this;
    }

    /**
     * Gets threeDSRequestorPriorAuthenticationInfo
     *
     * @return \Adyen\Model\Checkout\ThreeDSRequestorPriorAuthenticationInfo|null
     */
    public function getThreeDSRequestorPriorAuthenticationInfo()
    {
        return $this->container['threeDSRequestorPriorAuthenticationInfo'];
    }

    /**
     * Sets threeDSRequestorPriorAuthenticationInfo
     *
     * @param \Adyen\Model\Checkout\ThreeDSRequestorPriorAuthenticationInfo|null $threeDSRequestorPriorAuthenticationInfo threeDSRequestorPriorAuthenticationInfo
     *
     * @return self
     */
    public function setThreeDSRequestorPriorAuthenticationInfo($threeDSRequestorPriorAuthenticationInfo)
    {
        $this->container['threeDSRequestorPriorAuthenticationInfo'] = $threeDSRequestorPriorAuthenticationInfo;

        return $this;
    }

    /**
     * Gets threeDSRequestorURL
     *
     * @return string|null
     */
    public function getThreeDSRequestorURL()
    {
        return $this->container['threeDSRequestorURL'];
    }

    /**
     * Sets threeDSRequestorURL
     *
     * @param string|null $threeDSRequestorURL URL of the (customer service) website that will be shown to the shopper in case of technical errors during the 3D Secure 2 process.
     *
     * @return self
     */
    public function setThreeDSRequestorURL($threeDSRequestorURL)
    {
        $this->container['threeDSRequestorURL'] = $threeDSRequestorURL;

        return $this;
    }

    /**
     * Gets transType
     *
     * @return string|null
     */
    public function getTransType()
    {
        return $this->container['transType'];
    }

    /**
     * Sets transType
     *
     * @param string|null $transType Identifies the type of transaction being authenticated. Length: 2 characters. Allowed values: * **01** — Goods/Service Purchase * **03** — Check Acceptance * **10** — Account Funding * **11** — Quasi-Cash Transaction * **28** — Prepaid Activation and Load
     *
     * @return self
     */
    public function setTransType($transType)
    {
        $allowedValues = $this->getTransTypeAllowableValues();
        if (!in_array($transType, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'transType', must be one of '%s'",
                    $transType,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['transType'] = $transType;

        return $this;
    }

    /**
     * Gets transactionType
     *
     * @return string|null
     */
    public function getTransactionType()
    {
        return $this->container['transactionType'];
    }

    /**
     * Sets transactionType
     *
     * @param string|null $transactionType Identify the type of the transaction being authenticated.
     *
     * @return self
     */
    public function setTransactionType($transactionType)
    {
        $allowedValues = $this->getTransactionTypeAllowableValues();
        if (!in_array($transactionType, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'transactionType', must be one of '%s'",
                    $transactionType,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['transactionType'] = $transactionType;

        return $this;
    }

    /**
     * Gets whiteListStatus
     *
     * @return string|null
     */
    public function getWhiteListStatus()
    {
        return $this->container['whiteListStatus'];
    }

    /**
     * Sets whiteListStatus
     *
     * @param string|null $whiteListStatus The `whiteListStatus` value returned from a previous 3D Secure 2 transaction, only applicable for 3D Secure 2 protocol version 2.2.0.
     *
     * @return self
     */
    public function setWhiteListStatus($whiteListStatus)
    {
        $this->container['whiteListStatus'] = $whiteListStatus;

        return $this;
    }

    /**
     * Gets workPhone
     *
     * @return \Adyen\Model\Checkout\Phone|null
     */
    public function getWorkPhone()
    {
        return $this->container['workPhone'];
    }

    /**
     * Sets workPhone
     *
     * @param \Adyen\Model\Checkout\Phone|null $workPhone workPhone
     *
     * @return self
     */
    public function setWorkPhone($workPhone)
    {
        $this->container['workPhone'] = $workPhone;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    public function toArray(): array
    {
        $array = [];
        foreach (self::$openAPITypes as $propertyName => $propertyType) {
            $propertyValue = $this[$propertyName];
            if ($propertyValue !== null) {
                // Check if the property value is an object and has a toArray() method
                if (is_object($propertyValue) && method_exists($propertyValue, 'toArray')) {
                    $array[$propertyName] = $propertyValue->toArray();
                // Check if it's type datetime
                } elseif ($propertyValue instanceof \DateTime) {
                    $array[$propertyName] = $propertyValue->format(DATE_ATOM);
                // If it's an array type we should check whether it contains objects and if so call toArray method
                } elseif (is_array($propertyValue)) {
                    $array[$propertyName] = array_map(function ($item) {
                        return $item instanceof ModelInterface ? $item->toArray() : $item;
                    }, $propertyValue);
                } else {
                    // Otherwise, directly assign the property value to the array
                    $array[$propertyName] = $propertyValue;
                }
            }
        }
        return $array;
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}
