<?php
/**
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Adyen\Service\BalancePlatform;

use Adyen\AdyenException;
use Adyen\Client;
use Adyen\Service;
use Adyen\Model\BalancePlatform\ObjectSerializer;

class ManageCardPINApi extends Service
{
    /**
     * @var array|string|string[]
     */
    private $baseURL;

    /**
     * ManageCardPINApi constructor.
     *
     * @param \Adyen\Client $client
     * @throws AdyenException
     */
    public function __construct(Client $client)
    {
        parent::__construct($client);

        // Create the baseUrl based on live/test and optional live-url-prefix
        $this->baseURL = $this->createBaseUrl("https://balanceplatform-api-test.adyen.com/bcl/v2");
    }

    /**
    * Change a card PIN
    *
    * @param \Adyen\Model\BalancePlatform\PinChangeRequest $pinChangeRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\BalancePlatform\PinChangeResponse
    * @throws AdyenException
    */
    public function changeCardPin(\Adyen\Model\BalancePlatform\PinChangeRequest $pinChangeRequest, array $requestOptions = null): \Adyen\Model\BalancePlatform\PinChangeResponse
    {
        $endpoint = $this->baseURL . "/pins/change";
        $response = $this->requestHttp($endpoint, strtolower('POST'), (array) $pinChangeRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\BalancePlatform\PinChangeResponse::class);
    }

    /**
    * Get an RSA public key
    *
    * @param array|null $requestOptions ['queryParams' => ['purpose'=> string, 'format'=> string]]
    * @return \Adyen\Model\BalancePlatform\PublicKeyResponse
    * @throws AdyenException
    */
    public function publicKey(array $requestOptions = null): \Adyen\Model\BalancePlatform\PublicKeyResponse
    {
        $endpoint = $this->baseURL . "/publicKey";
        $response = $this->requestHttp($endpoint, strtolower('GET'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\BalancePlatform\PublicKeyResponse::class);
    }

    /**
    * Reveal a card PIN
    *
    * @param \Adyen\Model\BalancePlatform\RevealPinRequest $revealPinRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\BalancePlatform\RevealPinResponse
    * @throws AdyenException
    */
    public function revealCardPin(\Adyen\Model\BalancePlatform\RevealPinRequest $revealPinRequest, array $requestOptions = null): \Adyen\Model\BalancePlatform\RevealPinResponse
    {
        $endpoint = $this->baseURL . "/pins/reveal";
        $response = $this->requestHttp($endpoint, strtolower('POST'), (array) $revealPinRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\BalancePlatform\RevealPinResponse::class);
    }
}
