<?php
/**
 * Configuration API
 *
 * The version of the OpenAPI document: 2
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Adyen\Service\BalancePlatform;

use Adyen\AdyenException;
use Adyen\Client;
use Adyen\Service;
use Adyen\Model\BalancePlatform\ObjectSerializer;

class PaymentInstrumentsApi extends Service
{
    /**
     * @var array|string|string[]
     */
    private $baseURL;

    /**
     * PaymentInstrumentsApi constructor.
     *
     * @param \Adyen\Client $client
     * @throws AdyenException
     */
    public function __construct(Client $client)
    {
        parent::__construct($client);

        // Create the baseUrl based on live/test and optional live-url-prefix
        $this->baseURL = $this->createBaseUrl("https://balanceplatform-api-test.adyen.com/bcl/v2");
    }

    /**
    * Create a payment instrument
    *
    * @param \Adyen\Model\BalancePlatform\PaymentInstrumentInfo $paymentInstrumentInfo
    * @param array|null $requestOptions
    * @return \Adyen\Model\BalancePlatform\PaymentInstrument
    * @throws AdyenException
    */
    public function createPaymentInstrument(\Adyen\Model\BalancePlatform\PaymentInstrumentInfo $paymentInstrumentInfo, array $requestOptions = null): \Adyen\Model\BalancePlatform\PaymentInstrument
    {
        $endpoint = $this->baseURL . "/paymentInstruments";
        $response = $this->requestHttp($endpoint, strtolower('POST'), (array) $paymentInstrumentInfo->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\BalancePlatform\PaymentInstrument::class);
    }

    /**
    * Get all transaction rules for a payment instrument
    *
    * @param string $id
    * @param array|null $requestOptions
    * @return \Adyen\Model\BalancePlatform\TransactionRulesResponse
    * @throws AdyenException
    */
    public function getAllTransactionRulesForPaymentInstrument(string $id, array $requestOptions = null): \Adyen\Model\BalancePlatform\TransactionRulesResponse
    {
        $endpoint = $this->baseURL . str_replace(['{id}'], [$id], "/paymentInstruments/{id}/transactionRules");
        $response = $this->requestHttp($endpoint, strtolower('GET'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\BalancePlatform\TransactionRulesResponse::class);
    }

    /**
    * Get the PAN of a payment instrument
    *
    * @param string $id
    * @param array|null $requestOptions
    * @return \Adyen\Model\BalancePlatform\PaymentInstrumentRevealInfo
    * @throws AdyenException
    */
    public function getPanOfPaymentInstrument(string $id, array $requestOptions = null): \Adyen\Model\BalancePlatform\PaymentInstrumentRevealInfo
    {
        $endpoint = $this->baseURL . str_replace(['{id}'], [$id], "/paymentInstruments/{id}/reveal");
        $response = $this->requestHttp($endpoint, strtolower('GET'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\BalancePlatform\PaymentInstrumentRevealInfo::class);
    }

    /**
    * Get a payment instrument
    *
    * @param string $id
    * @param array|null $requestOptions
    * @return \Adyen\Model\BalancePlatform\PaymentInstrument
    * @throws AdyenException
    */
    public function getPaymentInstrument(string $id, array $requestOptions = null): \Adyen\Model\BalancePlatform\PaymentInstrument
    {
        $endpoint = $this->baseURL . str_replace(['{id}'], [$id], "/paymentInstruments/{id}");
        $response = $this->requestHttp($endpoint, strtolower('GET'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\BalancePlatform\PaymentInstrument::class);
    }

    /**
    * List network tokens
    *
    * @param string $id
    * @param array|null $requestOptions
    * @return \Adyen\Model\BalancePlatform\ListNetworkTokensResponse
    * @throws AdyenException
    */
    public function listNetworkTokens(string $id, array $requestOptions = null): \Adyen\Model\BalancePlatform\ListNetworkTokensResponse
    {
        $endpoint = $this->baseURL . str_replace(['{id}'], [$id], "/paymentInstruments/{id}/networkTokens");
        $response = $this->requestHttp($endpoint, strtolower('GET'), null, $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\BalancePlatform\ListNetworkTokensResponse::class);
    }

    /**
    * Reveal the data of a payment instrument
    *
    * @param \Adyen\Model\BalancePlatform\PaymentInstrumentRevealRequest $paymentInstrumentRevealRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\BalancePlatform\PaymentInstrumentRevealResponse
    * @throws AdyenException
    */
    public function revealDataOfPaymentInstrument(\Adyen\Model\BalancePlatform\PaymentInstrumentRevealRequest $paymentInstrumentRevealRequest, array $requestOptions = null): \Adyen\Model\BalancePlatform\PaymentInstrumentRevealResponse
    {
        $endpoint = $this->baseURL . "/paymentInstruments/reveal";
        $response = $this->requestHttp($endpoint, strtolower('POST'), (array) $paymentInstrumentRevealRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\BalancePlatform\PaymentInstrumentRevealResponse::class);
    }

    /**
    * Update a payment instrument
    *
    * @param string $id
    * @param \Adyen\Model\BalancePlatform\PaymentInstrumentUpdateRequest $paymentInstrumentUpdateRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\BalancePlatform\UpdatePaymentInstrument
    * @throws AdyenException
    */
    public function updatePaymentInstrument(string $id, \Adyen\Model\BalancePlatform\PaymentInstrumentUpdateRequest $paymentInstrumentUpdateRequest, array $requestOptions = null): \Adyen\Model\BalancePlatform\UpdatePaymentInstrument
    {
        $endpoint = $this->baseURL . str_replace(['{id}'], [$id], "/paymentInstruments/{id}");
        $response = $this->requestHttp($endpoint, strtolower('PATCH'), (array) $paymentInstrumentUpdateRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\BalancePlatform\UpdatePaymentInstrument::class);
    }
}
