<?php
/**
 * Adyen Payout API
 *
 * The version of the OpenAPI document: 68
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Adyen\Service\Payout;

use Adyen\AdyenException;
use Adyen\Client;
use Adyen\Service;
use Adyen\Model\Payout\ObjectSerializer;

class InstantPayoutsApi extends Service
{
    /**
     * @var array|string|string[]
     */
    private $baseURL;

    /**
     * InstantPayoutsApi constructor.
     *
     * @param \Adyen\Client $client
     * @throws AdyenException
     */
    public function __construct(Client $client)
    {
        parent::__construct($client);

        // Create the baseUrl based on live/test and optional live-url-prefix
        $this->baseURL = $this->createBaseUrl("https://pal-test.adyen.com/pal/servlet/Payout/v68");
    }

    /**
    * Make an instant card payout
    *
    * @param \Adyen\Model\Payout\PayoutRequest $payoutRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\Payout\PayoutResponse
    * @throws AdyenException
    */
    public function payout(\Adyen\Model\Payout\PayoutRequest $payoutRequest, array $requestOptions = null): \Adyen\Model\Payout\PayoutResponse
    {
        $endpoint = $this->baseURL . "/payout";
        $response = $this->requestHttp($endpoint, strtolower('POST'), (array) $payoutRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Payout\PayoutResponse::class);
    }
}
