<?php
/**
 * Adyen Payout API
 *
 * The version of the OpenAPI document: 68
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Adyen\Service\Payout;

use Adyen\AdyenException;
use Adyen\Client;
use Adyen\Service;
use Adyen\Model\Payout\ObjectSerializer;

class ReviewingApi extends Service
{
    /**
     * @var array|string|string[]
     */
    private $baseURL;

    /**
     * ReviewingApi constructor.
     *
     * @param \Adyen\Client $client
     * @throws AdyenException
     */
    public function __construct(Client $client)
    {
        parent::__construct($client);

        // Create the baseUrl based on live/test and optional live-url-prefix
        $this->baseURL = $this->createBaseUrl("https://pal-test.adyen.com/pal/servlet/Payout/v68");
    }

    /**
    * Confirm a payout
    *
    * @param \Adyen\Model\Payout\ModifyRequest $modifyRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\Payout\ModifyResponse
    * @throws AdyenException
    */
    public function confirmThirdParty(\Adyen\Model\Payout\ModifyRequest $modifyRequest, array $requestOptions = null): \Adyen\Model\Payout\ModifyResponse
    {
        $endpoint = $this->baseURL . "/confirmThirdParty";
        $response = $this->requestHttp($endpoint, strtolower('POST'), (array) $modifyRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Payout\ModifyResponse::class);
    }

    /**
    * Cancel a payout
    *
    * @param \Adyen\Model\Payout\ModifyRequest $modifyRequest
    * @param array|null $requestOptions
    * @return \Adyen\Model\Payout\ModifyResponse
    * @throws AdyenException
    */
    public function declineThirdParty(\Adyen\Model\Payout\ModifyRequest $modifyRequest, array $requestOptions = null): \Adyen\Model\Payout\ModifyResponse
    {
        $endpoint = $this->baseURL . "/declineThirdParty";
        $response = $this->requestHttp($endpoint, strtolower('POST'), (array) $modifyRequest->jsonSerialize(), $requestOptions);
        return ObjectSerializer::deserialize($response, \Adyen\Model\Payout\ModifyResponse::class);
    }
}
