const mix = require('laravel-mix');
const { exec } = require('child_process');

mix
.sourceMaps()
.postCss('resources/css/tailwind.css', 'public/assets/tendra.css', [require("tailwindcss")])
.postCss('resources/css/tailwind2.css', 'public/assets/axies.css', [require("tailwindcss")])
.options({
	processCssUrls: false,
  	postCss: [],
})
.browserSync({
  proxy: "https://valexa_4.co/",
  https: false,
  watch: true,
  port: 6565,
  notify: false,
  files: [
    "resources/views/front/tendra/**/*.php",
    "resources/views/front/axies/**/*.php",
    "public/assets/tendra.js",
    "public/assets/axies.js",
    //"resources/views/auth/**/*.php",
    "resources/views/vendor/pagination/tailwind.blade.php",
    "resources/views/vendor/pagination/simple-tailwind.blade.php", 
    //"public/assets/app.js",
  ]
})

/*.sass('resources/sass/tendra-front-ltr.scss', 'public/assets/front/tendra-ltr.css')
.sass('resources/sass/axies-front-ltr.scss', 'public/assets/front/axies-ltr.css')
.sass('resources/sass/back-ltr.scss', 'public/assets/admin/app-ltr.css')
.sass('resources/sass/affiliate-ltr.scss', 'public/assets/front/affiliate-ltr.css')
.js('resources/js/tendra-front.js', 'public/assets/front/tendra.js')
.js('resources/js/axies-front.js', 'public/assets/front/axies.js')
.js('resources/js/back.js', 'public/assets/admin/app.js');


exec("rtlcss public/assets/front/tendra-ltr.css ./public/assets/front/tendra-rtl.css");
exec("rtlcss public/assets/front/axies-ltr.css ./public/assets/front/axies-rtl.css");
exec("rtlcss public/assets/admin/app-ltr.css ./public/assets/admin/app-rtl.css");
exec("rtlcss public/assets/front/affiliate-ltr.css ./public/assets/front/affiliate-rtl.css");*/
